/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.bolt.broker.client;

import com.alipay.remoting.ConnectionEventType;
import com.iohao.game.action.skeleton.core.BarSkeleton;
import com.iohao.game.action.skeleton.toy.IoGameBanner;
import com.iohao.game.bolt.broker.client.BrokerClientStartup;
import com.iohao.game.bolt.broker.client.processor.BrokerClientOfflineMessageLogicProcessor;
import com.iohao.game.bolt.broker.client.processor.BrokerClientOnlineMessageLogicProcessor;
import com.iohao.game.bolt.broker.client.processor.BrokerClusterMessageClientProcessor;
import com.iohao.game.bolt.broker.client.processor.EventBusMessageClientProcessor;
import com.iohao.game.bolt.broker.client.processor.RequestBrokerClientModuleMessageClientProcessor;
import com.iohao.game.bolt.broker.client.processor.RequestMessageClientProcessor;
import com.iohao.game.bolt.broker.client.processor.connection.CloseConnectEventClientProcessor;
import com.iohao.game.bolt.broker.client.processor.connection.ConnectEventClientProcessor;
import com.iohao.game.bolt.broker.client.processor.connection.ConnectFailedEventClientProcessor;
import com.iohao.game.bolt.broker.client.processor.connection.ExceptionConnectEventClientProcessor;
import com.iohao.game.bolt.broker.core.GroupWith;
import com.iohao.game.bolt.broker.core.client.BrokerAddress;
import com.iohao.game.bolt.broker.core.client.BrokerClientBuilder;
import com.iohao.game.bolt.broker.core.common.processor.pulse.PulseSignalRequestUserProcessor;
import com.iohao.game.bolt.broker.core.common.processor.pulse.PulseSignalResponseUserProcessor;
import java.util.Objects;

public abstract non-sealed class AbstractBrokerClientStartup
implements BrokerClientStartup,
GroupWith {
    private BrokerAddress brokerAddress;
    private BarSkeleton barSkeleton;
    private BrokerClientBuilder brokerClientBuilder;
    private int withNo;

    @Override
    public void connectionEventProcessor(BrokerClientBuilder brokerClientBuilder) {
        brokerClientBuilder.addConnectionEventProcessor(ConnectionEventType.CONNECT, ConnectEventClientProcessor::new).addConnectionEventProcessor(ConnectionEventType.CLOSE, CloseConnectEventClientProcessor::new).addConnectionEventProcessor(ConnectionEventType.CONNECT_FAILED, ConnectFailedEventClientProcessor::new).addConnectionEventProcessor(ConnectionEventType.EXCEPTION, ExceptionConnectEventClientProcessor::new);
    }

    @Override
    public void registerUserProcessor(BrokerClientBuilder brokerClientBuilder) {
        brokerClientBuilder.registerUserProcessor(RequestBrokerClientModuleMessageClientProcessor::new).registerUserProcessor(BrokerClusterMessageClientProcessor::new).registerUserProcessor(RequestMessageClientProcessor::new).registerUserProcessor(PulseSignalRequestUserProcessor::new).registerUserProcessor(PulseSignalResponseUserProcessor::new).registerUserProcessor(EventBusMessageClientProcessor::new).registerUserProcessor(BrokerClientOfflineMessageLogicProcessor::new).registerUserProcessor(BrokerClientOnlineMessageLogicProcessor::new);
    }

    BrokerClientBuilder initConfig() {
        IoGameBanner.me();
        this.barSkeleton = this.createBarSkeleton();
        this.brokerAddress = this.createBrokerAddress();
        if (Objects.isNull(this.brokerClientBuilder)) {
            this.brokerClientBuilder = this.createBrokerClientBuilder();
        }
        Objects.requireNonNull(this.brokerClientBuilder, "brokerClient \u6784\u5efa\u5668\u5fc5\u987b\u8981\u6709");
        this.brokerClientBuilder.withNo(this.withNo).barSkeleton(this.barSkeleton).brokerAddress(this.brokerAddress);
        this.connectionEventProcessor(this.brokerClientBuilder);
        this.registerUserProcessor(this.brokerClientBuilder);
        this.experiment();
        return this.brokerClientBuilder;
    }

    private void experiment() {
    }

    public void setWithNo(int withNo) {
        this.withNo = withNo;
    }

    public AbstractBrokerClientStartup setBrokerAddress(BrokerAddress brokerAddress) {
        this.brokerAddress = brokerAddress;
        return this;
    }

    public AbstractBrokerClientStartup setBarSkeleton(BarSkeleton barSkeleton) {
        this.barSkeleton = barSkeleton;
        return this;
    }

    public AbstractBrokerClientStartup setBrokerClientBuilder(BrokerClientBuilder brokerClientBuilder) {
        this.brokerClientBuilder = brokerClientBuilder;
        return this;
    }
}

