/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.bolt.broker.server.processor;

import com.alipay.remoting.AsyncContext;
import com.alipay.remoting.BizContext;
import com.alipay.remoting.exception.RemotingException;
import com.iohao.game.action.skeleton.protocol.HeadMetadata;
import com.iohao.game.action.skeleton.protocol.login.SettingUserIdMessage;
import com.iohao.game.action.skeleton.protocol.login.SettingUserIdMessageResponse;
import com.iohao.game.bolt.broker.core.common.AbstractAsyncUserProcessor;
import com.iohao.game.bolt.broker.server.BrokerServer;
import com.iohao.game.bolt.broker.server.aware.BrokerServerAware;
import com.iohao.game.bolt.broker.server.balanced.BalancedManager;
import com.iohao.game.bolt.broker.server.balanced.ExternalBrokerClientLoadBalanced;
import com.iohao.game.bolt.broker.server.balanced.region.BrokerClientProxy;
import com.iohao.game.core.common.NetCommonKit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SettingUserIdMessageBrokerProcessor
extends AbstractAsyncUserProcessor<SettingUserIdMessage>
implements BrokerServerAware {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SettingUserIdMessageBrokerProcessor.class);
    BrokerServer brokerServer;

    public void handleRequest(BizContext bizCtx, AsyncContext asyncCtx, SettingUserIdMessage settingUserIdMessage) {
        HeadMetadata headMetadata = settingUserIdMessage.getHeadMetadata();
        int sourceClientId = headMetadata.getSourceClientId();
        BalancedManager balancedManager = this.brokerServer.getBalancedManager();
        ExternalBrokerClientLoadBalanced externalLoadBalanced = balancedManager.getExternalLoadBalanced();
        BrokerClientProxy brokerClientProxy = externalLoadBalanced.get(sourceClientId);
        NetCommonKit.executeVirtual(() -> {
            try {
                SettingUserIdMessageResponse messageResponse = (SettingUserIdMessageResponse)brokerClientProxy.invokeSync(settingUserIdMessage);
                asyncCtx.sendResponse((Object)messageResponse);
            }
            catch (RemotingException | InterruptedException e) {
                log.error(e.getMessage(), e);
            }
        });
    }

    public String interest() {
        return SettingUserIdMessage.class.getName();
    }

    @Override
    @Generated
    public void setBrokerServer(BrokerServer brokerServer) {
        this.brokerServer = brokerServer;
    }
}

