/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.bolt.broker.server.processor;

import com.alipay.remoting.AsyncContext;
import com.alipay.remoting.BizContext;
import com.alipay.remoting.exception.RemotingException;
import com.alipay.remoting.rpc.protocol.AsyncUserProcessor;
import com.iohao.game.action.skeleton.i18n.Bundle;
import com.iohao.game.bolt.broker.cluster.BrokerClusterManager;
import com.iohao.game.bolt.broker.cluster.BrokerRunModeEnum;
import com.iohao.game.bolt.broker.core.aware.CmdRegionsAware;
import com.iohao.game.bolt.broker.core.common.IoGameGlobalConfig;
import com.iohao.game.bolt.broker.core.message.BrokerClientModuleMessage;
import com.iohao.game.bolt.broker.core.message.BrokerClusterMessage;
import com.iohao.game.bolt.broker.core.message.BrokerMessage;
import com.iohao.game.bolt.broker.server.BrokerServer;
import com.iohao.game.bolt.broker.server.aware.BrokerClientModulesAware;
import com.iohao.game.bolt.broker.server.aware.BrokerServerAware;
import com.iohao.game.bolt.broker.server.balanced.BalancedManager;
import com.iohao.game.bolt.broker.server.kit.BrokerPrintKit;
import com.iohao.game.bolt.broker.server.processor.LineKit;
import com.iohao.game.bolt.broker.server.service.BrokerClientModules;
import com.iohao.game.common.kit.concurrent.TaskKit;
import com.iohao.game.core.common.cmd.CmdRegions;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RegisterBrokerClientModuleMessageBrokerProcessor
extends AsyncUserProcessor<BrokerClientModuleMessage>
implements BrokerServerAware,
BrokerClientModulesAware,
CmdRegionsAware {
    @Generated
    private static final Logger log = LoggerFactory.getLogger((String)"CommonStdout");
    BrokerServer brokerServer;
    BrokerClientModules brokerClientModules;
    CmdRegions cmdRegions;
    AtomicBoolean fixedRateFlag = new AtomicBoolean(false);

    public void handleRequest(BizContext bizCtx, AsyncContext asyncCtx, BrokerClientModuleMessage brokerClientModuleMessage) {
        this.brokerClientModules.add(brokerClientModuleMessage);
        String remoteAddress = bizCtx.getRemoteAddress();
        brokerClientModuleMessage.setAddress(remoteAddress);
        BalancedManager balancedManager = this.brokerServer.getBalancedManager();
        balancedManager.register(brokerClientModuleMessage);
        if (this.brokerServer.getBrokerRunMode() == BrokerRunModeEnum.CLUSTER) {
            this.sendClusterMessage(bizCtx);
            this.printCluster();
        }
        this.print(brokerClientModuleMessage);
        LineKit.Context context = new LineKit.Context(this.brokerServer, this.brokerClientModules, this.cmdRegions, brokerClientModuleMessage);
        LineKit.online(context);
    }

    private void printCluster(BrokerClusterMessage brokerClusterMessage) {
        if (this.brokerServer.getBrokerRunMode() != BrokerRunModeEnum.CLUSTER) {
            return;
        }
        if (IoGameGlobalConfig.isBrokerClusterLog()) {
            String message = brokerClusterMessage.getBrokerMessageList().stream().map(BrokerMessage::toString).collect(Collectors.joining("\n"));
            log.info("\n\u6e38\u620f\u7f51\u5173\u7aef\u53e3: [{}] --  \u96c6\u7fa4\u6570\u91cf[{}] - \u8be6\u7ec6\uff1a\n[{}]", new Object[]{this.brokerServer.getPort(), brokerClusterMessage.count(), message});
        }
    }

    private void sendClusterMessage(BizContext bizCtx) {
        BrokerClusterManager brokerClusterManager = this.brokerServer.getBrokerClusterManager();
        BrokerClusterMessage brokerClusterMessage = brokerClusterManager.getBrokerClusterMessage();
        this.printCluster(brokerClusterMessage);
        try {
            this.brokerServer.getRpcServer().oneway(bizCtx.getConnection(), (Object)brokerClusterMessage);
        }
        catch (RemotingException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void print(BrokerClientModuleMessage brokerClientModuleMessage) {
        if (IoGameGlobalConfig.openLog) {
            int port = this.brokerServer.getPort();
            String brokerClientRegistrationMessage = Bundle.getMessage((String)"brokerClientRegistrationMessage");
            String gameBrokerServer = Bundle.getMessage((String)"gameBrokerServer");
            log.info("{} --- {} port: [{}] --- {}", new Object[]{brokerClientRegistrationMessage, gameBrokerServer, port, brokerClientModuleMessage});
        }
        BrokerPrintKit.print(this.brokerServer);
    }

    private void printCluster() {
        if (this.brokerServer.getBrokerRunMode() != BrokerRunModeEnum.CLUSTER) {
            return;
        }
        if (!IoGameGlobalConfig.isBrokerClusterFixedRateLog()) {
            return;
        }
        if (this.fixedRateFlag.get()) {
            return;
        }
        if (this.fixedRateFlag.compareAndSet(false, true)) {
            TaskKit.runIntervalMinute(() -> {
                BrokerPrintKit.print(this.brokerServer);
                BrokerClusterManager brokerClusterManager = this.brokerServer.getBrokerClusterManager();
                BrokerClusterMessage brokerClusterMessage = brokerClusterManager.getBrokerClusterMessage();
                this.printCluster(brokerClusterMessage);
            }, (long)1L);
        }
    }

    public String interest() {
        return BrokerClientModuleMessage.class.getName();
    }

    @Override
    @Generated
    public void setBrokerServer(BrokerServer brokerServer) {
        this.brokerServer = brokerServer;
    }

    @Override
    @Generated
    public void setBrokerClientModules(BrokerClientModules brokerClientModules) {
        this.brokerClientModules = brokerClientModules;
    }

    @Generated
    public void setCmdRegions(CmdRegions cmdRegions) {
        this.cmdRegions = cmdRegions;
    }

    @Generated
    public void setFixedRateFlag(AtomicBoolean fixedRateFlag) {
        this.fixedRateFlag = fixedRateFlag;
    }
}

