/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.bolt.broker.server.processor;

import com.alipay.remoting.AsyncContext;
import com.alipay.remoting.BizContext;
import com.alipay.remoting.exception.RemotingException;
import com.iohao.game.action.skeleton.pulse.message.PulseSignalResponse;
import com.iohao.game.bolt.broker.core.common.AbstractAsyncUserProcessor;
import com.iohao.game.bolt.broker.server.BrokerServer;
import com.iohao.game.bolt.broker.server.aware.BrokerServerAware;
import com.iohao.game.bolt.broker.server.balanced.BalancedManager;
import com.iohao.game.bolt.broker.server.balanced.LogicBrokerClientLoadBalanced;
import com.iohao.game.bolt.broker.server.balanced.region.BrokerClientProxy;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PulseSignalResponseBrokerProcessor
extends AbstractAsyncUserProcessor<PulseSignalResponse>
implements BrokerServerAware {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PulseSignalResponseBrokerProcessor.class);
    BrokerServer brokerServer;

    @Override
    public void setBrokerServer(BrokerServer brokerServer) {
        this.brokerServer = brokerServer;
    }

    public void handleRequest(BizContext bizCtx, AsyncContext asyncCtx, PulseSignalResponse response) {
        int sourceClientId = response.getSourceClientId();
        BalancedManager balancedManager = this.brokerServer.getBalancedManager();
        LogicBrokerClientLoadBalanced logicBalanced = balancedManager.getLogicBalanced();
        BrokerClientProxy client = logicBalanced.getBrokerClientProxyByIdHash(sourceClientId);
        if (Objects.isNull(client)) {
            return;
        }
        try {
            client.oneway(response);
        }
        catch (RemotingException | InterruptedException e) {
            log.error(e.getMessage(), e);
        }
    }

    public String interest() {
        return PulseSignalResponse.class.getName();
    }
}

