/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.bolt.broker.server.processor;

import com.alipay.remoting.exception.RemotingException;
import com.alipay.remoting.rpc.RpcServer;
import com.iohao.game.bolt.broker.core.client.BrokerClientType;
import com.iohao.game.bolt.broker.core.message.BrokerClientModuleMessage;
import com.iohao.game.bolt.broker.core.message.BrokerClientOfflineMessage;
import com.iohao.game.bolt.broker.core.message.BrokerClientOnlineMessage;
import com.iohao.game.bolt.broker.server.BrokerServer;
import com.iohao.game.bolt.broker.server.service.BrokerClientModules;
import com.iohao.game.common.kit.concurrent.executor.ExecutorRegionKit;
import com.iohao.game.core.common.cmd.BrokerClientId;
import com.iohao.game.core.common.cmd.CmdRegions;
import java.util.Objects;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class LineKit {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LineKit.class);
    static final long executorIndex = 0L;

    static void online(Context context) {
        ExecutorRegionKit.getSimpleThreadExecutor((long)0L).executeTry(() -> LineKit.internalOnlineNew(context));
    }

    private static void internalOnlineNew(Context context) {
        BrokerClientModuleMessage moduleMessage = context.moduleMessage();
        LineKit.extractedCmdRegions(context, moduleMessage);
        BrokerClientOnlineMessage onlineMessage = BrokerClientOnlineMessage.of((BrokerClientModuleMessage)moduleMessage);
        LineKit.streamOtherClient(context).forEach(theModuleMessage -> {
            try {
                RpcServer rpcServer = context.brokerServer().getRpcServer();
                String theModuleAddress = theModuleMessage.getAddress();
                rpcServer.oneway(theModuleAddress, (Object)onlineMessage);
                BrokerClientOnlineMessage onlineMsg = BrokerClientOnlineMessage.of((BrokerClientModuleMessage)theModuleMessage);
                String address = moduleMessage.getAddress();
                rpcServer.oneway(address, (Object)onlineMsg);
            }
            catch (RemotingException | InterruptedException e) {
                log.error(e.getMessage(), e);
            }
        });
    }

    private static void extractedCmdRegions(Context context, BrokerClientModuleMessage moduleMessage) {
        BrokerClientType brokerClientType = moduleMessage.getBrokerClientType();
        if (brokerClientType == BrokerClientType.LOGIC) {
            CmdRegions cmdRegions = context.cmdRegions();
            cmdRegions.loading(moduleMessage);
        }
    }

    static void offline(Context context) {
        ExecutorRegionKit.getSimpleThreadExecutor((long)0L).executeTry(() -> LineKit.internalOfflineNew(context));
    }

    private static void internalOfflineNew(Context context) {
        BrokerClientModuleMessage moduleMessage = LineKit.getBrokerClientModuleMessage(context);
        BrokerClientOfflineMessage offlineMessage = BrokerClientOfflineMessage.of((BrokerClientModuleMessage)moduleMessage);
        LineKit.streamOtherClient(context).forEach(theModuleMessage -> {
            try {
                String address = theModuleMessage.getAddress();
                context.brokerServer().getRpcServer().oneway(address, (Object)offlineMessage);
            }
            catch (RemotingException | InterruptedException e) {
                log.error(e.getMessage(), e);
            }
        });
    }

    private static BrokerClientModuleMessage getBrokerClientModuleMessage(Context context) {
        BrokerClientModuleMessage moduleMessage = context.moduleMessage();
        BrokerClientType brokerClientType = moduleMessage.getBrokerClientType();
        if (brokerClientType == BrokerClientType.LOGIC) {
            CmdRegions cmdRegions = context.cmdRegions();
            String id = moduleMessage.getId();
            int idHash = moduleMessage.getIdHash();
            BrokerClientId brokerClientId = new BrokerClientId(idHash, id);
            cmdRegions.unLoading(brokerClientId);
        }
        return moduleMessage;
    }

    static Stream<BrokerClientModuleMessage> streamOtherClient(Context context) {
        BrokerClientModuleMessage moduleMessage = context.moduleMessage();
        return context.brokerClientModules().listBrokerClientModuleMessage().stream().filter(message -> !Objects.equals(message.getId(), moduleMessage.getId()));
    }

    @Generated
    private LineKit() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    record Context(BrokerServer brokerServer, BrokerClientModules brokerClientModules, CmdRegions cmdRegions, BrokerClientModuleMessage moduleMessage) {
    }
}

