/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.bolt.broker.server.processor;

import com.alipay.remoting.AsyncContext;
import com.alipay.remoting.BizContext;
import com.alipay.remoting.exception.RemotingException;
import com.iohao.game.action.skeleton.core.exception.ActionErrorEnum;
import com.iohao.game.action.skeleton.core.exception.MsgExceptionInfo;
import com.iohao.game.action.skeleton.protocol.HeadMetadata;
import com.iohao.game.action.skeleton.protocol.RequestMessage;
import com.iohao.game.action.skeleton.protocol.ResponseMessage;
import com.iohao.game.bolt.broker.core.aware.CmdRegionsAware;
import com.iohao.game.bolt.broker.core.common.AbstractAsyncUserProcessor;
import com.iohao.game.bolt.broker.core.message.InnerModuleMessage;
import com.iohao.game.bolt.broker.server.BrokerServer;
import com.iohao.game.bolt.broker.server.aware.BrokerServerAware;
import com.iohao.game.bolt.broker.server.balanced.BalancedManager;
import com.iohao.game.bolt.broker.server.balanced.LogicBrokerClientLoadBalanced;
import com.iohao.game.bolt.broker.server.balanced.region.BrokerClientProxy;
import com.iohao.game.bolt.broker.server.balanced.region.BrokerClientRegion;
import com.iohao.game.bolt.broker.server.kit.EndPointClientIdKit;
import com.iohao.game.core.common.NetCommonKit;
import com.iohao.game.core.common.cmd.CmdRegions;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InnerModuleMessageBrokerProcessor
extends AbstractAsyncUserProcessor<InnerModuleMessage>
implements BrokerServerAware,
CmdRegionsAware {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InnerModuleMessageBrokerProcessor.class);
    BrokerServer brokerServer;
    CmdRegions cmdRegions;
    final ResponseMessage emptyResponseMessage = new ResponseMessage();

    public InnerModuleMessageBrokerProcessor() {
        this.emptyResponseMessage.setHeadMetadata(new HeadMetadata());
    }

    public void handleRequest(BizContext bizCtx, AsyncContext asyncCtx, InnerModuleMessage innerModuleMessage) {
        RequestMessage requestMessage = innerModuleMessage.getRequestMessage();
        HeadMetadata headMetadata = requestMessage.getHeadMetadata();
        int cmdMerge = headMetadata.getCmdMerge();
        BalancedManager balancedManager = this.brokerServer.getBalancedManager();
        LogicBrokerClientLoadBalanced logicBalanced = balancedManager.getLogicBalanced();
        BrokerClientRegion brokerClientRegion = logicBalanced.getBrokerClientRegion(cmdMerge);
        if (brokerClientRegion == null) {
            this.extractedError(asyncCtx, requestMessage);
            return;
        }
        EndPointClientIdKit.endPointClientId(headMetadata, this.cmdRegions);
        BrokerClientProxy brokerClientProxy = brokerClientRegion.getBrokerClientProxy(headMetadata);
        if (brokerClientProxy == null) {
            this.extractedError(asyncCtx, requestMessage);
            return;
        }
        NetCommonKit.executeVirtual(() -> {
            try {
                ResponseMessage responseMessage = (ResponseMessage)brokerClientProxy.invokeSync(requestMessage);
                asyncCtx.sendResponse((Object)responseMessage);
            }
            catch (RemotingException | InterruptedException e) {
                log.error(e.getMessage(), e);
            }
        });
    }

    private void extractedError(AsyncContext asyncCtx, RequestMessage requestMessage) {
        ResponseMessage responseMessage = requestMessage.createResponseMessage();
        responseMessage.setError((MsgExceptionInfo)ActionErrorEnum.cmdInfoErrorCode);
        asyncCtx.sendResponse((Object)responseMessage);
    }

    public String interest() {
        return InnerModuleMessage.class.getName();
    }

    @Override
    @Generated
    public void setBrokerServer(BrokerServer brokerServer) {
        this.brokerServer = brokerServer;
    }

    @Generated
    public void setCmdRegions(CmdRegions cmdRegions) {
        this.cmdRegions = cmdRegions;
    }
}

