/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.bolt.broker.server.processor;

import com.alipay.remoting.AsyncContext;
import com.alipay.remoting.BizContext;
import com.alipay.remoting.exception.RemotingException;
import com.iohao.game.action.skeleton.eventbus.EventBrokerClientMessage;
import com.iohao.game.action.skeleton.eventbus.EventBusMessage;
import com.iohao.game.bolt.broker.core.client.BrokerClientType;
import com.iohao.game.bolt.broker.core.common.AbstractAsyncUserProcessor;
import com.iohao.game.bolt.broker.server.BrokerServer;
import com.iohao.game.bolt.broker.server.aware.BrokerServerAware;
import com.iohao.game.bolt.broker.server.balanced.BalancedManager;
import com.iohao.game.bolt.broker.server.balanced.region.BrokerClientProxy;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Consumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventBusMessageBrokerProcessor
extends AbstractAsyncUserProcessor<EventBusMessage>
implements BrokerServerAware {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EventBusMessageBrokerProcessor.class);
    BrokerServer brokerServer;

    public void handleRequest(BizContext bizCtx, AsyncContext asyncCtx, EventBusMessage eventBusMessage) {
        Consumer<BrokerClientProxy> consumer = client -> {
            try {
                client.oneway(eventBusMessage);
            }
            catch (RemotingException | InterruptedException e) {
                log.error(e.getMessage(), e);
            }
        };
        BalancedManager balancedManager = this.brokerServer.getBalancedManager();
        Collection eventBrokerClientMessageSet = eventBusMessage.getEventBrokerClientMessages();
        for (EventBrokerClientMessage eventBrokerClientMessage : eventBrokerClientMessageSet) {
            String brokerClientId = eventBrokerClientMessage.getBrokerClientId();
            BrokerClientType brokerClientType = BrokerClientType.valueOf((String)eventBrokerClientMessage.getBrokerClientType());
            if (brokerClientType == BrokerClientType.LOGIC) {
                balancedManager.getLogicBalanced().listBrokerClientRegion().stream().flatMap(clientRegion -> clientRegion.listBrokerClientProxy().stream()).filter(brokerClientProxy -> Objects.equals(brokerClientProxy.getId(), brokerClientId)).forEach(consumer);
            }
            if (brokerClientType != BrokerClientType.EXTERNAL) continue;
            balancedManager.getExternalLoadBalanced().listBrokerClientProxy().stream().filter(brokerClientProxy -> Objects.equals(brokerClientProxy.getId(), brokerClientId)).forEach(consumer);
        }
    }

    public String interest() {
        return EventBusMessage.class.getName();
    }

    @Override
    @Generated
    public void setBrokerServer(BrokerServer brokerServer) {
        this.brokerServer = brokerServer;
    }
}

