/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.bolt.broker.server.processor;

import com.alipay.remoting.Connection;
import com.alipay.remoting.ConnectionEventProcessor;
import com.alipay.remoting.ConnectionEventType;
import com.iohao.game.bolt.broker.core.aware.CmdRegionsAware;
import com.iohao.game.bolt.broker.core.common.IoGameGlobalConfig;
import com.iohao.game.bolt.broker.core.message.BrokerClientModuleMessage;
import com.iohao.game.bolt.broker.server.BrokerServer;
import com.iohao.game.bolt.broker.server.aware.BrokerClientModulesAware;
import com.iohao.game.bolt.broker.server.aware.BrokerServerAware;
import com.iohao.game.bolt.broker.server.balanced.BalancedManager;
import com.iohao.game.bolt.broker.server.balanced.region.BrokerClientProxy;
import com.iohao.game.bolt.broker.server.kit.BrokerPrintKit;
import com.iohao.game.bolt.broker.server.processor.LineKit;
import com.iohao.game.bolt.broker.server.service.BrokerClientModules;
import com.iohao.game.core.common.cmd.CmdRegions;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConnectionCloseEventBrokerProcessor
implements ConnectionEventProcessor,
BrokerServerAware,
BrokerClientModulesAware,
CmdRegionsAware {
    @Generated
    private static final Logger log = LoggerFactory.getLogger((String)"ConnectionTopic");
    BrokerServer brokerServer;
    BrokerClientModules brokerClientModules;
    CmdRegions cmdRegions;

    public void onEvent(String remoteAddress, Connection connection) {
        Objects.requireNonNull(connection);
        BalancedManager balancedManager = this.brokerServer.getBalancedManager();
        BrokerClientProxy brokerClientProxy = balancedManager.remove(remoteAddress);
        Optional.ofNullable(brokerClientProxy).ifPresent(proxy -> {
            String id;
            BrokerClientModuleMessage moduleMessage;
            if (IoGameGlobalConfig.openLog) {
                log.info("Broker ConnectionEventType:\u3010{}\u3011\uff0cremoteAddress:\u3010{}\u3011\uff0cbrokerClientProxy:\u3010{}\u3011\uff0cConnection:\u3010{}\u3011", new Object[]{ConnectionEventType.CLOSE, remoteAddress, brokerClientProxy, connection});
                BrokerPrintKit.print(this.brokerServer);
            }
            if (Objects.isNull(moduleMessage = this.brokerClientModules.removeById(id = proxy.getId()))) {
                return;
            }
            LineKit.Context context = new LineKit.Context(this.brokerServer, this.brokerClientModules, this.cmdRegions, moduleMessage);
            LineKit.offline(context);
        });
    }

    @Override
    @Generated
    public void setBrokerServer(BrokerServer brokerServer) {
        this.brokerServer = brokerServer;
    }

    @Override
    @Generated
    public void setBrokerClientModules(BrokerClientModules brokerClientModules) {
        this.brokerClientModules = brokerClientModules;
    }

    @Generated
    public void setCmdRegions(CmdRegions cmdRegions) {
        this.cmdRegions = cmdRegions;
    }
}

