/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.bolt.broker.server.processor;

import com.alipay.remoting.exception.RemotingException;
import com.iohao.game.action.skeleton.protocol.HeadMetadata;
import com.iohao.game.action.skeleton.protocol.ResponseMessage;
import com.iohao.game.bolt.broker.core.common.IoGameGlobalConfig;
import com.iohao.game.bolt.broker.core.message.BroadcastMessage;
import com.iohao.game.bolt.broker.server.BrokerServer;
import com.iohao.game.bolt.broker.server.balanced.BalancedManager;
import com.iohao.game.bolt.broker.server.balanced.ExternalBrokerClientLoadBalanced;
import com.iohao.game.bolt.broker.server.balanced.region.BrokerClientProxy;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BrokerExternalKit {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BrokerExternalKit.class);

    public static void sendMessageToExternal(BrokerServer brokerServer, BroadcastMessage broadcastMessage) {
        ResponseMessage responseMessage = broadcastMessage.getResponseMessage();
        HeadMetadata headMetadata = responseMessage.getHeadMetadata();
        int sourceClientId = headMetadata.getSourceClientId();
        BalancedManager balancedManager = brokerServer.getBalancedManager();
        ExternalBrokerClientLoadBalanced externalLoadBalanced = balancedManager.getExternalLoadBalanced();
        if (sourceClientId == 0) {
            List<BrokerClientProxy> list = externalLoadBalanced.listBrokerClientProxy();
            BrokerExternalKit.sendMessage(list, broadcastMessage);
            return;
        }
        Stream<BrokerClientProxy> stream = BrokerExternalKit.streamToggle(sourceClientId, externalLoadBalanced);
        Consumer<BrokerClientProxy> consumer = BrokerExternalKit.consumer(broadcastMessage);
        stream.forEach(consumer);
    }

    public static void sendMessageToExternals(BrokerServer brokerServer, Object message) {
        BalancedManager balancedManager = brokerServer.getBalancedManager();
        ExternalBrokerClientLoadBalanced externalLoadBalanced = balancedManager.getExternalLoadBalanced();
        List<BrokerClientProxy> list = externalLoadBalanced.listBrokerClientProxy();
        BrokerExternalKit.sendMessage(list, message);
    }

    static Stream<BrokerClientProxy> streamToggle(int sourceClientId, ExternalBrokerClientLoadBalanced externalLoadBalanced) {
        List<BrokerClientProxy> list = externalLoadBalanced.listBrokerClientProxy();
        Stream<BrokerClientProxy> stream = list.stream();
        if (sourceClientId == 0) {
            return stream;
        }
        if (IoGameGlobalConfig.brokerSniperToggleAK47) {
            if (externalLoadBalanced.contains(sourceClientId)) {
                stream = stream.filter(brokerClientProxy -> brokerClientProxy.getIdHash() == sourceClientId);
            }
        } else {
            stream = stream.filter(brokerClientProxy -> brokerClientProxy.getIdHash() == sourceClientId);
        }
        return stream;
    }

    private static void sendMessage(List<BrokerClientProxy> list, Object message) {
        Consumer<BrokerClientProxy> consumer = BrokerExternalKit.consumer(message);
        list.forEach(consumer);
    }

    private static Consumer<BrokerClientProxy> consumer(Object message) {
        return brokerClientProxy -> {
            try {
                brokerClientProxy.oneway(message);
            }
            catch (RemotingException | InterruptedException e) {
                log.error(e.getMessage(), e);
            }
        };
    }

    @Generated
    private BrokerExternalKit() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

