/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.bolt.broker.server.kit;

import com.iohao.game.action.skeleton.i18n.Bundle;
import com.iohao.game.bolt.broker.core.common.IoGameGlobalConfig;
import com.iohao.game.bolt.broker.server.BrokerServer;
import com.iohao.game.bolt.broker.server.balanced.BalancedManager;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BrokerPrintKit {
    @Generated
    private static final Logger log = LoggerFactory.getLogger((String)"CommonStdout");

    public static void print(BrokerServer brokerServer) {
        if (!IoGameGlobalConfig.openLog) {
            return;
        }
        BalancedManager balancedManager = brokerServer.getBalancedManager();
        List collect = balancedManager.getLogicBalanced().listBrokerClientRegion().stream().map(brokerClientRegion -> {
            String tag = brokerClientRegion.getTag();
            int count = brokerClientRegion.count();
            return new BrokerClientNodeInfo(tag, count);
        }).collect(Collectors.toList());
        int externalCount = balancedManager.getExternalLoadBalanced().count();
        String gameExternalServer = Bundle.getMessage((String)"gameExternalServer");
        BrokerClientNodeInfo externalNodeInfo = new BrokerClientNodeInfo("external", externalCount);
        collect.add(externalNodeInfo);
        String info = collect.stream().map(BrokerClientNodeInfo::toString).collect(Collectors.joining("\n\t", "\n\t", ""));
        int port = brokerServer.getPort();
        String gameBrokerServer = Bundle.getMessage((String)"gameBrokerServer");
        log.info("{}:{} --- gameLogicServerList: {}", new Object[]{gameBrokerServer, port, info});
    }

    @Generated
    private BrokerPrintKit() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private record BrokerClientNodeInfo(String tag, int count) {
        @Override
        public String toString() {
            String gameServerAmount = Bundle.getMessage((String)"gameServerAmount");
            return "{" + gameServerAmount + ":" + this.count + ", tag:'" + this.tag + "'}";
        }
    }
}

