/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.bolt.broker.server.cluster;

import com.alipay.remoting.exception.RemotingException;
import com.iohao.game.bolt.broker.cluster.ClusterMessageListener;
import com.iohao.game.bolt.broker.core.message.BrokerClusterMessage;
import com.iohao.game.bolt.broker.server.BrokerServer;
import com.iohao.game.bolt.broker.server.balanced.BalancedManager;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterMessageListenerImpl
implements ClusterMessageListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger((String)"ClusterTopic");
    BrokerServer brokerServer;

    @Override
    public void inform(BrokerClusterMessage brokerClusterMessage) {
        this.extractedLogic(brokerClusterMessage);
        this.extractedExternal(brokerClusterMessage);
    }

    private void extractedLogic(BrokerClusterMessage brokerClusterMessage) {
        BalancedManager balancedManager = this.brokerServer.getBalancedManager();
        balancedManager.getLogicBalanced().listBrokerClientRegion().stream().flatMap(brokerClientRegion -> brokerClientRegion.listBrokerClientProxy().stream()).forEach(brokerClientProxy -> {
            try {
                brokerClientProxy.oneway(brokerClusterMessage);
            }
            catch (RemotingException | InterruptedException e) {
                log.error(e.getMessage(), e);
            }
        });
    }

    private void extractedExternal(BrokerClusterMessage brokerClusterMessage) {
        BalancedManager balancedManager = this.brokerServer.getBalancedManager();
        balancedManager.getExternalLoadBalanced().listBrokerClientProxy().forEach(brokerClientProxy -> {
            try {
                brokerClientProxy.oneway(brokerClusterMessage);
            }
            catch (RemotingException | InterruptedException e) {
                log.error(e.getMessage(), e);
            }
        });
    }

    @Generated
    public void setBrokerServer(BrokerServer brokerServer) {
        this.brokerServer = brokerServer;
    }
}

