/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.bolt.broker.server.balanced.region;

import com.iohao.game.bolt.broker.core.loadbalance.ElementSelector;
import com.iohao.game.bolt.broker.server.balanced.region.BrokerClientProxy;
import com.iohao.game.bolt.broker.server.balanced.region.WithElementSelector;
import com.iohao.game.common.kit.CollKit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;

final class DefaultWithElementSelector
implements WithElementSelector<BrokerClientProxy> {
    int size;
    Map<Integer, List<BrokerClientProxy>> map;
    ElementSelector<BrokerClientProxy> elementSelector;
    final AtomicLong counter = new AtomicLong();

    public DefaultWithElementSelector(Map<Integer, BrokerClientProxy> proxyMap) {
        List<BrokerClientProxy> list = proxyMap.values().stream().filter(Objects::nonNull).toList();
        this.size = list.size();
        if (this.size == 0) {
            return;
        }
        this.elementSelector = ElementSelector.of(list);
        this.map = new HashMap<Integer, List<BrokerClientProxy>>();
        for (BrokerClientProxy brokerClientProxy : list) {
            int withNo = brokerClientProxy.getWithNo();
            if (withNo == 0) continue;
            List<BrokerClientProxy> withList = this.map.get(withNo);
            if (Objects.isNull(withList)) {
                withList = new ArrayList<BrokerClientProxy>();
                this.map.put(withNo, withList);
            }
            withList.add(brokerClientProxy);
        }
    }

    @Override
    public BrokerClientProxy next(int withNo) {
        BrokerClientProxy brokerClientProxy;
        if (this.size == 0) {
            return null;
        }
        if (withNo == 0) {
            return (BrokerClientProxy)this.elementSelector.get();
        }
        List<BrokerClientProxy> withList = this.map.get(withNo);
        if (CollKit.isEmpty(withList) && Objects.nonNull(brokerClientProxy = withList.get((int)(this.counter.getAndIncrement() % (long)withList.size())))) {
            return brokerClientProxy;
        }
        return (BrokerClientProxy)this.elementSelector.next();
    }
}

