/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.bolt.broker.server.balanced.region;

import com.iohao.game.action.skeleton.protocol.HeadMetadata;
import com.iohao.game.bolt.broker.core.loadbalance.ElementSelector;
import com.iohao.game.bolt.broker.server.balanced.region.BrokerClientProxy;
import com.iohao.game.bolt.broker.server.balanced.region.BrokerClientRegion;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.jctools.maps.NonBlockingHashMap;

public class DefaultBrokerClientRegion
implements BrokerClientRegion {
    protected final Map<Integer, BrokerClientProxy> brokerClientProxyMap = new NonBlockingHashMap();
    protected final String tag;
    protected ElementSelector<BrokerClientProxy> elementSelector;

    public DefaultBrokerClientRegion(String tag) {
        this.tag = tag;
    }

    @Override
    public BrokerClientProxy getBrokerClientProxy(HeadMetadata headMetadata) {
        BrokerClientProxy brokerClientProxy;
        int endPointClientId = headMetadata.getEndPointClientId();
        if (endPointClientId != 0 && this.brokerClientProxyMap.containsKey(endPointClientId) && Objects.nonNull(brokerClientProxy = this.brokerClientProxyMap.get(endPointClientId))) {
            return brokerClientProxy;
        }
        if (Objects.isNull(this.elementSelector)) {
            return null;
        }
        return (BrokerClientProxy)this.elementSelector.get();
    }

    @Override
    public void add(BrokerClientProxy brokerClientProxy) {
        int id = brokerClientProxy.getIdHash();
        this.brokerClientProxyMap.put(id, brokerClientProxy);
        this.resetSelector();
    }

    @Override
    public void remove(int id) {
        this.brokerClientProxyMap.remove(id);
        this.resetSelector();
    }

    @Override
    public String getTag() {
        return this.tag;
    }

    @Override
    public int count() {
        return this.brokerClientProxyMap.size();
    }

    private void resetSelector() {
        ArrayList<BrokerClientProxy> list = new ArrayList<BrokerClientProxy>(this.brokerClientProxyMap.values());
        this.elementSelector = ElementSelector.of(list);
    }

    @Override
    @Generated
    public Map<Integer, BrokerClientProxy> getBrokerClientProxyMap() {
        return this.brokerClientProxyMap;
    }
}

