/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.bolt.broker.server.balanced.region;

import com.alipay.remoting.exception.RemotingException;
import com.alipay.remoting.rpc.RpcServer;
import com.iohao.game.bolt.broker.core.client.BrokerClientType;
import com.iohao.game.bolt.broker.core.common.IoGameGlobalConfig;
import com.iohao.game.bolt.broker.core.message.BrokerClientModuleMessage;
import java.util.List;
import lombok.Generated;

public class BrokerClientProxy {
    final String id;
    final int idHash;
    final String name;
    final String address;
    final String tag;
    final BrokerClientType brokerClientType;
    final RpcServer rpcServer;
    final int withNo;
    int status;
    int timeoutMillis = IoGameGlobalConfig.timeoutMillis;
    List<Integer> cmdMergeList;

    public BrokerClientProxy(BrokerClientModuleMessage brokerClientModuleMessage, RpcServer rpcServer) {
        this.id = brokerClientModuleMessage.getId();
        this.idHash = brokerClientModuleMessage.getIdHash();
        this.name = brokerClientModuleMessage.getName();
        this.address = brokerClientModuleMessage.getAddress();
        this.tag = brokerClientModuleMessage.getTag();
        this.brokerClientType = brokerClientModuleMessage.getBrokerClientType();
        this.cmdMergeList = brokerClientModuleMessage.getCmdMergeList();
        this.rpcServer = rpcServer;
        this.withNo = brokerClientModuleMessage.getWithNo();
        this.status = brokerClientModuleMessage.getStatus();
    }

    public void oneway(Object request) throws RemotingException, InterruptedException {
        this.rpcServer.oneway(this.address, request);
    }

    public <T> T invokeSync(Object message) throws RemotingException, InterruptedException {
        return (T)this.rpcServer.invokeSync(this.address, message, this.timeoutMillis);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BrokerClientProxy)) {
            return false;
        }
        BrokerClientProxy that = (BrokerClientProxy)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public int getIdHash() {
        return this.idHash;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getAddress() {
        return this.address;
    }

    @Generated
    public String getTag() {
        return this.tag;
    }

    @Generated
    public BrokerClientType getBrokerClientType() {
        return this.brokerClientType;
    }

    @Generated
    public RpcServer getRpcServer() {
        return this.rpcServer;
    }

    @Generated
    public int getWithNo() {
        return this.withNo;
    }

    @Generated
    public int getStatus() {
        return this.status;
    }

    @Generated
    public int getTimeoutMillis() {
        return this.timeoutMillis;
    }

    @Generated
    public List<Integer> getCmdMergeList() {
        return this.cmdMergeList;
    }

    @Generated
    public void setStatus(int status) {
        this.status = status;
    }

    @Generated
    public void setTimeoutMillis(int timeoutMillis) {
        this.timeoutMillis = timeoutMillis;
    }

    @Generated
    public void setCmdMergeList(List<Integer> cmdMergeList) {
        this.cmdMergeList = cmdMergeList;
    }

    @Generated
    public String toString() {
        return "BrokerClientProxy(id=" + this.getId() + ", idHash=" + this.getIdHash() + ", name=" + this.getName() + ", address=" + this.getAddress() + ", tag=" + this.getTag() + ", brokerClientType=" + String.valueOf(this.getBrokerClientType()) + ", rpcServer=" + String.valueOf(this.getRpcServer()) + ", withNo=" + this.getWithNo() + ", status=" + this.getStatus() + ", timeoutMillis=" + this.getTimeoutMillis() + ", cmdMergeList=" + String.valueOf(this.getCmdMergeList()) + ")";
    }
}

