/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.bolt.broker.server.balanced;

import com.iohao.game.bolt.broker.server.balanced.BrokerClientLoadBalanced;
import com.iohao.game.bolt.broker.server.balanced.region.BrokerClientProxy;
import com.iohao.game.bolt.broker.server.balanced.region.BrokerClientRegion;
import com.iohao.game.bolt.broker.server.balanced.region.BrokerClientRegionFactory;
import com.iohao.game.common.kit.MoreKit;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.jctools.maps.NonBlockingHashMap;

public final class LogicBrokerClientLoadBalanced
implements BrokerClientLoadBalanced {
    final Map<Integer, BrokerClientRegion> cmdClientRegionMap = new NonBlockingHashMap();
    final Map<String, BrokerClientRegion> tagClientRegionMap = new NonBlockingHashMap();
    final Map<Integer, BrokerClientProxy> serverIdClientProxyMap = new NonBlockingHashMap();
    BrokerClientRegionFactory brokerClientRegionFactory;

    @Override
    public void register(BrokerClientProxy brokerClientProxy) {
        String tag = brokerClientProxy.getTag();
        BrokerClientRegion brokerClientRegion = this.getBrokerClientRegionByTag(tag);
        brokerClientRegion.add(brokerClientProxy);
        List<Integer> cmdMergeList = brokerClientProxy.getCmdMergeList();
        for (Integer cmdMerge : cmdMergeList) {
            this.cmdClientRegionMap.put(cmdMerge, brokerClientRegion);
        }
        this.serverIdClientProxyMap.put(brokerClientProxy.getIdHash(), brokerClientProxy);
    }

    @Override
    public void remove(BrokerClientProxy brokerClientProxy) {
        int id = brokerClientProxy.getIdHash();
        String tag = brokerClientProxy.getTag();
        BrokerClientRegion brokerClientRegion = this.getBrokerClientRegionByTag(tag);
        brokerClientRegion.remove(id);
        this.serverIdClientProxyMap.remove(brokerClientProxy.getIdHash());
    }

    public BrokerClientRegion getBrokerClientRegion(int cmdMerge) {
        BrokerClientRegion region = this.cmdClientRegionMap.get(cmdMerge);
        if (Objects.isNull(region)) {
            return null;
        }
        return region;
    }

    public Collection<BrokerClientRegion> listBrokerClientRegion() {
        return this.tagClientRegionMap.values();
    }

    public BrokerClientProxy getBrokerClientProxyByIdHash(int idHash) {
        return this.serverIdClientProxyMap.get(idHash);
    }

    private BrokerClientRegion getBrokerClientRegionByTag(String tag) {
        BrokerClientRegion brokerClientRegion = this.tagClientRegionMap.get(tag);
        if (Objects.isNull(brokerClientRegion)) {
            BrokerClientRegion newValue = this.brokerClientRegionFactory.createBrokerClientRegion(tag);
            return (BrokerClientRegion)MoreKit.putIfAbsent(this.tagClientRegionMap, (Object)tag, (Object)newValue);
        }
        return brokerClientRegion;
    }

    @Generated
    public void setBrokerClientRegionFactory(BrokerClientRegionFactory brokerClientRegionFactory) {
        this.brokerClientRegionFactory = brokerClientRegionFactory;
    }
}

