/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.bolt.broker.server.balanced;

import com.iohao.game.bolt.broker.server.balanced.BrokerClientLoadBalanced;
import com.iohao.game.bolt.broker.server.balanced.region.BrokerClientProxy;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jctools.maps.NonBlockingHashMap;

public class ExternalBrokerClientLoadBalanced
implements BrokerClientLoadBalanced {
    private final Map<Integer, BrokerClientProxy> map = new NonBlockingHashMap();
    private List<BrokerClientProxy> list = Collections.emptyList();

    @Override
    public void register(BrokerClientProxy brokerClientProxy) {
        int externalId = brokerClientProxy.getIdHash();
        this.map.put(externalId, brokerClientProxy);
        this.resetSelector();
    }

    @Override
    public void remove(BrokerClientProxy brokerClientProxy) {
        int externalId = brokerClientProxy.getIdHash();
        this.map.remove(externalId);
        this.resetSelector();
    }

    public BrokerClientProxy get(int externalId) {
        return this.map.get(externalId);
    }

    public boolean contains(int externalId) {
        return this.map.containsKey(externalId);
    }

    public List<BrokerClientProxy> listBrokerClientProxy() {
        return this.list;
    }

    public int count() {
        return this.map.size();
    }

    private void resetSelector() {
        this.list = new CopyOnWriteArrayList<BrokerClientProxy>(this.map.values());
    }
}

