/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.bolt.broker.server;

import com.alipay.remoting.ConnectionEventProcessor;
import com.alipay.remoting.ConnectionEventType;
import com.alipay.remoting.rpc.RpcServer;
import com.alipay.remoting.rpc.protocol.UserProcessor;
import com.iohao.game.bolt.broker.cluster.BrokerClusterManager;
import com.iohao.game.bolt.broker.cluster.BrokerClusterManagerBuilder;
import com.iohao.game.bolt.broker.cluster.BrokerRunModeEnum;
import com.iohao.game.bolt.broker.core.aware.AwareInject;
import com.iohao.game.bolt.broker.core.aware.AwareKit;
import com.iohao.game.bolt.broker.core.aware.CmdRegionsAware;
import com.iohao.game.bolt.broker.core.common.IoGameGlobalConfig;
import com.iohao.game.bolt.broker.server.BrokerServer;
import com.iohao.game.bolt.broker.server.aware.BrokerClientModulesAware;
import com.iohao.game.bolt.broker.server.aware.BrokerServerAware;
import com.iohao.game.bolt.broker.server.balanced.BalancedManager;
import com.iohao.game.bolt.broker.server.balanced.LogicBrokerClientLoadBalanced;
import com.iohao.game.bolt.broker.server.balanced.region.BrokerClientRegionFactory;
import com.iohao.game.bolt.broker.server.balanced.region.StrictBrokerClientRegion;
import com.iohao.game.bolt.broker.server.enhance.BrokerEnhances;
import com.iohao.game.bolt.broker.server.processor.BroadcastMessageBrokerProcessor;
import com.iohao.game.bolt.broker.server.processor.BroadcastOrderMessageBrokerProcessor;
import com.iohao.game.bolt.broker.server.processor.BrokerClientItemConnectMessageBrokerProcessor;
import com.iohao.game.bolt.broker.server.processor.ConnectionCloseEventBrokerProcessor;
import com.iohao.game.bolt.broker.server.processor.ConnectionEventBrokerProcessor;
import com.iohao.game.bolt.broker.server.processor.ConnectionExceptionEventBrokerProcessor;
import com.iohao.game.bolt.broker.server.processor.ConnectionFailedEventBrokerProcessor;
import com.iohao.game.bolt.broker.server.processor.EndPointLogicServerMessageBrokerProcessor;
import com.iohao.game.bolt.broker.server.processor.EventBusMessageBrokerProcessor;
import com.iohao.game.bolt.broker.server.processor.InnerModuleMessageBrokerProcessor;
import com.iohao.game.bolt.broker.server.processor.InnerModuleRequestCollectExternalMessageBrokerProcessor;
import com.iohao.game.bolt.broker.server.processor.InnerModuleRequestCollectMessageBrokerProcessor;
import com.iohao.game.bolt.broker.server.processor.InnerModuleVoidMessageBrokerProcessor;
import com.iohao.game.bolt.broker.server.processor.PulseSignalRequestBrokerProcessor;
import com.iohao.game.bolt.broker.server.processor.PulseSignalResponseBrokerProcessor;
import com.iohao.game.bolt.broker.server.processor.RegisterBrokerClientModuleMessageBrokerProcessor;
import com.iohao.game.bolt.broker.server.processor.RequestMessageBrokerProcessor;
import com.iohao.game.bolt.broker.server.processor.ResponseMessageBrokerProcessor;
import com.iohao.game.bolt.broker.server.processor.SettingUserIdMessageBrokerProcessor;
import com.iohao.game.bolt.broker.server.service.BrokerClientModules;
import com.iohao.game.bolt.broker.server.service.DefaultBrokerClientModules;
import com.iohao.game.common.kit.exception.ThrowKit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Supplier;
import lombok.Generated;
import org.jctools.maps.NonBlockingHashMap;

public class BrokerServerBuilder
implements AwareInject {
    private final BrokerServer brokerServer = new BrokerServer();
    private final List<Supplier<UserProcessor<?>>> processorList = new ArrayList();
    private final Map<ConnectionEventType, Supplier<ConnectionEventProcessor>> connectionEventProcessorMap = new NonBlockingHashMap();
    private final BrokerClientModules brokerClientModules = new DefaultBrokerClientModules();
    private String brokerId;
    private int port = IoGameGlobalConfig.brokerPort;
    private BrokerRunModeEnum brokerRunMode = BrokerRunModeEnum.STANDALONE;
    private BrokerClusterManagerBuilder brokerClusterManagerBuilder;
    private BrokerClientRegionFactory brokerClientRegionFactory = StrictBrokerClientRegion::new;

    BrokerServerBuilder() {
        this.defaultProcessor();
        System.setProperty("bolt.conn.monitor.switch", "true");
        System.setProperty("bolt.conn.reconnect.switch", "true");
    }

    public BrokerServer build() {
        this.checked();
        if (Objects.isNull(this.brokerId)) {
            this.brokerId = UUID.randomUUID().toString();
        }
        BalancedManager balancedManager = this.brokerServer.getBalancedManager();
        LogicBrokerClientLoadBalanced logicBalanced = balancedManager.getLogicBalanced();
        logicBalanced.setBrokerClientRegionFactory(this.brokerClientRegionFactory);
        this.brokerServer.setBrokerId(this.brokerId).setBrokerRunMode(this.brokerRunMode).setPort(this.port).setBrokerClientModules(this.brokerClientModules);
        this.brokerServer.initRpcServer();
        RpcServer rpcServer = this.brokerServer.getRpcServer();
        this.processorList.forEach(processorSupplier -> {
            UserProcessor userProcessor = (UserProcessor)processorSupplier.get();
            this.aware(userProcessor);
            rpcServer.registerUserProcessor(userProcessor);
        });
        this.connectionEventProcessorMap.forEach((type, valueSupplier) -> {
            ConnectionEventProcessor processor = (ConnectionEventProcessor)valueSupplier.get();
            this.aware(processor);
            rpcServer.addConnectionEventProcessor(type, processor);
        });
        this.cluster();
        return this.brokerServer;
    }

    public BrokerServerBuilder registerUserProcessor(Supplier<UserProcessor<?>> processorSupplier) {
        this.processorList.add(processorSupplier);
        return this;
    }

    public BrokerServerBuilder removeUserProcessor(Class<? extends UserProcessor<?>> clazz) {
        if (clazz != null) {
            this.processorList.removeIf(processorSupplier -> ((UserProcessor)processorSupplier.get()).getClass().equals(clazz));
        }
        return this;
    }

    public BrokerServerBuilder addConnectionEventProcessor(ConnectionEventType type, Supplier<ConnectionEventProcessor> processorSupplier) {
        this.connectionEventProcessorMap.put(type, processorSupplier);
        return this;
    }

    public BrokerServerBuilder brokerClusterManagerBuilder(BrokerClusterManagerBuilder brokerClusterManagerBuilder) {
        if (Objects.isNull(brokerClusterManagerBuilder)) {
            return this;
        }
        this.brokerClusterManagerBuilder = brokerClusterManagerBuilder;
        this.brokerRunMode = BrokerRunModeEnum.CLUSTER;
        return this;
    }

    public BrokerServerBuilder clearProcessor() {
        this.processorList.clear();
        this.connectionEventProcessorMap.clear();
        return this;
    }

    private void cluster() {
        if (this.brokerRunMode != BrokerRunModeEnum.CLUSTER) {
            return;
        }
        Objects.requireNonNull(this.brokerClusterManagerBuilder, "\u5f00\u542f\u96c6\u7fa4\u6a21\u5f0f brokerClusterManagerBuilder \u5fc5\u987b\u4e0d\u4e3a null!");
        BrokerClusterManager brokerClusterManager = this.brokerClusterManagerBuilder.build(this.brokerServer);
        this.brokerServer.setBrokerClusterManager(brokerClusterManager);
    }

    private void checked() {
        if (this.port <= 0) {
            ThrowKit.ofRuntimeException((String)"port error!");
        }
        if (Objects.isNull((Object)this.brokerRunMode)) {
            ThrowKit.ofRuntimeException((String)("brokerRunMode expected: " + Arrays.toString((Object[])BrokerRunModeEnum.values())));
        }
    }

    private void defaultProcessor() {
        Supplier<ConnectionEventProcessor> connectionCloseEventSupplier = ConnectionCloseEventBrokerProcessor::new;
        Supplier<ConnectionEventProcessor> connectionEventSupplier = ConnectionEventBrokerProcessor::new;
        Supplier<ConnectionEventProcessor> connectionExceptionEventSupplier = ConnectionExceptionEventBrokerProcessor::new;
        Supplier<ConnectionEventProcessor> connectionFailedEventSupplier = ConnectionFailedEventBrokerProcessor::new;
        this.addConnectionEventProcessor(ConnectionEventType.EXCEPTION, connectionExceptionEventSupplier).addConnectionEventProcessor(ConnectionEventType.CONNECT_FAILED, connectionFailedEventSupplier).addConnectionEventProcessor(ConnectionEventType.CONNECT, connectionEventSupplier).addConnectionEventProcessor(ConnectionEventType.CLOSE, connectionCloseEventSupplier);
        Supplier<UserProcessor<?>> registerSupplier = RegisterBrokerClientModuleMessageBrokerProcessor::new;
        Supplier<UserProcessor<?>> externalMessageSupplier = RequestMessageBrokerProcessor::new;
        Supplier<UserProcessor<?>> changeUserIdMessageSupplier = SettingUserIdMessageBrokerProcessor::new;
        Supplier<UserProcessor<?>> responseMessageSupplier = ResponseMessageBrokerProcessor::new;
        Supplier<UserProcessor<?>> innerModuleMessageSupplier = InnerModuleMessageBrokerProcessor::new;
        Supplier<UserProcessor<?>> innerModuleVoidMessageSupplier = InnerModuleVoidMessageBrokerProcessor::new;
        Supplier<UserProcessor<?>> innerModuleRequestCollectMessageSupplier = InnerModuleRequestCollectMessageBrokerProcessor::new;
        Supplier<UserProcessor<?>> innerModuleRequestCollectExternalMessageSupplier = InnerModuleRequestCollectExternalMessageBrokerProcessor::new;
        Supplier<UserProcessor<?>> endPointLogicServerMessageSupplier = EndPointLogicServerMessageBrokerProcessor::new;
        Supplier<UserProcessor<?>> broadcastMessageSupplier = BroadcastMessageBrokerProcessor::new;
        Supplier<UserProcessor<?>> broadcastOrderMessageSupplier = BroadcastOrderMessageBrokerProcessor::new;
        Supplier<UserProcessor<?>> brokerClientItemConnectMessageSupplier = BrokerClientItemConnectMessageBrokerProcessor::new;
        this.registerUserProcessor(registerSupplier).registerUserProcessor(externalMessageSupplier).registerUserProcessor(changeUserIdMessageSupplier).registerUserProcessor(responseMessageSupplier).registerUserProcessor(innerModuleMessageSupplier).registerUserProcessor(innerModuleVoidMessageSupplier).registerUserProcessor(innerModuleRequestCollectMessageSupplier).registerUserProcessor(innerModuleRequestCollectExternalMessageSupplier).registerUserProcessor(broadcastMessageSupplier).registerUserProcessor(broadcastOrderMessageSupplier).registerUserProcessor(brokerClientItemConnectMessageSupplier).registerUserProcessor(endPointLogicServerMessageSupplier).registerUserProcessor(PulseSignalRequestBrokerProcessor::new).registerUserProcessor(PulseSignalResponseBrokerProcessor::new).registerUserProcessor(EventBusMessageBrokerProcessor::new);
        BrokerEnhances.enhance(this);
    }

    public void aware(Object obj) {
        Object aware;
        AwareKit.aware((Object)obj);
        if (obj instanceof BrokerServerAware) {
            aware = (BrokerServerAware)obj;
            aware.setBrokerServer(this.brokerServer);
        }
        if (obj instanceof CmdRegionsAware) {
            aware = (CmdRegionsAware)obj;
            aware.setCmdRegions(this.brokerServer.getCmdRegions());
        }
        if (obj instanceof BrokerClientModulesAware) {
            aware = (BrokerClientModulesAware)obj;
            aware.setBrokerClientModules(this.brokerClientModules);
        }
    }

    @Generated
    public BrokerServerBuilder brokerId(String brokerId) {
        this.brokerId = brokerId;
        return this;
    }

    @Generated
    public BrokerServerBuilder port(int port) {
        this.port = port;
        return this;
    }

    @Generated
    public BrokerServerBuilder brokerRunMode(BrokerRunModeEnum brokerRunMode) {
        this.brokerRunMode = brokerRunMode;
        return this;
    }

    @Generated
    public BrokerServerBuilder brokerClientRegionFactory(BrokerClientRegionFactory brokerClientRegionFactory) {
        this.brokerClientRegionFactory = brokerClientRegionFactory;
        return this;
    }
}

