/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.bolt.broker.server;

import com.alipay.remoting.rpc.RpcServer;
import com.iohao.game.action.skeleton.i18n.Bundle;
import com.iohao.game.action.skeleton.toy.IoGameBanner;
import com.iohao.game.bolt.broker.cluster.BrokerClusterManager;
import com.iohao.game.bolt.broker.cluster.BrokerRunModeEnum;
import com.iohao.game.bolt.broker.core.GroupWith;
import com.iohao.game.bolt.broker.server.BrokerServerBuilder;
import com.iohao.game.bolt.broker.server.balanced.BalancedManager;
import com.iohao.game.bolt.broker.server.service.BrokerClientModules;
import com.iohao.game.core.common.cmd.CmdRegions;
import com.iohao.game.core.common.cmd.DefaultCmdRegions;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerServer
implements GroupWith {
    @Generated
    private static final Logger log = LoggerFactory.getLogger((String)"CommonStdout");
    private final BalancedManager balancedManager = new BalancedManager(this);
    private final CmdRegions cmdRegions = new DefaultCmdRegions();
    private String brokerId;
    private int port;
    private RpcServer rpcServer;
    private BrokerRunModeEnum brokerRunMode;
    private BrokerClusterManager brokerClusterManager;
    private BrokerClientModules brokerClientModules;
    private int withNo;

    BrokerServer() {
    }

    void initRpcServer() {
        this.rpcServer = new RpcServer(this.port, true);
    }

    public void startup() {
        IoGameBanner.me().init();
        System.setProperty("bolt.rpc.dispatch-msg-list-in-default-executor", "false");
        this.rpcServer.startup();
        Optional.ofNullable(this.brokerClusterManager).ifPresent(BrokerClusterManager::start);
        this.extractedLog();
        IoGameBanner.render();
        IoGameBanner.me().countDown();
    }

    private void extractedLog() {
        String gameBrokerServer = Bundle.getMessage((String)"gameBrokerServer");
        String gameBrokerServerStartupMode = Bundle.getMessage((String)"gameBrokerServerStartupMode");
        log.info("{} port:[{}] - {}:[{}] ", new Object[]{gameBrokerServer, this.port, gameBrokerServerStartupMode, this.brokerRunMode});
    }

    public void shutdown() {
        this.rpcServer.shutdown();
    }

    public static BrokerServerBuilder newBuilder() {
        return new BrokerServerBuilder();
    }

    public void setWithNo(int withNo) {
        this.withNo = withNo;
    }

    @Generated
    public BalancedManager getBalancedManager() {
        return this.balancedManager;
    }

    @Generated
    public CmdRegions getCmdRegions() {
        return this.cmdRegions;
    }

    @Generated
    public String getBrokerId() {
        return this.brokerId;
    }

    @Generated
    public int getPort() {
        return this.port;
    }

    @Generated
    public RpcServer getRpcServer() {
        return this.rpcServer;
    }

    @Generated
    public BrokerRunModeEnum getBrokerRunMode() {
        return this.brokerRunMode;
    }

    @Generated
    public BrokerClusterManager getBrokerClusterManager() {
        return this.brokerClusterManager;
    }

    @Generated
    public BrokerClientModules getBrokerClientModules() {
        return this.brokerClientModules;
    }

    @Generated
    public int getWithNo() {
        return this.withNo;
    }

    @Generated
    BrokerServer setBrokerId(String brokerId) {
        this.brokerId = brokerId;
        return this;
    }

    @Generated
    BrokerServer setPort(int port) {
        this.port = port;
        return this;
    }

    @Generated
    BrokerServer setRpcServer(RpcServer rpcServer) {
        this.rpcServer = rpcServer;
        return this;
    }

    @Generated
    BrokerServer setBrokerRunMode(BrokerRunModeEnum brokerRunMode) {
        this.brokerRunMode = brokerRunMode;
        return this;
    }

    @Generated
    BrokerServer setBrokerClusterManager(BrokerClusterManager brokerClusterManager) {
        this.brokerClusterManager = brokerClusterManager;
        return this;
    }

    @Generated
    BrokerServer setBrokerClientModules(BrokerClientModules brokerClientModules) {
        this.brokerClientModules = brokerClientModules;
        return this;
    }
}

