/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.bolt.broker.cluster;

import com.iohao.game.bolt.broker.cluster.BrokerClusterManager;
import com.iohao.game.bolt.broker.core.common.IoGameGlobalConfig;
import com.iohao.game.bolt.broker.server.BrokerServer;
import com.iohao.game.bolt.broker.server.cluster.ClusterMessageListenerImpl;
import com.iohao.game.common.kit.exception.ThrowKit;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerClusterManagerBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger((String)"ClusterTopic");
    List<String> seedAddress;
    int gossipListenPort = IoGameGlobalConfig.gossipListenPort;

    BrokerClusterManagerBuilder() {
    }

    public BrokerClusterManager build(BrokerServer brokerServer) {
        this.checked();
        this.extractedSeedAddress();
        int port = brokerServer.getPort();
        BrokerClusterManager brokerClusterManager = new BrokerClusterManager();
        ClusterMessageListenerImpl clusterMessageListener = new ClusterMessageListenerImpl();
        clusterMessageListener.setBrokerServer(brokerServer);
        brokerClusterManager.setBrokerId(brokerServer.getBrokerId()).setClusterMessageListener(clusterMessageListener).setSeedAddress(this.seedAddress).setGossipListenPort(this.gossipListenPort).setPort(port);
        return brokerClusterManager;
    }

    private void checked() {
        if (this.gossipListenPort <= 0) {
            ThrowKit.ofRuntimeException((String)"gossipListenPort error!");
        }
    }

    private void extractedSeedAddress() {
        if (Objects.isNull(this.seedAddress) || this.seedAddress.isEmpty()) {
            this.seedAddress = List.of("127.0.0.1:30056", "127.0.0.1:30057");
            log.warn("\u56e0\u4e3a\u4f60\u6ca1\u6709\u8bbe\u7f6e \u79cd\u5b50\u8282\u70b9\u4fe1\u606f\uff0c\u8fd9\u91cc\u4e3a\u4f60\u6dfb\u52a0\u4e00\u4e9b\u9ed8\u8ba4\u8bbe\u7f6e\u7684\u79cd\u5b50\u8282\u70b9");
        }
        if (IoGameGlobalConfig.isBrokerClusterLog()) {
            log.info("\u5f53\u524d\u79cd\u5b50\u8282\u70b9\u4fe1\u606f: {}", this.seedAddress);
        }
    }

    @Generated
    public BrokerClusterManagerBuilder seedAddress(List<String> seedAddress) {
        this.seedAddress = seedAddress;
        return this;
    }

    @Generated
    public BrokerClusterManagerBuilder gossipListenPort(int gossipListenPort) {
        this.gossipListenPort = gossipListenPort;
        return this;
    }
}

