/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.bolt.broker.cluster;

import com.iohao.game.bolt.broker.cluster.Broker;
import com.iohao.game.bolt.broker.cluster.BrokerClusterMessageHandler;
import com.iohao.game.bolt.broker.cluster.BrokerClusterMetadata;
import com.iohao.game.bolt.broker.cluster.ClusterMessageListener;
import com.iohao.game.bolt.broker.core.message.BrokerClusterMessage;
import com.iohao.game.common.kit.NetworkKit;
import io.scalecube.cluster.Cluster;
import io.scalecube.cluster.ClusterImpl;
import io.scalecube.net.Address;
import io.scalecube.transport.netty.tcp.TcpTransportFactory;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BrokerClusterManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger((String)"ClusterTopic");
    private String brokerId;
    private int port;
    private int gossipListenPort;
    private List<String> seedAddress;
    private Cluster cluster;
    private ClusterMessageListener clusterMessageListener;
    private String name;
    private BrokerClusterMessageHandler messageHandler;

    BrokerClusterManager() {
    }

    public void start() {
        String localIp = NetworkKit.LOCAL_IP;
        Broker localBroker = this.getLocalBroker(localIp);
        this.name = String.format("ioGameCluster-%d-%d-%s", this.port, this.gossipListenPort, localIp);
        this.messageHandler = new BrokerClusterMessageHandler(this.name, localBroker, this.clusterMessageListener);
        List<Address> seedMemberAddress = this.listSeedMemberAddress();
        this.cluster = new ClusterImpl().config(options -> options.memberAlias(this.name).metadata((Object)new BrokerClusterMetadata(this.name, localBroker)).externalHost(localIp).externalPort(Integer.valueOf(this.gossipListenPort))).membership(membershipConfig -> membershipConfig.seedMembers(seedMemberAddress).syncInterval(5000)).handler((Function)this.messageHandler).transportFactory(TcpTransportFactory::new).transport(transportConfig -> transportConfig.port(this.gossipListenPort)).startAwait();
        Map<String, Broker> brokers = this.messageHandler.brokers;
        brokers.put(localBroker.getClusterAddress(), localBroker);
    }

    public BrokerClusterMessage getBrokerClusterMessage() {
        return this.messageHandler.getBrokerClusterMessage();
    }

    private Broker getLocalBroker(String localIp) {
        String clusterAddress = localIp + ":" + this.gossipListenPort;
        String brokerAddress = localIp + ":" + this.port;
        return new Broker(localIp).setId(this.brokerId).setPort(this.port).setBrokerAddress(brokerAddress).setClusterAddress(clusterAddress);
    }

    private List<Address> listSeedMemberAddress() {
        return this.seedAddress.stream().map(Address::from).toList();
    }

    @Generated
    public String getBrokerId() {
        return this.brokerId;
    }

    @Generated
    public int getPort() {
        return this.port;
    }

    @Generated
    public int getGossipListenPort() {
        return this.gossipListenPort;
    }

    @Generated
    public List<String> getSeedAddress() {
        return this.seedAddress;
    }

    @Generated
    public Cluster getCluster() {
        return this.cluster;
    }

    @Generated
    public ClusterMessageListener getClusterMessageListener() {
        return this.clusterMessageListener;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public BrokerClusterMessageHandler getMessageHandler() {
        return this.messageHandler;
    }

    @Generated
    public BrokerClusterManager setBrokerId(String brokerId) {
        this.brokerId = brokerId;
        return this;
    }

    @Generated
    public BrokerClusterManager setPort(int port) {
        this.port = port;
        return this;
    }

    @Generated
    public BrokerClusterManager setGossipListenPort(int gossipListenPort) {
        this.gossipListenPort = gossipListenPort;
        return this;
    }

    @Generated
    public BrokerClusterManager setSeedAddress(List<String> seedAddress) {
        this.seedAddress = seedAddress;
        return this;
    }

    @Generated
    public BrokerClusterManager setCluster(Cluster cluster) {
        this.cluster = cluster;
        return this;
    }

    @Generated
    public BrokerClusterManager setClusterMessageListener(ClusterMessageListener clusterMessageListener) {
        this.clusterMessageListener = clusterMessageListener;
        return this;
    }

    @Generated
    public BrokerClusterManager setName(String name) {
        this.name = name;
        return this;
    }

    @Generated
    public BrokerClusterManager setMessageHandler(BrokerClusterMessageHandler messageHandler) {
        this.messageHandler = messageHandler;
        return this;
    }
}

