/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.bolt.broker.server.processor.connection;

import com.alipay.remoting.Connection;
import com.alipay.remoting.ConnectionEventProcessor;
import com.alipay.remoting.ConnectionEventType;
import com.alipay.remoting.exception.RemotingException;
import com.iohao.game.bolt.broker.core.common.IoGameGlobalConfig;
import com.iohao.game.bolt.broker.core.message.RequestBrokerClientModuleMessage;
import com.iohao.game.bolt.broker.server.BrokerServer;
import com.iohao.game.bolt.broker.server.aware.BrokerServerAware;
import com.iohao.game.common.kit.log.IoGameLoggerFactory;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;

public class ConnectionEventBrokerProcessor
implements ConnectionEventProcessor,
BrokerServerAware {
    static final Logger log = IoGameLoggerFactory.getLoggerConnection();
    private final AtomicInteger connectTimes = new AtomicInteger();
    private final AtomicBoolean connected = new AtomicBoolean();
    private Connection connection;
    private String remoteAddress;
    private final CountDownLatch latch = new CountDownLatch(1);
    private BrokerServer brokerServer;
    static final RequestBrokerClientModuleMessage requestBrokerClientModuleMessage = new RequestBrokerClientModuleMessage();

    public void onEvent(String remoteAddress, Connection conn) {
        ConnectionEventBrokerProcessor.extractedPrint(remoteAddress, conn);
        Objects.requireNonNull(remoteAddress);
        this.doCheckConnection(conn);
        this.remoteAddress = remoteAddress;
        this.connection = conn;
        this.connected.set(true);
        this.connectTimes.incrementAndGet();
        this.latch.countDown();
        int withNo = this.brokerServer.getWithNo();
        requestBrokerClientModuleMessage.setWithNo(withNo);
        try {
            this.brokerServer.getRpcServer().oneway(conn, (Object)requestBrokerClientModuleMessage);
        }
        catch (RemotingException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private static void extractedPrint(String remoteAddress, Connection conn) {
        if (IoGameGlobalConfig.openLog) {
            log.info("Broker ConnectionEventType:\u3010{}\u3011 remoteAddress:\u3010{}\u3011\uff0cConnection:\u3010{}\u3011", new Object[]{ConnectionEventType.CONNECT, remoteAddress, conn});
        }
    }

    private void doCheckConnection(Connection conn) {
        Objects.requireNonNull(conn);
        Objects.requireNonNull(conn.getPoolKeys());
        Objects.requireNonNull(conn.getChannel());
        Objects.requireNonNull(conn.getUrl());
        Objects.requireNonNull((Connection)conn.getChannel().attr(Connection.CONNECTION).get());
    }

    public boolean isConnected() throws InterruptedException {
        this.latch.await();
        return this.connected.get();
    }

    public int getConnectTimes() throws InterruptedException {
        this.latch.await();
        return this.connectTimes.get();
    }

    public Connection getConnection() throws InterruptedException {
        this.latch.await();
        return this.connection;
    }

    public String getRemoteAddress() throws InterruptedException {
        this.latch.await();
        return this.remoteAddress;
    }

    public void reset() {
        this.connectTimes.set(0);
        this.connected.set(false);
        this.connection = null;
    }

    @Override
    public void setBrokerServer(BrokerServer brokerServer) {
        this.brokerServer = brokerServer;
    }
}

