/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.bolt.broker.server.processor.connection;

import com.alipay.remoting.Connection;
import com.alipay.remoting.ConnectionEventProcessor;
import com.alipay.remoting.ConnectionEventType;
import com.alipay.remoting.exception.RemotingException;
import com.iohao.game.bolt.broker.core.aware.CmdRegionsAware;
import com.iohao.game.bolt.broker.core.client.BrokerClientType;
import com.iohao.game.bolt.broker.core.common.IoGameGlobalConfig;
import com.iohao.game.bolt.broker.core.message.BrokerClientModuleMessage;
import com.iohao.game.bolt.broker.core.message.BrokerClientModuleMessageOffline;
import com.iohao.game.bolt.broker.server.BrokerServer;
import com.iohao.game.bolt.broker.server.aware.BrokerClientModulesAware;
import com.iohao.game.bolt.broker.server.aware.BrokerServerAware;
import com.iohao.game.bolt.broker.server.balanced.BalancedManager;
import com.iohao.game.bolt.broker.server.balanced.region.BrokerClientProxy;
import com.iohao.game.bolt.broker.server.kit.BrokerPrintKit;
import com.iohao.game.bolt.broker.server.service.BrokerClientModules;
import com.iohao.game.common.kit.log.IoGameLoggerFactory;
import com.iohao.game.core.common.cmd.BrokerClientId;
import com.iohao.game.core.common.cmd.CmdRegions;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.slf4j.Logger;

public class CloseConnectionEventBrokerProcessor
implements ConnectionEventProcessor,
BrokerServerAware,
BrokerClientModulesAware,
CmdRegionsAware {
    static final Logger log = IoGameLoggerFactory.getLoggerConnection();
    private final AtomicInteger disConnectTimes = new AtomicInteger();
    private final AtomicBoolean dicConnected = new AtomicBoolean();
    BrokerServer brokerServer;
    BrokerClientModules brokerClientModules;
    CmdRegions cmdRegions;

    public void onEvent(String remoteAddress, Connection conn) {
        if (IoGameGlobalConfig.openLog) {
            log.info("Broker ConnectionEventType:\u3010{}\u3011 remoteAddress:\u3010{}\u3011\uff0cConnection:\u3010{}\u3011", new Object[]{ConnectionEventType.CLOSE, remoteAddress, conn});
        }
        Objects.requireNonNull(conn);
        this.dicConnected.set(true);
        this.disConnectTimes.incrementAndGet();
        BalancedManager balancedManager = this.brokerServer.getBalancedManager();
        BrokerClientProxy brokerClientProxy = balancedManager.remove(remoteAddress);
        CloseConnectionEventBrokerProcessor.extractedPrint(remoteAddress, brokerClientProxy);
        BrokerPrintKit.print(this.brokerServer);
        Optional.ofNullable(brokerClientProxy).ifPresent(proxy -> {
            String id = proxy.getId();
            BrokerClientModuleMessage moduleMessage = this.brokerClientModules.removeById(id);
            if (Objects.isNull(moduleMessage)) {
                return;
            }
            BrokerClientType brokerClientType = moduleMessage.getBrokerClientType();
            if (brokerClientType != BrokerClientType.LOGIC) {
                return;
            }
            this.unLoading(moduleMessage);
            Consumer<BrokerClientProxy> consumer = externalProxy -> {
                BrokerClientModuleMessageOffline offline = new BrokerClientModuleMessageOffline();
                offline.setBrokerClientModuleMessage(moduleMessage);
                try {
                    externalProxy.oneway(offline);
                }
                catch (RemotingException | InterruptedException e) {
                    log.error(e.getMessage(), e);
                }
            };
            this.brokerServer.getBalancedManager().getExternalLoadBalanced().listBrokerClientProxy().forEach(consumer);
        });
    }

    private static void extractedPrint(String remoteAddress, BrokerClientProxy brokerClientProxy) {
        if (IoGameGlobalConfig.openLog) {
            log.info("Broker ConnectionEventType:\u3010{}\u3011 remoteAddress:\u3010{}\u3011\uff0cbrokerClientProxy:\u3010{}\u3011", new Object[]{ConnectionEventType.CLOSE, remoteAddress, brokerClientProxy});
        }
    }

    private void unLoading(BrokerClientModuleMessage moduleMessage) {
        String id = moduleMessage.getId();
        int idHash = moduleMessage.getIdHash();
        BrokerClientId brokerClientId = new BrokerClientId(idHash, id);
        this.cmdRegions.unLoading(brokerClientId);
    }

    public boolean isDisConnected() {
        return this.dicConnected.get();
    }

    public int getDisConnectTimes() {
        return this.disConnectTimes.get();
    }

    public void reset() {
        this.disConnectTimes.set(0);
        this.dicConnected.set(false);
    }

    @Override
    public void setBrokerServer(BrokerServer brokerServer) {
        this.brokerServer = brokerServer;
    }

    @Override
    public void setBrokerClientModules(BrokerClientModules brokerClientModules) {
        this.brokerClientModules = brokerClientModules;
    }

    public void setCmdRegions(CmdRegions cmdRegions) {
        this.cmdRegions = cmdRegions;
    }
}

