/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.bolt.broker.server.processor;

import com.alipay.remoting.AsyncContext;
import com.alipay.remoting.BizContext;
import com.alipay.remoting.exception.RemotingException;
import com.iohao.game.action.skeleton.protocol.HeadMetadata;
import com.iohao.game.action.skeleton.protocol.ResponseMessage;
import com.iohao.game.bolt.broker.core.common.AbstractAsyncUserProcessor;
import com.iohao.game.bolt.broker.core.common.IoGameGlobalConfig;
import com.iohao.game.bolt.broker.server.BrokerServer;
import com.iohao.game.bolt.broker.server.aware.BrokerServerAware;
import com.iohao.game.bolt.broker.server.balanced.BalancedManager;
import com.iohao.game.bolt.broker.server.balanced.ExternalBrokerClientLoadBalanced;
import com.iohao.game.bolt.broker.server.balanced.region.BrokerClientProxy;
import com.iohao.game.common.kit.log.IoGameLoggerFactory;
import java.util.Objects;
import org.slf4j.Logger;

public class ResponseMessageBrokerProcessor
extends AbstractAsyncUserProcessor<ResponseMessage>
implements BrokerServerAware {
    static final Logger log = IoGameLoggerFactory.getLoggerMsg();
    BrokerServer brokerServer;

    public void handleRequest(BizContext bizCtx, AsyncContext asyncCtx, ResponseMessage responseMessage) {
        if (IoGameGlobalConfig.requestResponseLog) {
            log.info("\u628a\u903b\u8f91\u670d\u7684\u54cd\u5e94\u8f6c\u53d1\u5230\u5bf9\u5916\u670d {}", (Object)responseMessage);
        }
        HeadMetadata headMetadata = responseMessage.getHeadMetadata();
        int sourceClientId = headMetadata.getSourceClientId();
        BalancedManager balancedManager = this.brokerServer.getBalancedManager();
        ExternalBrokerClientLoadBalanced externalLoadBalanced = balancedManager.getExternalLoadBalanced();
        BrokerClientProxy brokerClientProxy = externalLoadBalanced.get(sourceClientId);
        if (Objects.isNull(brokerClientProxy)) {
            log.warn("\u5bf9\u5916\u670d\u4e0d\u5b58\u5728: [{}]", (Object)sourceClientId);
            return;
        }
        try {
            brokerClientProxy.oneway(responseMessage);
        }
        catch (RemotingException | InterruptedException e) {
            log.error(e.getMessage(), e);
        }
    }

    public String interest() {
        return ResponseMessage.class.getName();
    }

    @Override
    public void setBrokerServer(BrokerServer brokerServer) {
        this.brokerServer = brokerServer;
    }
}

