/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.bolt.broker.server.processor;

import com.alipay.remoting.AsyncContext;
import com.alipay.remoting.BizContext;
import com.alipay.remoting.Connection;
import com.alipay.remoting.exception.RemotingException;
import com.alipay.remoting.rpc.RpcServer;
import com.iohao.game.action.skeleton.core.exception.ActionErrorEnum;
import com.iohao.game.action.skeleton.protocol.HeadMetadata;
import com.iohao.game.action.skeleton.protocol.RequestMessage;
import com.iohao.game.action.skeleton.protocol.ResponseMessage;
import com.iohao.game.bolt.broker.core.aware.CmdRegionsAware;
import com.iohao.game.bolt.broker.core.common.AbstractAsyncUserProcessor;
import com.iohao.game.bolt.broker.core.common.IoGameGlobalConfig;
import com.iohao.game.bolt.broker.server.BrokerServer;
import com.iohao.game.bolt.broker.server.aware.BrokerServerAware;
import com.iohao.game.bolt.broker.server.balanced.BalancedManager;
import com.iohao.game.bolt.broker.server.balanced.ExternalBrokerClientLoadBalanced;
import com.iohao.game.bolt.broker.server.balanced.LogicBrokerClientLoadBalanced;
import com.iohao.game.bolt.broker.server.balanced.region.BrokerClientProxy;
import com.iohao.game.bolt.broker.server.balanced.region.BrokerClientRegion;
import com.iohao.game.bolt.broker.server.kit.EndPointClientIdKit;
import com.iohao.game.common.kit.log.IoGameLoggerFactory;
import com.iohao.game.core.common.cmd.CmdRegions;
import org.slf4j.Logger;

public class RequestMessageBrokerProcessor
extends AbstractAsyncUserProcessor<RequestMessage>
implements BrokerServerAware,
CmdRegionsAware {
    static final Logger log = IoGameLoggerFactory.getLoggerMsg();
    BrokerServer brokerServer;
    CmdRegions cmdRegions;

    public void handleRequest(BizContext bizCtx, AsyncContext asyncCtx, RequestMessage request) {
        HeadMetadata headMetadata;
        BalancedManager balancedManager;
        LogicBrokerClientLoadBalanced loadBalanced;
        BrokerClientRegion brokerClientRegion;
        if (IoGameGlobalConfig.requestResponseLog) {
            this.extractedPrint(request);
        }
        if ((brokerClientRegion = (loadBalanced = (balancedManager = this.brokerServer.getBalancedManager()).getLogicBalanced()).getBrokerClientRegion((headMetadata = request.getHeadMetadata()).getCmdMerge())) == null) {
            this.extractedNotRoute(bizCtx, request);
            return;
        }
        EndPointClientIdKit.endPointClientId(headMetadata, this.cmdRegions);
        headMetadata.setWithNo(this.brokerServer.getWithNo());
        BrokerClientProxy brokerClientProxy = brokerClientRegion.getBrokerClientProxy(headMetadata);
        if (brokerClientProxy == null) {
            this.extractedNotRoute(bizCtx, request);
            return;
        }
        try {
            brokerClientProxy.oneway(request);
        }
        catch (RemotingException | InterruptedException | NullPointerException e) {
            log.error(e.getMessage(), e);
        }
    }

    private void extractedPrint(RequestMessage request) {
        log.info("\u6e38\u620f\u7f51\u5173\u628a\u5bf9\u5916\u670d \u8bf7\u6c42 \u8f6c\u53d1\u5230\u903b\u8f91\u670d : {}", (Object)request);
        BalancedManager balancedManager = this.brokerServer.getBalancedManager();
        ExternalBrokerClientLoadBalanced externalLoadBalanced = balancedManager.getExternalLoadBalanced();
        for (BrokerClientProxy brokerClientProxy : externalLoadBalanced.listBrokerClientProxy()) {
            log.info("brokerClientProxy : {}", (Object)brokerClientProxy);
        }
    }

    private void extractedNotRoute(BizContext bizCtx, RequestMessage requestMessage) {
        Connection connection = bizCtx.getConnection();
        ResponseMessage responseMessage = requestMessage.createResponseMessage();
        HeadMetadata headMetadata = requestMessage.getHeadMetadata();
        ActionErrorEnum errorCode = ActionErrorEnum.cmdInfoErrorCode;
        Object object = headMetadata.getOther();
        if (object instanceof ActionErrorEnum) {
            ActionErrorEnum theCode;
            errorCode = theCode = (ActionErrorEnum)object;
        }
        responseMessage.setValidatorMsg(errorCode.getMsg()).setResponseStatus(errorCode.getCode());
        RpcServer rpcServer = this.brokerServer.getRpcServer();
        try {
            rpcServer.oneway(connection, (Object)responseMessage);
        }
        catch (RemotingException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public String interest() {
        return RequestMessage.class.getName();
    }

    @Override
    public void setBrokerServer(BrokerServer brokerServer) {
        this.brokerServer = brokerServer;
    }

    public void setCmdRegions(CmdRegions cmdRegions) {
        this.cmdRegions = cmdRegions;
    }
}

