/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.bolt.broker.server.processor;

import com.alipay.remoting.AsyncContext;
import com.alipay.remoting.BizContext;
import com.alipay.remoting.exception.RemotingException;
import com.alipay.remoting.rpc.RpcServer;
import com.alipay.remoting.rpc.protocol.AsyncUserProcessor;
import com.iohao.game.bolt.broker.cluster.BrokerClusterManager;
import com.iohao.game.bolt.broker.cluster.BrokerRunModeEnum;
import com.iohao.game.bolt.broker.core.aware.CmdRegionsAware;
import com.iohao.game.bolt.broker.core.client.BrokerClientType;
import com.iohao.game.bolt.broker.core.common.IoGameGlobalConfig;
import com.iohao.game.bolt.broker.core.message.BrokerClientModuleMessage;
import com.iohao.game.bolt.broker.core.message.BrokerClusterMessage;
import com.iohao.game.bolt.broker.core.message.BrokerMessage;
import com.iohao.game.bolt.broker.server.BrokerServer;
import com.iohao.game.bolt.broker.server.aware.BrokerClientModulesAware;
import com.iohao.game.bolt.broker.server.aware.BrokerServerAware;
import com.iohao.game.bolt.broker.server.balanced.BalancedManager;
import com.iohao.game.bolt.broker.server.balanced.region.BrokerClientProxy;
import com.iohao.game.bolt.broker.server.kit.BrokerPrintKit;
import com.iohao.game.bolt.broker.server.service.BrokerClientModules;
import com.iohao.game.common.kit.ExecutorKit;
import com.iohao.game.common.kit.log.IoGameLoggerFactory;
import com.iohao.game.core.common.cmd.CmdRegions;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;

public class RegisterBrokerClientModuleMessageBrokerProcessor
extends AsyncUserProcessor<BrokerClientModuleMessage>
implements BrokerServerAware,
BrokerClientModulesAware,
CmdRegionsAware {
    private static final Logger log = IoGameLoggerFactory.getLoggerCommonStdout();
    BrokerServer brokerServer;
    BrokerClientModules brokerClientModules;
    CmdRegions cmdRegions;
    AtomicBoolean fixedRateFlag = new AtomicBoolean(false);

    public void handleRequest(BizContext bizCtx, AsyncContext asyncCtx, BrokerClientModuleMessage brokerClientModuleMessage) {
        this.brokerClientModules.add(brokerClientModuleMessage);
        String remoteAddress = bizCtx.getRemoteAddress();
        brokerClientModuleMessage.setAddress(remoteAddress);
        BalancedManager balancedManager = this.brokerServer.getBalancedManager();
        balancedManager.register(brokerClientModuleMessage);
        if (this.brokerServer.getBrokerRunMode() == BrokerRunModeEnum.CLUSTER) {
            this.sendClusterMessage(bizCtx);
            this.printCluster();
        }
        this.print(brokerClientModuleMessage);
        if (IoGameGlobalConfig.isSendBrokerClientModuleMessage()) {
            this.sendBrokerClientModuleMessage(brokerClientModuleMessage);
        }
    }

    private void sendBrokerClientModuleMessage(BrokerClientModuleMessage moduleMessage) {
        BrokerClientType brokerClientType = moduleMessage.getBrokerClientType();
        if (brokerClientType == BrokerClientType.LOGIC) {
            this.extractedLogic(moduleMessage);
        }
        if (brokerClientType == BrokerClientType.EXTERNAL) {
            this.extractedExternal(moduleMessage);
        }
    }

    private void extractedExternal(BrokerClientModuleMessage moduleMessage) {
        String address = moduleMessage.getAddress();
        RpcServer rpcServer = this.brokerServer.getRpcServer();
        Consumer<BrokerClientModuleMessage> consumer = message -> {
            try {
                rpcServer.oneway(address, message);
            }
            catch (RemotingException | InterruptedException e) {
                log.error(e.getMessage(), e);
            }
        };
        this.brokerClientModules.listBrokerClientModuleMessage().stream().filter(message -> message.getBrokerClientType() == BrokerClientType.LOGIC).forEach(consumer);
    }

    private void extractedLogic(BrokerClientModuleMessage moduleMessage) {
        this.cmdRegions.loading(moduleMessage);
        Consumer<BrokerClientProxy> consumer = proxy -> {
            try {
                proxy.oneway(moduleMessage);
            }
            catch (RemotingException | InterruptedException e) {
                log.error(e.getMessage(), e);
            }
        };
        this.brokerServer.getBalancedManager().getExternalLoadBalanced().listBrokerClientProxy().forEach(consumer);
    }

    private void printCluster(BrokerClusterMessage brokerClusterMessage) {
        if (this.brokerServer.getBrokerRunMode() != BrokerRunModeEnum.CLUSTER) {
            return;
        }
        if (IoGameGlobalConfig.isBrokerClusterLog()) {
            String message = brokerClusterMessage.getBrokerMessageList().stream().map(BrokerMessage::toString).collect(Collectors.joining("\n"));
            log.info("\n\u6e38\u620f\u7f51\u5173\u7aef\u53e3: [{}] --  \u96c6\u7fa4\u6570\u91cf[{}] - \u8be6\u7ec6\uff1a\n[{}]", new Object[]{this.brokerServer.getPort(), brokerClusterMessage.count(), message});
        }
    }

    private void sendClusterMessage(BizContext bizCtx) {
        BrokerClusterManager brokerClusterManager = this.brokerServer.getBrokerClusterManager();
        BrokerClusterMessage brokerClusterMessage = brokerClusterManager.getBrokerClusterMessage();
        this.printCluster(brokerClusterMessage);
        try {
            this.brokerServer.getRpcServer().oneway(bizCtx.getConnection(), (Object)brokerClusterMessage);
        }
        catch (RemotingException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void print(BrokerClientModuleMessage brokerClientModuleMessage) {
        int port = this.brokerServer.getPort();
        if (IoGameGlobalConfig.openLog) {
            log.info("\u6a21\u5757\u6ce8\u518c\u4fe1\u606f --- \u7f51\u5173port: [{}] --- {}", (Object)port, (Object)brokerClientModuleMessage);
        }
        BrokerPrintKit.print(this.brokerServer);
    }

    private void printCluster() {
        if (this.brokerServer.getBrokerRunMode() != BrokerRunModeEnum.CLUSTER) {
            return;
        }
        if (!IoGameGlobalConfig.isBrokerClusterFixedRateLog()) {
            return;
        }
        if (this.fixedRateFlag.compareAndSet(false, true)) {
            ExecutorKit.newSingleScheduled((String)"print").scheduleAtFixedRate(() -> {
                BrokerPrintKit.print(this.brokerServer);
                BrokerClusterManager brokerClusterManager = this.brokerServer.getBrokerClusterManager();
                BrokerClusterMessage brokerClusterMessage = brokerClusterManager.getBrokerClusterMessage();
                this.printCluster(brokerClusterMessage);
            }, 5L, 30L, TimeUnit.SECONDS);
        }
    }

    public String interest() {
        return BrokerClientModuleMessage.class.getName();
    }

    @Override
    public void setBrokerServer(BrokerServer brokerServer) {
        this.brokerServer = brokerServer;
    }

    @Override
    public void setBrokerClientModules(BrokerClientModules brokerClientModules) {
        this.brokerClientModules = brokerClientModules;
    }

    public void setCmdRegions(CmdRegions cmdRegions) {
        this.cmdRegions = cmdRegions;
    }
}

