/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.bolt.broker.server.processor;

import com.alipay.remoting.AsyncContext;
import com.alipay.remoting.BizContext;
import com.alipay.remoting.exception.RemotingException;
import com.iohao.game.action.skeleton.pulse.message.PulseSignalRequest;
import com.iohao.game.bolt.broker.core.common.AbstractAsyncUserProcessor;
import com.iohao.game.bolt.broker.server.BrokerServer;
import com.iohao.game.bolt.broker.server.aware.BrokerServerAware;
import com.iohao.game.bolt.broker.server.balanced.BalancedManager;
import com.iohao.game.bolt.broker.server.balanced.region.BrokerClientProxy;
import java.util.function.Consumer;

public class PulseSignalRequestBrokerProcessor
extends AbstractAsyncUserProcessor<PulseSignalRequest>
implements BrokerServerAware {
    BrokerServer brokerServer;

    @Override
    public void setBrokerServer(BrokerServer brokerServer) {
        this.brokerServer = brokerServer;
    }

    public void handleRequest(BizContext bizCtx, AsyncContext asyncCtx, PulseSignalRequest request) {
        BalancedManager balancedManager = this.brokerServer.getBalancedManager();
        Consumer<BrokerClientProxy> consumer = client -> {
            try {
                client.oneway(request);
            }
            catch (RemotingException | InterruptedException e) {
                throw new RuntimeException(e);
            }
        };
        if (request.containsSignalType(1)) {
            balancedManager.getExternalLoadBalanced().listBrokerClientProxy().forEach(consumer);
        }
        if (request.containsSignalType(4)) {
            balancedManager.getLogicBalanced().listBrokerClientRegion().stream().flatMap(clientRegion -> clientRegion.listBrokerClientProxy().stream()).forEach(consumer);
        }
    }

    public String interest() {
        return PulseSignalRequest.class.getName();
    }
}

