/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.bolt.broker.server.processor;

import com.alipay.remoting.AsyncContext;
import com.alipay.remoting.BizContext;
import com.alipay.remoting.exception.RemotingException;
import com.iohao.game.action.skeleton.protocol.HeadMetadata;
import com.iohao.game.action.skeleton.protocol.RequestMessage;
import com.iohao.game.bolt.broker.core.common.AbstractAsyncUserProcessor;
import com.iohao.game.bolt.broker.core.message.InnerModuleVoidMessage;
import com.iohao.game.bolt.broker.server.BrokerServer;
import com.iohao.game.bolt.broker.server.aware.BrokerServerAware;
import com.iohao.game.bolt.broker.server.balanced.BalancedManager;
import com.iohao.game.bolt.broker.server.balanced.LogicBrokerClientLoadBalanced;
import com.iohao.game.bolt.broker.server.balanced.region.BrokerClientProxy;
import com.iohao.game.bolt.broker.server.balanced.region.BrokerClientRegion;
import com.iohao.game.common.kit.log.IoGameLoggerFactory;
import org.slf4j.Logger;

public class InnerModuleVoidMessageBrokerProcessor
extends AbstractAsyncUserProcessor<InnerModuleVoidMessage>
implements BrokerServerAware {
    static final Logger log = IoGameLoggerFactory.getLoggerCommon();
    private BrokerServer brokerServer;

    public void handleRequest(BizContext bizCtx, AsyncContext asyncCtx, InnerModuleVoidMessage innerModuleMessage) {
        RequestMessage requestMessage = innerModuleMessage.getRequestMessage();
        HeadMetadata headMetadata = requestMessage.getHeadMetadata();
        int cmdMerge = headMetadata.getCmdMerge();
        BalancedManager balancedManager = this.brokerServer.getBalancedManager();
        LogicBrokerClientLoadBalanced logicBalanced = balancedManager.getLogicBalanced();
        BrokerClientRegion brokerClientRegion = logicBalanced.getBrokerClientRegion(cmdMerge);
        if (brokerClientRegion == null) {
            return;
        }
        BrokerClientProxy brokerClientProxy = brokerClientRegion.getBrokerClientProxy(headMetadata);
        if (brokerClientProxy == null) {
            return;
        }
        try {
            brokerClientProxy.oneway(requestMessage);
        }
        catch (RemotingException | InterruptedException e) {
            log.error(e.getMessage(), e);
        }
    }

    public String interest() {
        return InnerModuleVoidMessage.class.getName();
    }

    @Override
    public void setBrokerServer(BrokerServer brokerServer) {
        this.brokerServer = brokerServer;
    }
}

