/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.bolt.broker.server.processor;

import com.alipay.remoting.AsyncContext;
import com.alipay.remoting.BizContext;
import com.alipay.remoting.rpc.protocol.AsyncUserProcessor;
import com.iohao.game.bolt.broker.core.common.IoGameGlobalConfig;
import com.iohao.game.bolt.broker.core.message.BroadcastMessage;
import com.iohao.game.bolt.broker.core.message.BroadcastOrderMessage;
import com.iohao.game.bolt.broker.server.BrokerServer;
import com.iohao.game.bolt.broker.server.aware.BrokerServerAware;
import com.iohao.game.bolt.broker.server.processor.BrokerExternalKit;
import com.iohao.game.common.kit.ExecutorKit;
import com.iohao.game.common.kit.log.IoGameLoggerFactory;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;

public class BroadcastOrderMessageBrokerProcessor
extends AsyncUserProcessor<BroadcastOrderMessage>
implements BrokerServerAware {
    static final Logger log = IoGameLoggerFactory.getLoggerMsg();
    BrokerServer brokerServer;
    final ExecutorService executorService = ExecutorKit.newSingleThreadExecutor((String)"BroadcastOrderBroker");

    public void handleRequest(BizContext bizCtx, AsyncContext asyncCtx, BroadcastOrderMessage broadcastOrderMessage) {
        if (IoGameGlobalConfig.broadcastLog) {
            log.info("Broadcast \u7f51\u5173 \u987a\u5e8f\u7684 \u5e7f\u64ad\u6d88\u606f\u5230\u5bf9\u5916\u670d\u52a1\u5668 {}", (Object)broadcastOrderMessage);
        }
        BrokerExternalKit.sendMessageToExternal(this.brokerServer, (BroadcastMessage)broadcastOrderMessage);
    }

    public Executor getExecutor() {
        return this.executorService;
    }

    public String interest() {
        return BroadcastOrderMessage.class.getName();
    }

    @Override
    public void setBrokerServer(BrokerServer brokerServer) {
        this.brokerServer = brokerServer;
    }
}

