/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.bolt.broker.server.kit;

import com.iohao.game.bolt.broker.core.common.IoGameGlobalConfig;
import com.iohao.game.bolt.broker.server.BrokerServer;
import com.iohao.game.bolt.broker.server.balanced.BalancedManager;
import com.iohao.game.common.kit.log.IoGameLoggerFactory;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;

public final class BrokerPrintKit {
    private static final Logger log = IoGameLoggerFactory.getLoggerCommonStdout();

    public static void print(BrokerServer brokerServer) {
        if (!IoGameGlobalConfig.openLog) {
            return;
        }
        BalancedManager balancedManager = brokerServer.getBalancedManager();
        List collect = balancedManager.getLogicBalanced().listBrokerClientRegion().stream().map(brokerClientRegion -> {
            String tag = brokerClientRegion.getTag();
            int count = brokerClientRegion.count();
            return new BrokerClientNodeInfo(tag, count);
        }).collect(Collectors.toList());
        int externalCount = balancedManager.getExternalLoadBalanced().count();
        BrokerClientNodeInfo externalNodeInfo = new BrokerClientNodeInfo("\u6e38\u620f\u5bf9\u5916\u670d", externalCount);
        collect.add(externalNodeInfo);
        String info = collect.stream().map(BrokerClientNodeInfo::toString).collect(Collectors.joining("\n\t", "\n\t", ""));
        int port = brokerServer.getPort();
        log.info("\u5f53\u524d\u7f51\u5173\u3010{}\u3011\u4e0e\u903b\u8f91\u670d\u76f8\u5173\u4fe1\u606f: {}", (Object)port, (Object)info);
    }

    private BrokerPrintKit() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private record BrokerClientNodeInfo(String tag, int count) {
        @Override
        public String toString() {
            return "{\u670d\u52a1\u5668\u6570\u91cf:" + this.count + ", tag:'" + this.tag + "'}";
        }
    }
}

