/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.bolt.broker.server.balanced.region;

import com.iohao.game.action.skeleton.core.exception.ActionErrorEnum;
import com.iohao.game.action.skeleton.protocol.HeadMetadata;
import com.iohao.game.bolt.broker.server.balanced.region.BrokerClientProxy;
import com.iohao.game.bolt.broker.server.balanced.region.BrokerClientRegion;
import com.iohao.game.bolt.broker.server.balanced.region.DefaultWithElementSelector;
import com.iohao.game.bolt.broker.server.balanced.region.WithElementSelector;
import java.util.Map;
import java.util.Objects;
import org.jctools.maps.NonBlockingHashMap;

public final class StrictBrokerClientRegion
implements BrokerClientRegion {
    final Map<Integer, BrokerClientProxy> brokerClientProxyMap = new NonBlockingHashMap();
    final String tag;
    WithElementSelector<BrokerClientProxy> withElementSelector;

    public StrictBrokerClientRegion(String tag) {
        this.tag = tag;
    }

    @Override
    public BrokerClientProxy getBrokerClientProxy(HeadMetadata headMetadata) {
        int endPointClientId = headMetadata.getEndPointClientId();
        if (endPointClientId != 0) {
            BrokerClientProxy brokerClientProxy = this.brokerClientProxyMap.get(endPointClientId);
            if (Objects.isNull(brokerClientProxy)) {
                headMetadata.setOther((Object)ActionErrorEnum.findBindingLogicServerNotExist);
            }
            return brokerClientProxy;
        }
        if (Objects.isNull(this.withElementSelector)) {
            return null;
        }
        return this.withElementSelector.next(headMetadata.getWithNo());
    }

    @Override
    public void add(BrokerClientProxy brokerClientProxy) {
        int id = brokerClientProxy.getIdHash();
        this.brokerClientProxyMap.put(id, brokerClientProxy);
        this.resetSelector();
    }

    @Override
    public void remove(int id) {
        this.brokerClientProxyMap.remove(id);
        this.resetSelector();
    }

    @Override
    public String getTag() {
        return this.tag;
    }

    @Override
    public int count() {
        return this.brokerClientProxyMap.size();
    }

    @Override
    public Map<Integer, BrokerClientProxy> getBrokerClientProxyMap() {
        return this.brokerClientProxyMap;
    }

    @Override
    public BrokerClientProxy getBoltClientProxy(HeadMetadata headMetadata) {
        throw new RuntimeException("\u8bf7\u4f7f\u7528 getBrokerClientProxy \u65b9\u6cd5");
    }

    @Override
    public Map<Integer, BrokerClientProxy> getBoltClientProxyMap() {
        throw new RuntimeException("\u8bf7\u4f7f\u7528 getBrokerClientProxyMap \u65b9\u6cd5");
    }

    private void resetSelector() {
        this.withElementSelector = new DefaultWithElementSelector(this.brokerClientProxyMap);
    }
}

