/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.bolt.broker.server.balanced.region;

import com.iohao.game.bolt.broker.core.loadbalance.ElementSelector;
import com.iohao.game.bolt.broker.core.loadbalance.RandomElementSelector;
import com.iohao.game.bolt.broker.server.balanced.region.BrokerClientProxy;
import com.iohao.game.bolt.broker.server.balanced.region.WithElementSelector;
import com.iohao.game.common.kit.RandomKit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

final class DefaultWithElementSelector
implements WithElementSelector<BrokerClientProxy> {
    int size;
    Map<Integer, List<BrokerClientProxy>> map;
    ElementSelector<BrokerClientProxy> elementSelector;

    public DefaultWithElementSelector(Map<Integer, BrokerClientProxy> proxyMap) {
        List<BrokerClientProxy> list = proxyMap.values().stream().filter(Objects::nonNull).toList();
        this.size = list.size();
        if (this.size == 0) {
            return;
        }
        this.elementSelector = new RandomElementSelector(list);
        this.map = new HashMap<Integer, List<BrokerClientProxy>>();
        for (BrokerClientProxy brokerClientProxy : list) {
            int withNo = brokerClientProxy.getWithNo();
            if (withNo == 0) continue;
            List<BrokerClientProxy> withList = this.map.get(withNo);
            if (Objects.isNull(withList)) {
                withList = new ArrayList<BrokerClientProxy>();
                this.map.put(withNo, withList);
            }
            withList.add(brokerClientProxy);
        }
    }

    @Override
    public BrokerClientProxy next(int withNo) {
        if (this.size == 0) {
            return null;
        }
        if (withNo == 0) {
            return (BrokerClientProxy)this.elementSelector.get();
        }
        List<BrokerClientProxy> list = this.map.get(withNo);
        BrokerClientProxy brokerClientProxy = (BrokerClientProxy)RandomKit.randomEle(list);
        if (Objects.nonNull(brokerClientProxy)) {
            return brokerClientProxy;
        }
        return (BrokerClientProxy)this.elementSelector.next();
    }
}

