/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.bolt.broker.server.balanced.region;

import com.iohao.game.action.skeleton.protocol.HeadMetadata;
import com.iohao.game.bolt.broker.core.loadbalance.ElementSelector;
import com.iohao.game.bolt.broker.core.loadbalance.RandomElementSelector;
import com.iohao.game.bolt.broker.server.balanced.region.BrokerClientProxy;
import com.iohao.game.bolt.broker.server.balanced.region.BrokerClientRegion;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import org.jctools.maps.NonBlockingHashMap;

public class DefaultBrokerClientRegion
implements BrokerClientRegion {
    protected final Map<Integer, BrokerClientProxy> boltClientProxyMap = new NonBlockingHashMap();
    protected final String tag;
    protected ElementSelector<BrokerClientProxy> elementSelector;

    public DefaultBrokerClientRegion(String tag) {
        this.tag = tag;
    }

    @Override
    public BrokerClientProxy getBoltClientProxy(HeadMetadata headMetadata) {
        BrokerClientProxy brokerClientProxy;
        int endPointClientId = headMetadata.getEndPointClientId();
        if (endPointClientId != 0 && this.boltClientProxyMap.containsKey(endPointClientId) && Objects.nonNull(brokerClientProxy = this.boltClientProxyMap.get(endPointClientId))) {
            return brokerClientProxy;
        }
        if (Objects.isNull(this.elementSelector)) {
            return null;
        }
        return (BrokerClientProxy)this.elementSelector.get();
    }

    @Override
    public void add(BrokerClientProxy brokerClientProxy) {
        int id = brokerClientProxy.getIdHash();
        this.boltClientProxyMap.put(id, brokerClientProxy);
        this.resetSelector();
    }

    @Override
    public void remove(int id) {
        this.boltClientProxyMap.remove(id);
        this.resetSelector();
    }

    @Override
    public String getTag() {
        return this.tag;
    }

    @Override
    public int count() {
        return this.boltClientProxyMap.size();
    }

    private void resetSelector() {
        ArrayList<BrokerClientProxy> list = new ArrayList<BrokerClientProxy>(this.boltClientProxyMap.values());
        this.elementSelector = new RandomElementSelector(list);
    }

    @Override
    public Map<Integer, BrokerClientProxy> getBoltClientProxyMap() {
        return this.boltClientProxyMap;
    }
}

