/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.bolt.broker.server.balanced.region;

import com.alipay.remoting.exception.RemotingException;
import com.alipay.remoting.rpc.RpcServer;
import com.iohao.game.bolt.broker.core.client.BrokerClientType;
import com.iohao.game.bolt.broker.core.common.IoGameGlobalConfig;
import com.iohao.game.bolt.broker.core.message.BrokerClientModuleMessage;
import java.util.List;
import java.util.Objects;

public class BrokerClientProxy {
    final String id;
    final int idHash;
    final String name;
    final String address;
    final String tag;
    final BrokerClientType brokerClientType;
    final RpcServer rpcServer;
    final int withNo;
    int status;
    int timeoutMillis = IoGameGlobalConfig.timeoutMillis;
    List<Integer> cmdMergeList;

    public BrokerClientProxy(BrokerClientModuleMessage brokerClientModuleMessage, RpcServer rpcServer) {
        this.id = brokerClientModuleMessage.getId();
        this.idHash = brokerClientModuleMessage.getIdHash();
        this.name = brokerClientModuleMessage.getName();
        this.address = brokerClientModuleMessage.getAddress();
        this.tag = brokerClientModuleMessage.getTag();
        this.brokerClientType = brokerClientModuleMessage.getBrokerClientType();
        this.cmdMergeList = brokerClientModuleMessage.getCmdMergeList();
        this.rpcServer = rpcServer;
        this.withNo = brokerClientModuleMessage.getWithNo();
        this.status = brokerClientModuleMessage.getStatus();
    }

    public void oneway(Object request) throws RemotingException, InterruptedException {
        this.rpcServer.oneway(this.address, request);
    }

    public <T> T invokeSync(Object message) throws RemotingException, InterruptedException {
        return (T)this.rpcServer.invokeSync(this.address, message, this.timeoutMillis);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BrokerClientProxy)) {
            return false;
        }
        BrokerClientProxy that = (BrokerClientProxy)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String getId() {
        return this.id;
    }

    public int getIdHash() {
        return this.idHash;
    }

    public String getName() {
        return this.name;
    }

    public String getAddress() {
        return this.address;
    }

    public String getTag() {
        return this.tag;
    }

    public BrokerClientType getBrokerClientType() {
        return this.brokerClientType;
    }

    public RpcServer getRpcServer() {
        return this.rpcServer;
    }

    public int getWithNo() {
        return this.withNo;
    }

    public int getStatus() {
        return this.status;
    }

    public int getTimeoutMillis() {
        return this.timeoutMillis;
    }

    public List<Integer> getCmdMergeList() {
        return this.cmdMergeList;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setTimeoutMillis(int timeoutMillis) {
        this.timeoutMillis = timeoutMillis;
    }

    public void setCmdMergeList(List<Integer> cmdMergeList) {
        this.cmdMergeList = cmdMergeList;
    }

    public String toString() {
        return "BrokerClientProxy(id=" + this.getId() + ", idHash=" + this.getIdHash() + ", name=" + this.getName() + ", address=" + this.getAddress() + ", tag=" + this.getTag() + ", brokerClientType=" + this.getBrokerClientType() + ", rpcServer=" + this.getRpcServer() + ", withNo=" + this.getWithNo() + ", status=" + this.getStatus() + ", timeoutMillis=" + this.getTimeoutMillis() + ", cmdMergeList=" + this.getCmdMergeList() + ")";
    }
}

