/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.bolt.broker.server.balanced;

import com.alipay.remoting.rpc.RpcServer;
import com.iohao.game.bolt.broker.core.client.BrokerClientType;
import com.iohao.game.bolt.broker.core.message.BrokerClientModuleMessage;
import com.iohao.game.bolt.broker.server.BrokerServer;
import com.iohao.game.bolt.broker.server.balanced.BrokerClientLoadBalanced;
import com.iohao.game.bolt.broker.server.balanced.ExternalBrokerClientLoadBalanced;
import com.iohao.game.bolt.broker.server.balanced.LogicBrokerClientLoadBalanced;
import com.iohao.game.bolt.broker.server.balanced.region.BrokerClientProxy;
import com.iohao.game.bolt.broker.server.balanced.region.BrokerClientRegion;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jctools.maps.NonBlockingHashMap;

public class BalancedManager {
    private final LogicBrokerClientLoadBalanced logicBalanced = new LogicBrokerClientLoadBalanced();
    private final ExternalBrokerClientLoadBalanced externalLoadBalanced = new ExternalBrokerClientLoadBalanced();
    private final Map<String, BrokerClientProxy> refMap = new NonBlockingHashMap();
    private final BrokerServer brokerServer;

    public BalancedManager(BrokerServer brokerServer) {
        this.brokerServer = brokerServer;
    }

    public BrokerClientLoadBalanced getRegionLoadBalanced(BrokerClientType brokerClientType) {
        if (brokerClientType == BrokerClientType.EXTERNAL) {
            return this.externalLoadBalanced;
        }
        return this.logicBalanced;
    }

    public void register(BrokerClientModuleMessage brokerClientModuleMessage) {
        BrokerClientType brokerClientType = brokerClientModuleMessage.getBrokerClientType();
        BrokerClientLoadBalanced loadBalanced = this.getRegionLoadBalanced(brokerClientType);
        String address = brokerClientModuleMessage.getAddress();
        RpcServer rpcServer = this.brokerServer.getRpcServer();
        BrokerClientProxy brokerClientProxy = new BrokerClientProxy(brokerClientModuleMessage, rpcServer);
        loadBalanced.register(brokerClientProxy);
        brokerClientProxy.setCmdMergeList(null);
        this.refMap.put(address, brokerClientProxy);
    }

    public BrokerClientProxy remove(String address) {
        BrokerClientProxy brokerClientProxy = this.refMap.get(address);
        BrokerClientType brokerClientType = brokerClientProxy.getBrokerClientType();
        BrokerClientLoadBalanced loadBalanced = this.getRegionLoadBalanced(brokerClientType);
        loadBalanced.remove(brokerClientProxy);
        return brokerClientProxy;
    }

    public List<BrokerClientProxy> listBrokerClientProxy() {
        ArrayList<BrokerClientProxy> list = new ArrayList<BrokerClientProxy>(16);
        List<BrokerClientProxy> externalProxyList = this.externalLoadBalanced.listBrokerClientProxy();
        list.addAll(externalProxyList);
        Collection<BrokerClientRegion> brokerClientRegions = this.logicBalanced.listBrokerClientRegion();
        for (BrokerClientRegion brokerClientRegion : brokerClientRegions) {
            Collection<BrokerClientProxy> logicProxyList = brokerClientRegion.listBrokerClientProxy();
            list.addAll(logicProxyList);
        }
        return list;
    }

    public LogicBrokerClientLoadBalanced getLogicBalanced() {
        return this.logicBalanced;
    }

    public ExternalBrokerClientLoadBalanced getExternalLoadBalanced() {
        return this.externalLoadBalanced;
    }
}

