/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.bolt.broker.server;

import com.alipay.remoting.rpc.RpcServer;
import com.iohao.game.action.skeleton.toy.IoGameBanner;
import com.iohao.game.bolt.broker.cluster.BrokerClusterManager;
import com.iohao.game.bolt.broker.cluster.BrokerRunModeEnum;
import com.iohao.game.bolt.broker.core.GroupWith;
import com.iohao.game.bolt.broker.server.BrokerServerBuilder;
import com.iohao.game.bolt.broker.server.balanced.BalancedManager;
import com.iohao.game.bolt.broker.server.service.BrokerClientModules;
import com.iohao.game.common.kit.log.IoGameLoggerFactory;
import com.iohao.game.core.common.cmd.CmdRegions;
import com.iohao.game.core.common.cmd.DefaultCmdRegions;
import org.slf4j.Logger;

public class BrokerServer
implements GroupWith {
    private static final Logger log = IoGameLoggerFactory.getLoggerCommonStdout();
    private final BalancedManager balancedManager = new BalancedManager(this);
    private final CmdRegions cmdRegions = new DefaultCmdRegions();
    private String brokerId;
    private int port;
    private RpcServer rpcServer;
    private BrokerRunModeEnum brokerRunMode;
    private BrokerClusterManager brokerClusterManager;
    private BrokerClientModules brokerClientModules;
    private int withNo;

    BrokerServer() {
    }

    void initRpcServer() {
        this.rpcServer = new RpcServer(this.port, true);
    }

    public void startup() {
        IoGameBanner.me();
        System.setProperty("bolt.rpc.dispatch-msg-list-in-default-executor", "false");
        this.rpcServer.startup();
        log.info("\u542f\u52a8\u6e38\u620f\u7f51\u5173 port: [{}] \u542f\u52a8\u6a21\u5f0f: [{}] ", (Object)this.port, (Object)this.brokerRunMode);
        IoGameBanner.render();
        IoGameBanner.me().countDown();
    }

    public void shutdown() {
        this.rpcServer.shutdown();
    }

    public static BrokerServerBuilder newBuilder() {
        return new BrokerServerBuilder();
    }

    public void setWithNo(int withNo) {
        this.withNo = withNo;
    }

    public BalancedManager getBalancedManager() {
        return this.balancedManager;
    }

    public CmdRegions getCmdRegions() {
        return this.cmdRegions;
    }

    public String getBrokerId() {
        return this.brokerId;
    }

    public int getPort() {
        return this.port;
    }

    public RpcServer getRpcServer() {
        return this.rpcServer;
    }

    public BrokerRunModeEnum getBrokerRunMode() {
        return this.brokerRunMode;
    }

    public BrokerClusterManager getBrokerClusterManager() {
        return this.brokerClusterManager;
    }

    public BrokerClientModules getBrokerClientModules() {
        return this.brokerClientModules;
    }

    public int getWithNo() {
        return this.withNo;
    }

    BrokerServer setBrokerId(String brokerId) {
        this.brokerId = brokerId;
        return this;
    }

    BrokerServer setPort(int port) {
        this.port = port;
        return this;
    }

    BrokerServer setRpcServer(RpcServer rpcServer) {
        this.rpcServer = rpcServer;
        return this;
    }

    BrokerServer setBrokerRunMode(BrokerRunModeEnum brokerRunMode) {
        this.brokerRunMode = brokerRunMode;
        return this;
    }

    BrokerServer setBrokerClusterManager(BrokerClusterManager brokerClusterManager) {
        this.brokerClusterManager = brokerClusterManager;
        return this;
    }

    BrokerServer setBrokerClientModules(BrokerClientModules brokerClientModules) {
        this.brokerClientModules = brokerClientModules;
        return this;
    }
}

