/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.bolt.broker.cluster;

import com.iohao.game.bolt.broker.cluster.Broker;
import com.iohao.game.bolt.broker.cluster.ClusterMessageListener;
import com.iohao.game.bolt.broker.core.message.BrokerClusterMessage;
import com.iohao.game.bolt.broker.core.message.BrokerMessage;
import com.iohao.game.common.kit.log.IoGameLoggerFactory;
import io.scalecube.cluster.Cluster;
import io.scalecube.cluster.ClusterMessageHandler;
import io.scalecube.cluster.Member;
import io.scalecube.cluster.membership.MembershipEvent;
import io.scalecube.cluster.transport.api.Message;
import io.scalecube.net.Address;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jctools.maps.NonBlockingHashMap;
import org.slf4j.Logger;
import reactor.core.publisher.Sinks;

final class BrokerClusterMessageHandler
implements ClusterMessageHandler,
Function<Cluster, ClusterMessageHandler> {
    static final Logger log = IoGameLoggerFactory.getLoggerCluster();
    final String name;
    final Broker localBroker;
    final ClusterMessageListener clusterMessageListener;
    Map<String, Broker> brokers = new NonBlockingHashMap();
    Cluster cluster;
    Sinks.Many<Collection<Broker>> brokersEmitterProcessor = Sinks.many().multicast().onBackpressureBuffer();

    public BrokerClusterMessageHandler(String name, Broker localBroker, ClusterMessageListener clusterMessageListener) {
        this.name = name;
        this.localBroker = localBroker;
        this.clusterMessageListener = clusterMessageListener;
    }

    @Override
    public ClusterMessageHandler apply(Cluster cluster) {
        this.cluster = cluster;
        return this;
    }

    public void onMessage(Message message) {
        log.info("\n{}", (Object)(this.name + " received: " + message.data()));
    }

    public void onGossip(Message gossip) {
        log.info("\n{}", (Object)(this.name + " received: " + gossip.data()));
    }

    public void onMembershipEvent(MembershipEvent event) {
        NonBlockingHashMap brokers = new NonBlockingHashMap();
        this.cluster.members().forEach(arg_0 -> this.lambda$onMembershipEvent$1((Map)brokers, arg_0));
        this.brokers = brokers;
        this.brokersEmitterProcessor.tryEmitNext(this.brokers.values());
        this.inform();
    }

    BrokerClusterMessage getBrokerClusterMessage() {
        List brokerMessageList = this.brokers.values().stream().map(broker -> {
            BrokerMessage item = new BrokerMessage();
            item.setAddress(broker.getBrokerAddress());
            item.setId(broker.getId());
            return item;
        }).collect(Collectors.toList());
        BrokerClusterMessage brokerClusterMessage = new BrokerClusterMessage();
        brokerClusterMessage.setBrokerMessageList(brokerMessageList);
        return brokerClusterMessage;
    }

    private void inform() {
        if (Objects.isNull(this.clusterMessageListener)) {
            return;
        }
        BrokerClusterMessage brokerClusterMessage = this.getBrokerClusterMessage();
        this.clusterMessageListener.inform(brokerClusterMessage);
    }

    private void print(MembershipEvent event) {
        int size = this.cluster.members().size();
        String mStr = this.cluster.members().stream().map(Member::toString).collect(Collectors.joining("\n"));
        log.info("\n{} {}", (Object)(this.name + " received: " + event.member().alias()), (Object)event);
        log.info("size : {} {} \n{}", new Object[]{size, event.type(), mStr});
    }

    private /* synthetic */ void lambda$onMembershipEvent$1(Map brokers, Member member) {
        Optional optional = this.cluster.metadata(member);
        optional.ifPresent(metadata -> {
            Broker memberBroker = metadata.getLocalBroker();
            Address address = member.address();
            Broker theBroker = new Broker(address.host()).setClusterAddress(address.toString()).setId(memberBroker.getId()).setPort(memberBroker.getPort()).setBrokerAddress(memberBroker.getBrokerAddress());
            String clusterAddress = theBroker.getClusterAddress();
            brokers.put(clusterAddress, theBroker);
        });
    }
}

