/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.bolt.broker.cluster;

import com.iohao.game.bolt.broker.cluster.Broker;
import com.iohao.game.bolt.broker.cluster.BrokerClusterMessageHandler;
import com.iohao.game.bolt.broker.cluster.BrokerClusterMetadata;
import com.iohao.game.bolt.broker.cluster.ClusterMessageListener;
import com.iohao.game.bolt.broker.core.message.BrokerClusterMessage;
import com.iohao.game.common.kit.NetworkKit;
import com.iohao.game.common.kit.log.IoGameLoggerFactory;
import io.scalecube.cluster.Cluster;
import io.scalecube.cluster.ClusterImpl;
import io.scalecube.net.Address;
import io.scalecube.transport.netty.tcp.TcpTransportFactory;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.slf4j.Logger;

public final class BrokerClusterManager {
    static final Logger log = IoGameLoggerFactory.getLoggerCluster();
    private String brokerId;
    private int port;
    private int gossipListenPort;
    private List<String> seedAddress;
    private Cluster cluster;
    private ClusterMessageListener clusterMessageListener;
    private String name;
    private BrokerClusterMessageHandler messageHandler;

    BrokerClusterManager() {
    }

    public void start() {
        String localIp = NetworkKit.LOCAL_IP;
        Broker localBroker = this.getLocalBroker(localIp);
        this.name = String.format("ioGameCluster-%d-%d-%s", this.port, this.gossipListenPort, localIp);
        this.messageHandler = new BrokerClusterMessageHandler(this.name, localBroker, this.clusterMessageListener);
        List<Address> seedMemberAddress = this.listSeedMemberAddress();
        this.cluster = new ClusterImpl().config(options -> options.memberAlias(this.name).metadata((Object)new BrokerClusterMetadata(this.name, localBroker)).externalHost(localIp).externalPort(Integer.valueOf(this.gossipListenPort))).membership(membershipConfig -> membershipConfig.seedMembers(seedMemberAddress).syncInterval(5000)).handler((Function)this.messageHandler).transportFactory(TcpTransportFactory::new).transport(transportConfig -> transportConfig.port(this.gossipListenPort)).startAwait();
        Map<String, Broker> brokers = this.messageHandler.brokers;
        brokers.put(localBroker.getClusterAddress(), localBroker);
    }

    public BrokerClusterMessage getBrokerClusterMessage() {
        return this.messageHandler.getBrokerClusterMessage();
    }

    private Broker getLocalBroker(String localIp) {
        String clusterAddress = localIp + ":" + this.gossipListenPort;
        String brokerAddress = localIp + ":" + this.port;
        return new Broker(localIp).setId(this.brokerId).setPort(this.port).setBrokerAddress(brokerAddress).setClusterAddress(clusterAddress);
    }

    private List<Address> listSeedMemberAddress() {
        return this.seedAddress.stream().map(Address::from).toList();
    }

    public String getBrokerId() {
        return this.brokerId;
    }

    public int getPort() {
        return this.port;
    }

    public int getGossipListenPort() {
        return this.gossipListenPort;
    }

    public List<String> getSeedAddress() {
        return this.seedAddress;
    }

    public Cluster getCluster() {
        return this.cluster;
    }

    public ClusterMessageListener getClusterMessageListener() {
        return this.clusterMessageListener;
    }

    public String getName() {
        return this.name;
    }

    public BrokerClusterMessageHandler getMessageHandler() {
        return this.messageHandler;
    }

    public BrokerClusterManager setBrokerId(String brokerId) {
        this.brokerId = brokerId;
        return this;
    }

    public BrokerClusterManager setPort(int port) {
        this.port = port;
        return this;
    }

    public BrokerClusterManager setGossipListenPort(int gossipListenPort) {
        this.gossipListenPort = gossipListenPort;
        return this;
    }

    public BrokerClusterManager setSeedAddress(List<String> seedAddress) {
        this.seedAddress = seedAddress;
        return this;
    }

    public BrokerClusterManager setCluster(Cluster cluster) {
        this.cluster = cluster;
        return this;
    }

    public BrokerClusterManager setClusterMessageListener(ClusterMessageListener clusterMessageListener) {
        this.clusterMessageListener = clusterMessageListener;
        return this;
    }

    public BrokerClusterManager setName(String name) {
        this.name = name;
        return this;
    }

    public BrokerClusterManager setMessageHandler(BrokerClusterMessageHandler messageHandler) {
        this.messageHandler = messageHandler;
        return this;
    }
}

