/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.jwt.rsa;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateFactory;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import sun.security.util.DerInputStream;
import sun.security.util.DerValue;
import sun.security.x509.X509CertImpl;

public class RSAUtils {
    public static String generateJWS_x5t(String algorithm, String encodedCertificate) {
        byte[] bytes = Base64.getDecoder().decode(encodedCertificate.getBytes(Charset.forName("UTF-8")));
        return RSAUtils.digest(algorithm, bytes);
    }

    public static String generateJWS_x5t(String encodedCertificate) {
        return RSAUtils.generateJWS_x5t("SHA-1", encodedCertificate);
    }

    public static String generateJWS_x5t(String algorithm, byte[] derEncodedCertificate) {
        return RSAUtils.digest(algorithm, derEncodedCertificate);
    }

    public static String generateJWS_x5t(byte[] derEncodedCertificate) {
        return RSAUtils.digest("SHA-1", derEncodedCertificate);
    }

    public static String getPEMFromPrivateKey(PrivateKey privateKey) {
        return RSAUtils.getPEMFromKey(privateKey);
    }

    public static String getPEMFromPublicKey(PublicKey publicKey) {
        return RSAUtils.getPEMFromKey(publicKey);
    }

    public static RSAPrivateKey getPrivateKeyFromPEM(String privateKey) {
        try {
            KeySpec keySpec = RSAUtils.getRSAPrivateKeySpec(privateKey);
            return (RSAPrivateKey)KeyFactory.getInstance("RSA").generatePrivate(keySpec);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public static RSAPublicKey getPublicKeyFromPEM(String publicKey) {
        try {
            return RSAUtils.extractPublicKeyFromPEM(publicKey);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    private static String digest(String algorithm, byte[] bytes) {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("No such algorithm [" + algorithm + "]");
        }
        byte[] digest = messageDigest.digest(bytes);
        return new String(Base64.getUrlEncoder().withoutPadding().encode(digest));
    }

    private static RSAPublicKey extractPublicKeyFromPEM(String publicKeyString) throws IOException, GeneralSecurityException {
        if (publicKeyString.contains("-----BEGIN RSA PUBLIC KEY-----")) {
            byte[] bytes = RSAUtils.getKeyBytes(publicKeyString, "-----BEGIN RSA PUBLIC KEY-----", "-----END RSA PUBLIC KEY-----");
            DerInputStream derReader = new DerInputStream(bytes);
            DerValue[] seq = derReader.getSequence(0);
            if (seq.length != 2) {
                throw new GeneralSecurityException("Could not parse a PKCS1 private key.");
            }
            BigInteger modulus = seq[0].getBigInteger();
            BigInteger publicExponent = seq[1].getBigInteger();
            return (RSAPublicKey)KeyFactory.getInstance("RSA").generatePublic(new RSAPublicKeySpec(modulus, publicExponent));
        }
        if (publicKeyString.contains("-----BEGIN PUBLIC KEY-----")) {
            byte[] bytes = RSAUtils.getKeyBytes(publicKeyString, "-----BEGIN PUBLIC KEY-----", "-----END PUBLIC KEY-----");
            return (RSAPublicKey)KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(bytes));
        }
        if (publicKeyString.contains("-----BEGIN CERTIFICATE-----")) {
            byte[] bytes = RSAUtils.getKeyBytes(publicKeyString, "-----BEGIN CERTIFICATE-----", "-----END CERTIFICATE-----");
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            X509CertImpl certificate = (X509CertImpl)factory.generateCertificate(new ByteArrayInputStream(bytes));
            return (RSAPublicKey)certificate.getPublicKey();
        }
        throw new InvalidParameterException("Unexpected Public Key Format");
    }

    private static byte[] getKeyBytes(String key, String keyPrefix, String keySuffix) {
        int startIndex = key.indexOf(keyPrefix);
        int endIndex = key.indexOf(keySuffix);
        String base64 = key.substring(startIndex + keyPrefix.length(), endIndex).replaceAll("\\s", "");
        return Base64.getDecoder().decode(base64);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getPEMFromKey(Key key) {
        StringBuilder sb = new StringBuilder();
        if (key instanceof PrivateKey) {
            if (key.getFormat().equals("PKCS#1")) {
                sb.append("-----BEGIN RSA PRIVATE KEY-----").append("\n");
            } else {
                if (!key.getFormat().equals("PKCS#8")) throw new InvalidParameterException("Unexpected Private Key Format");
                sb.append("-----BEGIN PRIVATE KEY-----").append("\n");
            }
        } else {
            sb.append("-----BEGIN PUBLIC KEY-----").append("\n");
        }
        String encoded = new String(Base64.getEncoder().encode(key.getEncoded()));
        int lineLength = 65;
        for (int index = 0; index < encoded.length(); index += lineLength) {
            sb.append(encoded, index, Math.min(index + lineLength, encoded.length())).append("\n");
        }
        if (key instanceof PrivateKey) {
            if (key.getFormat().equals("PKCS#1")) {
                sb.append("-----END RSA PRIVATE KEY-----").append("\n");
                return sb.toString();
            } else {
                if (!key.getFormat().equals("PKCS#8")) return sb.toString();
                sb.append("-----END PRIVATE KEY-----").append("\n");
            }
            return sb.toString();
        } else {
            sb.append("-----END PUBLIC KEY-----").append("\n");
        }
        return sb.toString();
    }

    private static KeySpec getRSAPrivateKeySpec(String privateKey) throws IOException, GeneralSecurityException {
        if (privateKey.contains("-----BEGIN RSA PRIVATE KEY-----")) {
            byte[] bytes = RSAUtils.getKeyBytes(privateKey, "-----BEGIN RSA PRIVATE KEY-----", "-----END RSA PRIVATE KEY-----");
            DerInputStream derReader = new DerInputStream(bytes);
            DerValue[] seq = derReader.getSequence(0);
            if (seq.length < 9) {
                throw new GeneralSecurityException("Could not parse a PKCS1 private key.");
            }
            BigInteger modulus = seq[1].getBigInteger();
            BigInteger publicExponent = seq[2].getBigInteger();
            BigInteger privateExponent = seq[3].getBigInteger();
            BigInteger primeP = seq[4].getBigInteger();
            BigInteger primeQ = seq[5].getBigInteger();
            BigInteger primeExponentP = seq[6].getBigInteger();
            BigInteger primeExponentQ = seq[7].getBigInteger();
            BigInteger crtCoefficient = seq[8].getBigInteger();
            return new RSAPrivateCrtKeySpec(modulus, publicExponent, privateExponent, primeP, primeQ, primeExponentP, primeExponentQ, crtCoefficient);
        }
        if (privateKey.contains("-----BEGIN PRIVATE KEY-----")) {
            byte[] bytes = RSAUtils.getKeyBytes(privateKey, "-----BEGIN PRIVATE KEY-----", "-----END PRIVATE KEY-----");
            return new PKCS8EncodedKeySpec(bytes);
        }
        throw new InvalidParameterException("Unexpected Private Key Format");
    }
}

