/*
 * Decompiled with CFR 0.152.
 */
package com.ucloud.paas.proxy.aaaa;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ucloud.paas.agent.PaasException;
import com.ucloud.paas.proxy.CallResult;
import com.ucloud.paas.proxy.HttpMethod;
import com.ucloud.paas.proxy.TechServiceProxy;
import com.ucloud.paas.proxy.aaaa.entity.AAAAResult;
import com.ucloud.paas.proxy.aaaa.util.JSONUtil;
import com.ucloud.paas.proxy.aaaa.util.PaasAAAAException;
import com.ucloud.paas.proxy.common.Pagination;
import com.ucloud.paas.proxy.common.SortDirectionEnum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceContextImpl
extends TechServiceProxy {
    private static final Logger log = LoggerFactory.getLogger(ServiceContextImpl.class);
    private HashMap<String, String> formParams = new HashMap();
    private static final String PAGE_NUM = "pageNum";
    private static final String PAGE_SIZE = "pageSize";
    private static final String SORT_COLUMN = "sortColumn";
    private static final String SORT_DIRECTION = "sortDirection";
    private static final String ErrorMessagePrefix = "ErrorMessage:";
    private static final String HTTP_JSON_TYPE = "application/json;charset=UTF-8";

    public ServiceContextImpl put(String key, String value) {
        if (value != null && !"".equals(value.trim())) {
            this.formParams.put(key, value);
        }
        return this;
    }

    public ServiceContextImpl put(String key, Integer value) {
        if (value != null) {
            this.formParams.put(key, String.valueOf(value));
        }
        return this;
    }

    public ServiceContextImpl putAsJsonString(String key, Object obj) {
        if (obj != null) {
            this.formParams.put(key, JSONObject.toJSONString((Object)obj));
        }
        return this;
    }

    public ServiceContextImpl putParams(Map<String, String> params) throws PaasException {
        for (String key : params.keySet()) {
            String value = params.get(key);
            if (value == null || !"".equals(value.trim())) {
                throw new PaasException("Invalid params value. params[" + key + "] is null or blank.");
            }
            if (key.equals(PAGE_NUM)) {
                this.putPageNum(Integer.valueOf(value));
                continue;
            }
            if (key.equals(PAGE_SIZE)) {
                this.putPageSize(Integer.valueOf(value));
                continue;
            }
            if (key.equals(SORT_COLUMN)) {
                this.putSortColumn(value);
                continue;
            }
            if (key.equals(SORT_DIRECTION)) {
                this.putSortDirection(SortDirectionEnum.getSortDirection(value));
                continue;
            }
            this.formParams.put(key, value);
        }
        return this;
    }

    public ServiceContextImpl putPageNum(int pageNum) {
        this.put(PAGE_NUM, String.valueOf(pageNum));
        return this;
    }

    public ServiceContextImpl putPageSize(int pageSize) {
        this.put(PAGE_SIZE, String.valueOf(pageSize));
        return this;
    }

    public ServiceContextImpl putSortColumn(String sortColumn) {
        if (sortColumn != null && !"".equals(sortColumn.trim())) {
            this.put(SORT_COLUMN, sortColumn);
        }
        return this;
    }

    public ServiceContextImpl putSortDirection(SortDirectionEnum sortDirection) {
        if (sortDirection != null) {
            this.put(SORT_DIRECTION, sortDirection.getDirection());
        }
        return this;
    }

    public CallResultInfo executeGet(String service, String serverName, String methodName, Object[] pathParams) throws PaasException {
        try {
            StringBuilder path = new StringBuilder();
            for (Object param : pathParams) {
                if (path.length() > 0) {
                    path.append("/");
                }
                path.append(param);
            }
            String subURI = serverName + methodName + "/" + path.toString();
            CallResult result = ServiceContextImpl.call(service, subURI, HttpMethod.GET, HTTP_JSON_TYPE);
            return new CallResultInfo(service, subURI, result);
        }
        catch (Exception e) {
            log.error("Call AAAA servcie method: " + methodName + " failed!");
            throw new PaasException(e.getMessage());
        }
    }

    public CallResultInfo executePost(String service, String serverName, String methodName) throws PaasException {
        String subURI = serverName + methodName + "/";
        try {
            CallResult result = ServiceContextImpl.call(service, subURI, HttpMethod.POST, null, this.formParams);
            return new CallResultInfo(service, subURI, result);
        }
        catch (Exception e) {
            log.error("Call AAAA servcie method: " + methodName + " failed!");
            throw new PaasException(e.getMessage());
        }
    }

    class CallResultInfo {
        private CallResult result;
        private String service;
        private String subURI;

        public CallResultInfo(String service, String subURI, CallResult result) {
            this.result = result;
            this.service = service;
            this.subURI = subURI;
        }

        public void checkResult() throws PaasException {
            log.info(this.service + this.subURI + "CallResult:" + JSONObject.toJSONString((Object)this.result));
            if (this.result != null && this.result.getBody() != null && this.result.getBody().startsWith(ServiceContextImpl.ErrorMessagePrefix)) {
                throw new PaasException(this.result.getBody().substring(ServiceContextImpl.ErrorMessagePrefix.length()));
            }
            if (this.result != null && 200 == this.result.getStatus()) {
                log.info("Call :" + this.service + this.subURI + " successful!");
            } else {
                log.error("Call : " + this.service + this.subURI + " failed! \n" + this.result.getBody());
            }
        }

        public AAAAResult toAAAAResult() {
            AAAAResult res = new AAAAResult();
            try {
                this.checkResult();
                String resultStr = this.result.getBody();
                if (this.result != null && 200 == this.result.getStatus()) {
                    res.setResult(true);
                    res.setCode(resultStr);
                    res.setMessage("The service call is successful");
                } else if (this.result != null) {
                    res.setResult(false);
                    res.setCode(String.valueOf(this.result.getStatus()));
                    res.setMessage("The service call is failed!");
                } else {
                    res.setCode("Null");
                    res.setResult(true);
                    res.setMessage("");
                }
            }
            catch (PaasException e) {
                res.setCode("Null");
                res.setMessage(e.getMessage());
                res.setResult(false);
            }
            return res;
        }

        public <T> List<T> toList(Class<T> objectClass) throws PaasAAAAException, PaasException {
            this.checkResult();
            ArrayList lst = new ArrayList();
            if (200 == this.result.getStatus()) {
                List res = JSONUtil.getList4Json(this.result.getBody(), objectClass);
                if (res != null) {
                    return res;
                }
            } else {
                throw new PaasAAAAException("The service call is failed! \n" + this.result.getBody());
            }
            ServiceContextImpl.this.formParams.clear();
            return lst;
        }

        public <T> List<Object[]> toObjectList(Class<T> objectClass) throws PaasAAAAException, PaasException {
            this.checkResult();
            ArrayList<Object[]> obj = new ArrayList<Object[]>();
            if (200 == this.result.getStatus()) {
                if (!"[]".equals(this.result.getBody())) {
                    String[] resu = this.result.getBody().split("]");
                    for (int i = 0; i < resu.length; ++i) {
                        int j = 0;
                        String[] temp1 = resu[i].split("}}");
                        if (j >= temp1.length) continue;
                        String temp2 = temp1[j].substring(1) + "}}]";
                        List res = JSONUtil.getList4Json(temp2, objectClass);
                        Object[] objects = new Object[]{res.get(0), temp1[j + 1].substring(2).split("\"")[0]};
                        obj.add(objects);
                    }
                }
            } else {
                throw new PaasAAAAException("The service call is failed! \n" + this.result.getBody());
            }
            ServiceContextImpl.this.formParams.clear();
            return obj;
        }

        public <T> Object toEntity(Class<T> entityClass) throws PaasAAAAException, PaasException {
            this.checkResult();
            Object entity = null;
            if (200 != this.result.getStatus()) {
                throw new PaasAAAAException("The service call is failed! \n" + this.result.getBody());
            }
            JSONObject json = JSONObject.parseObject((String)this.result.getBody());
            entity = JSONObject.toJavaObject((JSON)json, entityClass);
            ServiceContextImpl.this.formParams.clear();
            return entity;
        }

        public <T> Pagination toPagination(Class<T> entityClass) throws PaasAAAAException, PaasException {
            this.checkResult();
            Pagination pagination = null;
            if (200 == this.result.getStatus()) {
                new JSONObject();
                JSONObject obj = JSONObject.parseObject((String)this.result.getBody());
                pagination = (Pagination)JSONObject.toJavaObject((JSON)obj, Pagination.class);
                if (pagination == null) {
                    return null;
                }
                List<?> rawList = pagination.getResult();
                ArrayList<Object> entityList = new ArrayList<Object>();
                for (Object object : rawList) {
                    JSONObject json = JSONObject.parseObject((String)object.toString());
                    entityList.add(JSONObject.toJavaObject((JSON)json, entityClass));
                }
                pagination.setResult(entityList);
                ServiceContextImpl.this.formParams.clear();
                return pagination;
            }
            throw new PaasAAAAException("The service call is failed! \n" + this.result.getBody());
        }
    }
}

