/*
 * Decompiled with CFR 0.152.
 */
package com.ucloud.paas.proxy.aaaa;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ucloud.paas.proxy.CallResult;
import com.ucloud.paas.proxy.HttpMethod;
import com.ucloud.paas.proxy.TechServiceProxy;
import com.ucloud.paas.proxy.aaaa.entity.LogPlatformOper;
import com.ucloud.paas.proxy.aaaa.entity.OrgEntity;
import com.ucloud.paas.proxy.aaaa.entity.OrgUserTrees;
import com.ucloud.paas.proxy.aaaa.entity.StaffQo;
import com.ucloud.paas.proxy.aaaa.entity.SysFunction;
import com.ucloud.paas.proxy.aaaa.entity.SysGroup;
import com.ucloud.paas.proxy.aaaa.entity.SysOrg;
import com.ucloud.paas.proxy.aaaa.entity.SysProcessWorkHan;
import com.ucloud.paas.proxy.aaaa.entity.SysRegion;
import com.ucloud.paas.proxy.aaaa.entity.SysRole;
import com.ucloud.paas.proxy.aaaa.entity.TeamGroupVo;
import com.ucloud.paas.proxy.aaaa.entity.TokenResponse;
import com.ucloud.paas.proxy.aaaa.entity.UserEntity;
import com.ucloud.paas.proxy.aaaa.util.JSONUtil;
import com.ucloud.paas.proxy.aaaa.util.PaasAAAAException;
import com.ucloud.paas.proxy.common.Pager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AAAAService
extends TechServiceProxy {
    private static final Logger log = LoggerFactory.getLogger(AAAAService.class);
    protected String appID = "1";
    protected String appAccountID = "1";
    protected static final String HTTP_JSON_TYPE = "application/json;charset=UTF-8";
    protected static final String CALL_SUCCESS = "call AAAAService method successful,name:{}";
    protected static final String CALL_FAILED = "call AAAAService method failure,name:{}";
    protected final String AAAA = "auth-external-microservice";
    protected final String SERVICE_PMS = "service-pms";
    protected final String POWERSERVICE = "/v1/power/";
    protected final String ACCOUNTSERVICE = "/v1/account/";
    protected final String GROUPSERVICE = "/v1/group/";
    protected final String ORGSERVICE = "/v1/org/";
    protected final String PUBLICSERVICE = "/v1/public/";
    protected final String ROLESERVICE = "/v1/role/";
    protected final String USERERVICE = "/v1/user/";
    protected final String WORKSERVICE = "/v1/workhand/";
    protected final String LOGPLATFORMERVICE = "/v1/logplatformoper/";

    public abstract String getAuthorization();

    protected <T> Object findEntityByID(String serviceName, String methodName, String name, String id, Class<T> objectClass) throws PaasAAAAException {
        if (id == null) {
            log.info("call AAAAService Method " + methodName.substring(methodName.lastIndexOf("/") + 1) + " exception, can not negative number or 0, id:{" + id + "}");
            throw new PaasAAAAException("call AAAAService Method " + methodName.substring(methodName.lastIndexOf("/") + 1) + " exception, input parameter cannot be null ");
        }
        Object entity = null;
        try {
            String subURI = methodName;
            HashMap<String, String> formParams = new HashMap<String, String>();
            formParams.put(name, id);
            super.getClass();
            CallResult result = AAAAService.call(serviceName, subURI, HttpMethod.POST, null, formParams);
            String resultStr = result.getBody();
            if (200 == result.getStatus() && resultStr != null && !"null".equals(resultStr)) {
                JSONObject obj = JSONObject.parseObject((String)resultStr);
                entity = JSONObject.parseObject((String)obj.toJSONString(), objectClass);
            }
            log.info("call AAAAService method successful,name:{" + methodName.substring(methodName.lastIndexOf("/") + 1) + "}");
        }
        catch (Exception e) {
            log.error("call AAAAService method failure,name:{" + methodName.substring(methodName.lastIndexOf("/") + 1) + "}");
            throw new PaasAAAAException(e);
        }
        return entity;
    }

    protected void findEntityByID(String serviceName, String methodName, String name, String id) throws PaasAAAAException {
        if (id == null) {
            log.info("call AAAAService Method " + methodName.substring(methodName.lastIndexOf("/") + 1) + " exception, can not negative number or 0, id:{" + id + "}");
            throw new PaasAAAAException("call AAAAService Method " + methodName.substring(methodName.lastIndexOf("/") + 1) + " exception, input parameter cannot be null ");
        }
        try {
            String subURI = methodName;
            HashMap<String, String> formParams = new HashMap<String, String>();
            formParams.put(name, id);
            super.getClass();
            AAAAService.call(serviceName, subURI, HttpMethod.POST, null, formParams);
            log.info("call AAAAService method successful,name:{" + methodName.substring(methodName.lastIndexOf("/") + 1) + "}");
        }
        catch (Exception e) {
            log.error("call AAAAService method failure,name:{" + methodName.substring(methodName.lastIndexOf("/") + 1) + "}");
            throw new PaasAAAAException(e);
        }
    }

    protected <T> List<T> findListByID(String serviceName, String methodName, String name, String id, Class<T> objectClass) throws PaasAAAAException {
        if (id == null) {
            log.info("call AAAAService Method " + methodName.substring(methodName.lastIndexOf("/") + 1) + " exception, can not negative number or 0, id:{" + id + "}");
            throw new PaasAAAAException("call AAAAService Method " + methodName.substring(methodName.lastIndexOf("/") + 1) + " exception, input parameter cannot be null ");
        }
        List entity = null;
        try {
            String subURI = methodName;
            HashMap<String, String> formParams = new HashMap<String, String>();
            formParams.put(name, id);
            super.getClass();
            CallResult result = AAAAService.call(serviceName, subURI, HttpMethod.POST, null, formParams);
            String resultStr = result.getBody();
            if (200 == result.getStatus() && resultStr != null && !"null".equals(resultStr)) {
                entity = JSONUtil.getList4Json(resultStr, objectClass);
            }
            log.info("call AAAAService method successful,name:{" + methodName.substring(methodName.lastIndexOf("/") + 1) + "}");
        }
        catch (Exception e) {
            log.error("call AAAAService method failure,name:{" + methodName.substring(methodName.lastIndexOf("/") + 1) + "}");
            throw new PaasAAAAException(e);
        }
        return entity;
    }

    protected <T> Object findEntityBySingleParamGetObj(String serviceName, String methodName, HashMap<String, String> formParams, HashMap<String, String> headerParams, Class<T> objectClass, String contentType) throws PaasAAAAException {
        Object entity = null;
        try {
            String subURI = methodName;
            super.getClass();
            CallResult result = contentType == null ? AAAAService.call(serviceName, subURI, HttpMethod.POST, headerParams, formParams) : AAAAService.callContent(serviceName, subURI, HttpMethod.POST, headerParams, formParams, contentType);
            String resultStr = result.getBody();
            if (200 == result.getStatus() && resultStr != null && !"null".equals(resultStr)) {
                JSONObject json = JSONObject.parseObject((String)resultStr);
                entity = JSONObject.parseObject((String)json.toJSONString(), objectClass);
            }
            log.info("call AAAAService method successful,name:{" + methodName + "}");
        }
        catch (Exception e) {
            log.info("call AAAAService method successful,name:{" + methodName + "}");
            throw new PaasAAAAException(e);
        }
        return entity;
    }

    protected <T> List<T> findListBySingleParam(String serviceName, String methodName, HashMap<String, String> formParams, HashMap<String, String> headerParams, Class<T> objectClass) throws PaasAAAAException {
        List list = null;
        try {
            String subURI = methodName;
            super.getClass();
            CallResult result = AAAAService.call(serviceName, subURI, HttpMethod.POST, headerParams, formParams);
            String resultStr = result.getBody();
            log.info("call AAAAService method successful,name:{" + methodName.substring(methodName.lastIndexOf("/") + 1) + "}");
            if (200 != result.getStatus() || resultStr == null || "null".equals(resultStr)) {
                log.error("call AAAAService method failure,name:{" + methodName + "}");
                throw new PaasAAAAException(result.getBody());
            }
            list = JSONUtil.getList4Json(resultStr, objectClass);
        }
        catch (Exception e) {
            log.error("call AAAAService method failure,name:{" + methodName + "}");
            throw new PaasAAAAException(e);
        }
        return list;
    }

    protected <T> List<T> findListBySingleParam(String serviceName, String methodName, HashMap<String, String> formParams, HashMap<String, String> headerParams, Class<T> objectClass, String contentType) throws PaasAAAAException {
        List list = null;
        try {
            String subURI = methodName;
            super.getClass();
            CallResult result = AAAAService.callContent(serviceName, subURI, HttpMethod.POST, headerParams, formParams, contentType);
            String resultStr = result.getBody();
            log.info("call AAAAService method successful,name:{" + methodName.substring(methodName.lastIndexOf("/") + 1) + "}");
            if (200 == result.getStatus() && resultStr != null && !"null".equals(resultStr)) {
                if (String.class.equals(objectClass)) {
                    ArrayList<String> resultList = new ArrayList<String>();
                    JSONArray jsonArray = (JSONArray)JSON.parse((String)resultStr);
                    if (jsonArray != null && jsonArray.size() > 0) {
                        for (int i = 0; i < jsonArray.size(); ++i) {
                            resultList.add(jsonArray.getString(i));
                        }
                    }
                    return resultList;
                }
            } else {
                log.error("call AAAAService method failure,name:{" + methodName + "}");
                throw new PaasAAAAException(result.getBody());
            }
            list = JSONUtil.getList4Json(resultStr, objectClass);
        }
        catch (Exception e) {
            log.error("call AAAAService method failure,name:{" + methodName + "}");
            throw new PaasAAAAException(e);
        }
        return list;
    }

    protected String findEntityBySingleParam(String serviceName, String methodName, HashMap<String, String> formParams, HashMap<String, String> headerParams) throws PaasAAAAException {
        Object entity = null;
        try {
            String subURI = methodName;
            super.getClass();
            CallResult result = AAAAService.call(serviceName, subURI, HttpMethod.POST, headerParams, formParams);
            log.info("call AAAAService method successful,name:{" + methodName.substring(methodName.lastIndexOf("/") + 1) + "}");
            return result.getBody();
        }
        catch (Exception e) {
            log.error("call AAAAService method failure,name:{" + methodName.substring(methodName.lastIndexOf("/") + 1) + "}");
            throw new PaasAAAAException(e);
        }
    }

    protected String findEntityBySingleParam(String serviceName, String methodName, HashMap<String, String> formParams, HashMap<String, String> headerParams, String contentType) throws PaasAAAAException {
        Object entity = null;
        try {
            String subURI = methodName;
            super.getClass();
            CallResult result = AAAAService.callContent(serviceName, subURI, HttpMethod.POST, headerParams, formParams, contentType);
            log.info("call AAAAService method successful,name:{" + methodName.substring(methodName.lastIndexOf("/") + 1) + "}");
            return result.getBody();
        }
        catch (Exception e) {
            log.error("call AAAAService method failure,name:{" + methodName.substring(methodName.lastIndexOf("/") + 1) + "}");
            throw new PaasAAAAException(e);
        }
    }

    protected Pager findListBySingleParamForPager(String serviceName, String methodName, HashMap<String, String> formParams) throws PaasAAAAException {
        if (formParams == null || formParams.size() == 0) {
            String error = "call AAAAService Method " + methodName.substring(methodName.lastIndexOf("/") + 1) + " exception, formParams cannot be null or emoty";
            log.debug(error);
            throw new PaasAAAAException(error);
        }
        Pager pager = new Pager();
        try {
            String subURI = methodName;
            super.getClass();
            CallResult result = AAAAService.call(serviceName, subURI, HttpMethod.POST, null, formParams);
            String resultStr = result.getBody();
            log.info("call AAAAService method successful,name:{" + methodName.substring(methodName.lastIndexOf("/") + 1) + "}");
            if (200 != result.getStatus() || resultStr == null || "null".equals(resultStr)) {
                log.error("call AAAAService method failure,name:{" + methodName.substring(methodName.lastIndexOf("/") + 1) + "}");
                throw new PaasAAAAException(result.getBody());
            }
            pager = (Pager)JSON.parseObject((String)resultStr, Pager.class);
        }
        catch (Exception e) {
            log.error("call AAAAService method failure,name:{" + methodName.substring(methodName.lastIndexOf("/") + 1) + "}");
            throw new PaasAAAAException(e);
        }
        return pager;
    }

    protected Pager findListBySingleParamForPager(String serviceName, String methodName, HashMap<String, String> formParams, HashMap<String, String> headerParams, String contentType) throws PaasAAAAException {
        if (formParams == null || formParams.size() == 0) {
            String error = "call AAAAService Method " + methodName.substring(methodName.lastIndexOf("/") + 1) + " exception, formParams cannot be null or emoty";
            log.debug(error);
            throw new PaasAAAAException(error);
        }
        Pager pager = new Pager();
        try {
            String subURI = methodName;
            super.getClass();
            CallResult result = AAAAService.callContent(serviceName, subURI, HttpMethod.POST, headerParams, formParams, contentType);
            String resultStr = result.getBody();
            log.info("call AAAAService method successful,name:{" + methodName.substring(methodName.lastIndexOf("/") + 1) + "}");
            if (200 != result.getStatus() || resultStr == null || "null".equals(resultStr)) {
                log.error("call AAAAService method failure,name:{" + methodName.substring(methodName.lastIndexOf("/") + 1) + "}");
                throw new PaasAAAAException(result.getBody());
            }
            JSONObject jsonObject = JSON.parseObject((String)resultStr);
            pager.setIsSuccess(true);
            pager.setPageSize(Integer.valueOf(jsonObject.get((Object)"size").toString()));
            pager.setNowPage(Integer.valueOf(jsonObject.get((Object)"current").toString()));
            pager.setPageCount(Integer.valueOf(jsonObject.get((Object)"total").toString()));
            List list = JSONUtil.getList4Json(jsonObject.get((Object)"records").toString(), Object.class);
            pager.setExhibitDatas(list);
        }
        catch (Exception e) {
            log.error("call AAAAService method failure,name:{" + methodName.substring(methodName.lastIndexOf("/") + 1) + "}");
            throw new PaasAAAAException(e);
        }
        return pager;
    }

    public String findNextParticipant(Map<String, Object> map) throws PaasAAAAException {
        HashMap<String, String> formParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        headerParams.put("Authorization", this.getAuthorization());
        for (String key : map.keySet()) {
            formParams.put(key, map.get(key).toString());
        }
        String sting = this.findEntityBySingleParam("auth-external-microservice", "/v1/power/anon/findNextParticipant", formParams, headerParams, "application/json;charset=utf-8");
        return sting;
    }

    public List<SysFunction> listFuns() throws PaasAAAAException {
        HashMap<String, String> formParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        headerParams.put("Authorization", this.getAuthorization());
        return this.findListBySingleParam("auth-external-microservice", "/v1/account/listFuns", formParams, headerParams, SysFunction.class);
    }

    public String getUserInfo() throws PaasAAAAException {
        HashMap data = new HashMap();
        HashMap<String, String> formParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        headerParams.put("Authorization", this.getAuthorization());
        return this.findEntityBySingleParam("auth-external-microservice", "/v1/account/info", formParams, headerParams);
    }

    public List<SysGroup> listGroups() throws PaasAAAAException {
        HashMap<String, String> formParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        headerParams.put("Authorization", this.getAuthorization());
        return this.findListBySingleParam("auth-external-microservice", "/v1/group/list", formParams, headerParams, SysGroup.class);
    }

    public List<SysGroup> listGroups(String groupName) throws PaasAAAAException {
        HashMap<String, String> formParams = new HashMap<String, String>();
        formParams.put("groupName", groupName);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        headerParams.put("Authorization", this.getAuthorization());
        return this.findListBySingleParam("auth-external-microservice", "/v1/group/listGroups", formParams, headerParams, SysGroup.class, "application/x-www-form-urlencoded");
    }

    public List<Map> listUserListByGroup(String groupId) throws PaasAAAAException {
        HashMap<String, String> formParams = new HashMap<String, String>();
        formParams.put("groupId", groupId);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        headerParams.put("Authorization", this.getAuthorization());
        return this.findListBySingleParam("auth-external-microservice", "/v1/group/listUserListByGroup", formParams, headerParams, Map.class, "application/x-www-form-urlencoded");
    }

    public List<SysOrg> getOrgTree(String companyId, String orgCode, String type) throws PaasAAAAException {
        HashMap<String, String> formParams = new HashMap<String, String>();
        formParams.put("companyId", companyId);
        formParams.put("orgCode", orgCode);
        formParams.put("type", type);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        headerParams.put("Authorization", this.getAuthorization());
        return this.findListBySingleParam("auth-external-microservice", "/v1/org/tree", formParams, headerParams, SysOrg.class);
    }

    public List<StaffQo> staffTree(String companyId, String orgCode, String type) throws PaasAAAAException {
        HashMap<String, String> formParams = new HashMap<String, String>();
        formParams.put("companyId", companyId);
        formParams.put("orgCode", orgCode);
        formParams.put("type", type);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        headerParams.put("Authorization", this.getAuthorization());
        return this.findListBySingleParam("auth-external-microservice", "/v1/org/staff", formParams, headerParams, StaffQo.class);
    }

    public List<OrgUserTrees> lazeOrgUserTree(String orgId, String userId) throws PaasAAAAException {
        HashMap<String, String> formParams = new HashMap<String, String>();
        formParams.put("orgId", orgId);
        formParams.put("userId", userId);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        headerParams.put("Authorization", this.getAuthorization());
        return this.findListBySingleParam("auth-external-microservice", "/v1/org/orgUserTree", formParams, headerParams, OrgUserTrees.class, "application/x-www-form-urlencoded");
    }

    public UserEntity getUserById(String userId) throws PaasAAAAException {
        HashMap<String, String> formParams = new HashMap<String, String>();
        formParams.put("userId", userId);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        headerParams.put("Authorization", this.getAuthorization());
        UserEntity userEntity = (UserEntity)this.findEntityBySingleParamGetObj("auth-external-microservice", "/v1/user/getUserById", formParams, headerParams, UserEntity.class, "application/x-www-form-urlencoded");
        return userEntity;
    }

    public String login(String username, String appCode, String password) throws PaasAAAAException {
        HashMap<String, String> formParams = new HashMap<String, String>();
        formParams.put("username", username);
        formParams.put("appCode", appCode);
        formParams.put("password", password);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        return this.findEntityBySingleParam("auth-external-microservice", "/v1/public/anon/login", formParams, headerParams, "application/json;charset=utf-8");
    }

    public String logout() throws PaasAAAAException {
        HashMap<String, String> formParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        headerParams.put("Authorization", this.getAuthorization());
        return this.findEntityBySingleParam("auth-external-microservice", "/v1/public/logout", formParams, headerParams);
    }

    public String renewal() throws PaasAAAAException {
        HashMap<String, String> formParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        headerParams.put("Authorization", this.getAuthorization());
        return this.findEntityBySingleParam("auth-external-microservice", "/v1/public/renewal", formParams, headerParams);
    }

    public List<SysRole> listRoles() throws PaasAAAAException {
        HashMap<String, String> formParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        headerParams.put("Authorization", this.getAuthorization());
        return this.findListBySingleParam("auth-external-microservice", "/v1/role/listRoles", formParams, headerParams, SysRole.class);
    }

    public List<OrgEntity> ListOrg(String orgName) throws PaasAAAAException {
        HashMap<String, String> formParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        headerParams.put("Authorization", this.getAuthorization());
        formParams.put("displayName", orgName);
        return this.findListBySingleParam("auth-external-microservice", "/v1/org/findByOrgList", formParams, headerParams, OrgEntity.class, "application/json;charset=utf-8");
    }

    public OrgEntity getOrg(String orgCode) throws PaasAAAAException {
        HashMap<String, String> formParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        headerParams.put("Authorization", this.getAuthorization());
        formParams.put("orgCode", orgCode);
        OrgEntity orgEntity = (OrgEntity)this.findEntityBySingleParamGetObj("auth-external-microservice", "/v1/org/findByOrgId", formParams, headerParams, OrgEntity.class, null);
        return orgEntity;
    }

    public List<UserEntity> ListUser(String cn, String email, String mobile) throws PaasAAAAException {
        HashMap<String, String> formParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        headerParams.put("Authorization", this.getAuthorization());
        formParams.put("cn", cn);
        formParams.put("email", email);
        formParams.put("mobile", mobile);
        return this.findListBySingleParam("auth-external-microservice", "/v1/user/page", formParams, headerParams, UserEntity.class, "application/json;charset=utf-8");
    }

    public UserEntity getUser(String loginName) throws PaasAAAAException {
        HashMap<String, String> formParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        headerParams.put("Authorization", this.getAuthorization());
        formParams.put("loginName", loginName);
        UserEntity userEntity = (UserEntity)this.findEntityBySingleParamGetObj("auth-external-microservice", "/v1/user/getaccountbyuser", formParams, headerParams, UserEntity.class, "application/json;charset=utf-8");
        return userEntity;
    }

    public UserEntity getUser(String loginName, String appId) throws PaasAAAAException {
        HashMap<String, String> formParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        formParams.put("appId", appId);
        formParams.put("loginName", loginName);
        UserEntity userEntity = (UserEntity)this.findEntityBySingleParamGetObj("auth-external-microservice", "/v1/user/anon/getUserByUserName", formParams, headerParams, UserEntity.class, "application/json;charset=utf-8");
        return userEntity;
    }

    public UserEntity getUser() throws PaasAAAAException {
        HashMap<String, String> headerParams = new HashMap<String, String>();
        headerParams.put("Authorization", this.getAuthorization());
        UserEntity userEntity = (UserEntity)this.findEntityBySingleParamGetObj("auth-external-microservice", "/v1/user/getcurrentuser", null, headerParams, UserEntity.class, "application/json;charset=utf-8");
        return userEntity;
    }

    public Pager operLogPage(Map<String, Object> map) throws PaasAAAAException {
        HashMap<String, String> formParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        headerParams.put("Authorization", this.getAuthorization());
        for (String key : map.keySet()) {
            formParams.put(key, map.get(key).toString());
        }
        Pager pager = this.findListBySingleParamForPager("auth-external-microservice", "/v1/logplatformoper/paging", formParams, headerParams, "application/json;charset=utf-8");
        return pager;
    }

    public String saveLogPlatformOper(LogPlatformOper logPlatformOper) throws PaasAAAAException {
        HashMap formParams = new HashMap();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        formParams = (HashMap)JSON.parseObject((String)JSONObject.toJSONString((Object)logPlatformOper), HashMap.class);
        String sting = this.findEntityBySingleParam("auth-external-microservice", "/v1/logplatformoper/anon/save", formParams, headerParams, "application/json;charset=utf-8");
        return sting;
    }

    public List<SysProcessWorkHan> listWorkHandOver() throws PaasAAAAException {
        HashMap<String, String> formParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        headerParams.put("Authorization", this.getAuthorization());
        return this.findListBySingleParam("auth-external-microservice", "/v1/workhand/listWorkHandOver", formParams, headerParams, SysProcessWorkHan.class);
    }

    public OrgEntity getAccountByOrg(String account) throws PaasAAAAException {
        HashMap<String, String> formParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        headerParams.put("Authorization", this.getAuthorization());
        formParams.put("account", account);
        OrgEntity orgEntity = (OrgEntity)this.findEntityBySingleParamGetObj("auth-external-microservice", "/v1/org/getAccountByOrg", formParams, headerParams, OrgEntity.class, "application/x-www-form-urlencoded");
        return orgEntity;
    }

    public OrgEntity getSuperiorOrg(String orgCode) throws PaasAAAAException {
        HashMap<String, String> formParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        headerParams.put("Authorization", this.getAuthorization());
        formParams.put("orgCode", orgCode);
        OrgEntity orgEntity = (OrgEntity)this.findEntityBySingleParamGetObj("auth-external-microservice", "/v1/org/getSuperiorOrg", formParams, headerParams, OrgEntity.class, "application/x-www-form-urlencoded");
        return orgEntity;
    }

    public List<OrgEntity> getSonOrg(String orgCode) throws PaasAAAAException {
        HashMap<String, String> formParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        headerParams.put("Authorization", this.getAuthorization());
        formParams.put("orgCode", orgCode);
        return this.findListBySingleParam("auth-external-microservice", "/v1/org/getSonOrg", formParams, headerParams, OrgEntity.class, "application/x-www-form-urlencoded");
    }

    public List<UserEntity> getOrgCodeByUser(String orgCode) throws PaasAAAAException {
        HashMap<String, String> formParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        headerParams.put("Authorization", this.getAuthorization());
        formParams.put("orgCode", orgCode);
        return this.findListBySingleParam("auth-external-microservice", "/v1/user/getOrgCodeByUser", formParams, headerParams, UserEntity.class, "application/x-www-form-urlencoded");
    }

    public List<UserEntity> getOrgCodeRoleByUser(String orgCode, String rolus) throws PaasAAAAException {
        HashMap<String, String> formParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        headerParams.put("Authorization", this.getAuthorization());
        formParams.put("orgCode", orgCode);
        formParams.put("rolus", rolus.toString());
        return this.findListBySingleParam("auth-external-microservice", "/v1/user/getOrgCodeRoleByUser", formParams, headerParams, UserEntity.class, "application/x-www-form-urlencoded");
    }

    public TokenResponse getTokenByUserName(String userName, String appId) throws PaasAAAAException {
        HashMap<String, String> formParams = new HashMap<String, String>();
        formParams.put("userName", userName);
        formParams.put("appId", appId);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        TokenResponse tokenResponse = (TokenResponse)this.findEntityBySingleParamGetObj("auth-external-microservice", "/v1/public/anon/getTokenByUserName", formParams, headerParams, TokenResponse.class, "application/x-www-form-urlencoded");
        return tokenResponse;
    }

    public static void main(String[] args) throws PaasAAAAException {
        AAAAService aaaaService = new AAAAService(){

            @Override
            public String getAuthorization() {
                return "eyJhbGciOiJIUzUxMiJ9.eyJsb2dpbl9hcHBfaWQiOiIxMjc4MjA4NjAzMTcwNjA3MTA2Iiwic3ViIjoiSW5zcHVyLUF1dGgtTWFuYWdlciIsImF1ZCI6bnVsbCwibG9naW5fdWlkIjoiMTI4MTkxMTQ3MDQ4NDA5NDk3OCIsIm5iZiI6MTU5NzcxMzg5NiwibG9naW5fYWNjb3VudF9pZCI6IjEyODE5MTE2NDkxNDg4NjI0NjUiLCJpc3MiOiJJbnNwdXIiLCJsb2dpbl9sb2dpbm5hbWUiOiJyb290LXpiIiwibG9naW5fYWNjb3VudF9uYW1lIjoi5oC76YOo566h55CG5ZGYIiwiZXhwIjoxNTk3ODAwMjk2LCJqdGkiOiIxLjAiLCJsb2dpbl91bmFtZSI6IuaAu-mDqOeuoeeQhuWRmCJ9.DvpQUpQrkmmzldzjdTkep7kygBJRNxDwlCCpRWz8QIYEoU5pcZQvVmTba-b-xJ23Ubmd48ZKpOh5yDIdkBeM1Q";
            }
        };
        List<UserEntity> list = aaaaService.getOrgCodeByUser("10356");
        System.out.println("str" + JSONObject.toJSONString(list));
        UserEntity userEntity = aaaaService.getUser();
        System.out.println("str" + JSONObject.toJSONString((Object)userEntity));
    }

    public List<String> getUsersByGroupEn(String groupEn) throws PaasAAAAException {
        HashMap<String, String> formParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        headerParams.put("Authorization", this.getAuthorization());
        formParams.put("groupEn", groupEn);
        return this.findListBySingleParam("service-pms", "/api/teamgroup/getUsersByGroupEn", formParams, headerParams, String.class, "application/x-www-form-urlencoded");
    }

    public List<TeamGroupVo> getGroupsAndUsers(String processEn, String groupEn, String belongCityCode, String belongRegionCode, String type1En, String type2En, String type3En, boolean wheQueryUsers) throws PaasAAAAException {
        return this.getGroupsAndUsers(processEn, groupEn, belongCityCode, belongRegionCode, type1En, type2En, type3En, "", wheQueryUsers);
    }

    public List<TeamGroupVo> getGroupsAndUsers(String processEn, String groupEn, String belongCityCode, String belongRegionCode, String type1En, String type2En, String type3En, String teamRoleEn, boolean wheQueryUsers) throws PaasAAAAException {
        HashMap<String, String> formParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        headerParams.put("Authorization", this.getAuthorization());
        formParams.put("processEn", processEn);
        formParams.put("groupEn", groupEn);
        formParams.put("belongCityCode", belongCityCode);
        formParams.put("belongRegionCode", belongRegionCode);
        formParams.put("type1En", type1En);
        formParams.put("type2En", type2En);
        formParams.put("type3En", type3En);
        formParams.put("teamRoleEn", teamRoleEn);
        if (wheQueryUsers) {
            formParams.put("wheQueryUsers", "Y");
        } else {
            formParams.put("wheQueryUsers", "N");
        }
        return this.findListBySingleParam("service-pms", "/api/teamgroup/getGroupsAndUsers", formParams, headerParams, TeamGroupVo.class, null);
    }

    public TeamGroupVo getGroupById(String groupEn) throws PaasAAAAException {
        return this.getGroupById(groupEn, false);
    }

    public TeamGroupVo getGroupById(String groupEn, boolean wheQueryUsers) throws PaasAAAAException {
        HashMap<String, String> formParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        headerParams.put("Authorization", this.getAuthorization());
        formParams.put("groupEn", groupEn);
        if (wheQueryUsers) {
            formParams.put("wheQueryUsers", "Y");
        } else {
            formParams.put("wheQueryUsers", "N");
        }
        List<TeamGroupVo> teamGroupVoList = this.findListBySingleParam("service-pms", "/api/teamgroup/getGroupsAndUsers", formParams, headerParams, TeamGroupVo.class, null);
        if (teamGroupVoList != null && teamGroupVoList.size() > 0) {
            return teamGroupVoList.get(0);
        }
        return null;
    }

    public TeamGroupVo getGroupByGroupCh(String groupCh, boolean wheQueryUsers) throws PaasAAAAException {
        if (groupCh == null || "".equals(groupCh.trim())) {
            return null;
        }
        HashMap<String, String> formParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        headerParams.put("Authorization", this.getAuthorization());
        formParams.put("groupCh", groupCh);
        if (wheQueryUsers) {
            formParams.put("wheQueryUsers", "Y");
        } else {
            formParams.put("wheQueryUsers", "N");
        }
        List<TeamGroupVo> teamGroupVoList = this.findListBySingleParam("service-pms", "/api/teamgroup/getGroupsAndUsers", formParams, headerParams, TeamGroupVo.class, null);
        if (teamGroupVoList != null && teamGroupVoList.size() > 0) {
            return teamGroupVoList.get(0);
        }
        return null;
    }

    public List<TeamGroupVo> getGroupsByUserName(String processEn, String userName) throws PaasAAAAException {
        return this.getGroupsByUserName(processEn, userName, false);
    }

    public List<TeamGroupVo> getGroupsByUserName(String processEn, String userName, boolean wheQueryUsers) throws PaasAAAAException {
        HashMap<String, String> formParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        headerParams.put("Authorization", this.getAuthorization());
        formParams.put("processEn", processEn);
        formParams.put("userName", userName);
        if (wheQueryUsers) {
            formParams.put("wheQueryUsers", "Y");
        } else {
            formParams.put("wheQueryUsers", "N");
        }
        return this.findListBySingleParam("service-pms", "/api/teamgroup/getGroupsByUserName", formParams, headerParams, TeamGroupVo.class, null);
    }

    public List<TeamGroupVo> getGroupsForFaultT1(String type1En, String type2En, String type3En) throws PaasAAAAException {
        HashMap<String, String> formParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        headerParams.put("Authorization", this.getAuthorization());
        formParams.put("type1En", type1En);
        formParams.put("type2En", type2En);
        formParams.put("type3En", type3En);
        return this.findListBySingleParam("service-pms", "/api/teamgroup/getGroupsForT1", formParams, headerParams, TeamGroupVo.class, null);
    }

    public List<TeamGroupVo> getGroupsForFaultCheck(String type1En, String type2En, String type3En) throws PaasAAAAException {
        HashMap<String, String> formParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        headerParams.put("Authorization", this.getAuthorization());
        formParams.put("type1En", type1En);
        formParams.put("type2En", type2En);
        formParams.put("type3En", type3En);
        return this.findListBySingleParam("service-pms", "/api/teamgroup/getGroupsForFaultCheck", formParams, headerParams, TeamGroupVo.class, null);
    }

    public SysRegion getRegionById(String regionId) throws PaasAAAAException {
        if (regionId == null || "".equals(regionId.trim())) {
            return null;
        }
        HashMap<String, String> formParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        headerParams.put("Authorization", this.getAuthorization());
        formParams.put("id", regionId);
        SysRegion sysRegion = (SysRegion)this.findEntityBySingleParamGetObj("service-pms", "/api/region/getRegionById", formParams, headerParams, SysRegion.class, "application/x-www-form-urlencoded");
        return sysRegion;
    }

    public SysRegion getRegionByCh(String ch) throws PaasAAAAException {
        if (ch == null || "".equals(ch.trim())) {
            return null;
        }
        HashMap<String, String> formParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        headerParams.put("Authorization", this.getAuthorization());
        formParams.put("ch", ch);
        SysRegion sysRegion = (SysRegion)this.findEntityBySingleParamGetObj("service-pms", "/api/region/getRegionByCh", formParams, headerParams, SysRegion.class, "application/x-www-form-urlencoded");
        return sysRegion;
    }

    public List<SysRegion> getRegionsByParentId(String parentId) throws PaasAAAAException {
        if (parentId == null || "".equals(parentId.trim())) {
            return null;
        }
        HashMap<String, String> formParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        headerParams.put("Authorization", this.getAuthorization());
        formParams.put("parentId", parentId);
        return this.findListBySingleParam("service-pms", "/api/region/getRegionByParentId", formParams, headerParams, SysRegion.class, "application/x-www-form-urlencoded");
    }
}

