/*
 * Decompiled with CFR 0.152.
 */
package com.ucloud.paas.proxy;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ucloud.paas.agent.PaasException;
import com.ucloud.paas.agent.PaasSysInfo;
import com.ucloud.paas.proxy.CallResult;
import com.ucloud.paas.proxy.GResponse;
import com.ucloud.paas.proxy.HttpMethod;
import com.ucloud.paas.proxy.aaaa.util.TrainX509TrustManager;
import com.ucloud.paas.proxy.aaaa.util.TrustAnyHostnameVerifier;
import com.ucloud.paas.proxy.logger.TSProxyLogger;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.security.SecureRandom;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class TechServiceProxy {
    private static final Logger log = LoggerFactory.getLogger(TechServiceProxy.class);
    private static final int CONNECTION_TIMEOUT = 30000;
    private static HashMap<String, Object> serviceConfig = new HashMap();
    private static DateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static PaasSysInfo sysInfo = PaasSysInfo.getInstance();

    public static void putConfig(String key, Object value) {
        serviceConfig.put(key, value);
    }

    protected static Object getConfig(String key) {
        System.out.println("serviceConfig = " + serviceConfig.toString());
        return serviceConfig.get(key);
    }

    public static void putConfig(String serviceName, String key, String value) {
        try {
            if (serviceConfig.get(serviceName) == null) {
                JSONObject obj = new JSONObject();
                obj.put(key, (Object)value);
                serviceConfig.put(serviceName, obj);
            } else {
                ((JSONObject)serviceConfig.get(serviceName)).put(key, (Object)value);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
    }

    protected static void setRequestHeader(HttpsURLConnection httpConn, HttpMethod method, HashMap<String, String> headerParams) throws PaasException {
        String token = sysInfo.getToken();
        if (token == null) {
            token = "";
        }
        httpConn.setRequestProperty("TOKEN", token);
        String appId = sysInfo.getAppId();
        if (appId == null) {
            appId = "";
        }
        httpConn.setRequestProperty("APPID", appId);
        String appInstanceId = sysInfo.getAppInstanceId();
        if (appInstanceId == null) {
            appInstanceId = "";
        }
        httpConn.setRequestProperty("APPINSTANCEID", appInstanceId);
        String appGroupId = sysInfo.getAppGroupId();
        if (appGroupId == null) {
            appGroupId = "";
        }
        httpConn.setRequestProperty("APPGROUPID", appGroupId);
        if (headerParams != null) {
            for (String key : headerParams.keySet()) {
                String value = headerParams.get(key);
                if (value == null) {
                    value = "";
                }
                httpConn.setRequestProperty(key, value);
            }
        }
        try {
            httpConn.setRequestMethod(method.toString());
        }
        catch (ProtocolException e) {
            throw new PaasException(e);
        }
    }

    protected static CallResult call(String serviceName, String subURI, HttpMethod method) throws PaasException {
        String serviceURL = sysInfo.getIpAddress() + serviceName + (subURI == null ? "" : subURI);
        return TechServiceProxy.doCall(serviceName, serviceURL, method, null, null, null);
    }

    protected static CallResult call(String serviceName, String subURI, HttpMethod method, String accept) throws PaasException {
        String serviceURL = sysInfo.getIpAddress() + serviceName + (subURI == null ? "" : subURI);
        return TechServiceProxy.doCall(serviceName, serviceURL, method, null, accept, null);
    }

    protected static CallResult call(String serviceName, String subURI, HttpMethod method, HashMap<String, String> headerParams, HashMap<String, String> formParams, String accept) throws PaasException {
        String serviceURL = sysInfo.getIpAddress() + serviceName + (subURI == null ? "" : subURI);
        StringBuffer body = new StringBuffer("&");
        return TechServiceProxy.doHttpCall(serviceName, serviceURL, method, headerParams, accept, formParams, "");
    }

    protected static CallResult call(String serviceName, String subURI, HttpMethod method, HashMap<String, String> headerParams, HashMap<String, String> formParams, String accept, String contentType) throws PaasException {
        String serviceURL = sysInfo.getIpAddress() + serviceName + (subURI == null ? "" : subURI);
        return TechServiceProxy.doHttpCall(serviceName, serviceURL, method, headerParams, accept, formParams, contentType);
    }

    protected static CallResult call(String serviceName, String subURI, HttpMethod method, HashMap<String, String> headerParams, HashMap<String, String> formParams) throws PaasException {
        return TechServiceProxy.call(serviceName, subURI, method, headerParams, formParams, null);
    }

    protected static CallResult callContent(String serviceName, String subURI, HttpMethod method, HashMap<String, String> headerParams, HashMap<String, String> formParams, String contentType) throws PaasException {
        return TechServiceProxy.call(serviceName, subURI, method, headerParams, formParams, null, contentType);
    }

    private static CallResult doCall(String serviceName, String serviceURL, HttpMethod method, HashMap<String, String> headerParams, String accept, String body) throws PaasException {
        System.out.println("serviceURL" + serviceURL);
        log.info("serviceURL=" + serviceURL);
        log.info("body=" + body);
        long startTime = System.currentTimeMillis();
        URL url = null;
        HttpURLConnection httpConn = null;
        try {
            SSLContext sslContext = SSLContext.getInstance("SSL");
            TrustManager[] tm = new TrustManager[]{new TrainX509TrustManager()};
            sslContext.init(null, tm, new SecureRandom());
            SSLSocketFactory ssf = sslContext.getSocketFactory();
            url = new URL(serviceURL);
            httpConn = (HttpsURLConnection)url.openConnection();
            TechServiceProxy.setRequestHeader((HttpsURLConnection)httpConn, method, headerParams);
            httpConn.setDoOutput(true);
            httpConn.setUseCaches(false);
            httpConn.setRequestProperty("Cache-Control", "no-cache");
            httpConn.setConnectTimeout(30000);
            httpConn.setReadTimeout(30000);
            if (accept == null) {
                accept = "application/json";
            }
            httpConn.setRequestProperty("Accept", accept);
            ((HttpsURLConnection)httpConn).setSSLSocketFactory(ssf);
            ((HttpsURLConnection)httpConn).setHostnameVerifier(new TrustAnyHostnameVerifier());
            if (body != null && !body.equals("")) {
                DataOutputStream dos = new DataOutputStream(httpConn.getOutputStream());
                dos.writeBytes(body);
                dos.flush();
                dos.close();
            } else {
                httpConn.connect();
            }
            int responseCode = httpConn.getResponseCode();
            InputStream input = responseCode == 200 ? httpConn.getInputStream() : httpConn.getErrorStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(input, "utf-8"));
            String row = null;
            String respData = "";
            while ((row = br.readLine()) != null) {
                respData = respData + row;
            }
            br.close();
            long endTime = System.currentTimeMillis();
            long costTime = endTime - startTime;
            if (costTime > 2000L) {
                // empty if block
            }
            CallResult cr = new CallResult();
            cr.setStatus(responseCode);
            cr.setBody(respData);
            cr.setCosttime(costTime);
            TSProxyLogger.info(startTime / 1000L, serviceName, serviceURL, responseCode, costTime);
            CallResult callResult = cr;
            return callResult;
        }
        catch (IOException e) {
            TSProxyLogger.info(startTime / 1000L, serviceName, serviceURL, 0, 0L);
            TechServiceProxy.logCallEvent(serviceName, null, e);
            throw new PaasException(e);
        }
        catch (Exception e) {
            TSProxyLogger.info(startTime / 1000L, serviceName, serviceURL, 0, 0L);
            TechServiceProxy.logCallEvent(serviceName, null, e);
            throw new PaasException(e);
        }
        finally {
            if (httpConn != null) {
                httpConn.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CallResult doHttpCall(String serviceName, String serviceURL, HttpMethod method, HashMap<String, String> headerParams, String accept, HashMap<String, String> formParams, String contentType) throws PaasException {
        block30: {
            long startTime = System.currentTimeMillis();
            CloseableHttpClient httpclient = HttpClients.createDefault();
            log.info("doHttpCall===" + serviceURL);
            HttpPost httpPost = new HttpPost(serviceURL);
            CloseableHttpResponse response = null;
            String content = null;
            if (StringUtils.isEmpty((Object)contentType)) {
                contentType = "application/json;charset=utf-8";
            }
            httpPost.setHeader("Content-Type", contentType);
            if (headerParams != null) {
                for (String key : headerParams.keySet()) {
                    String value = headerParams.get(key);
                    if (value == null) {
                        value = "";
                    }
                    httpPost.setHeader(key, value);
                }
            }
            try {
                CallResult callResult;
                if ("application/json;charset=utf-8".equals(contentType)) {
                    String body = JSONObject.toJSONString(formParams);
                    if (body != null && body != "null" && !"null".equals(body)) {
                        StringEntity stringEntity = new StringEntity(body, "UTF-8");
                        httpPost.setEntity((HttpEntity)stringEntity);
                    }
                } else if (formParams != null) {
                    ArrayList<BasicNameValuePair> paramList = new ArrayList<BasicNameValuePair>();
                    for (String key : formParams.keySet()) {
                        String value = formParams.get(key);
                        if (value == null) continue;
                        paramList.add(new BasicNameValuePair(key, value + ""));
                    }
                    UrlEncodedFormEntity entity = new UrlEncodedFormEntity(paramList, "UTF-8");
                    httpPost.setEntity((HttpEntity)entity);
                }
                response = httpclient.execute((HttpUriRequest)httpPost);
                if (response.getStatusLine().getStatusCode() != 200) break block30;
                try {
                    content = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
                    GResponse gResponse = new GResponse();
                    gResponse = (GResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)content), GResponse.class);
                    CallResult cr = new CallResult();
                    cr.setStatus(response.getStatusLine().getStatusCode());
                    cr.setBody(JSONObject.toJSONString((Object)gResponse.getData()));
                    long endTime = System.currentTimeMillis();
                    long costTime = endTime - startTime;
                    if (costTime > 2000L) {
                        // empty if block
                    }
                    cr.setCosttime(costTime);
                    callResult = cr;
                }
                catch (Throwable throwable) {
                    try {
                        response.close();
                        throw throwable;
                    }
                    catch (ClientProtocolException e) {
                        e.printStackTrace();
                        break block30;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        break block30;
                    }
                    catch (Throwable throwable2) {
                        throw throwable2;
                    }
                }
                response.close();
                return callResult;
            }
            finally {
                try {
                    httpclient.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    protected static void logCallEvent(String serviceName, CallResult result, Exception e) {
        if (e == null) {
            if (log.isDebugEnabled()) {
                log.debug("Call Service:" + serviceName + " cost time:" + result.getCosttime());
            }
        } else {
            log.error("Call Service:" + serviceName + " error! And exception:" + TechServiceProxy.getAnalysisOfException(e));
        }
    }

    private static String getAnalysisOfException(Throwable e) {
        StringBuffer sb = new StringBuffer();
        sb.append(e.getClass().getName() + ": " + e.getMessage() + "\n");
        StackTraceElement[] elems = e.getStackTrace();
        int len = elems.length;
        StackTraceElement tempElem = null;
        for (int i = 0; i < len; ++i) {
            tempElem = elems[i];
            sb.append("\tat " + tempElem.getClassName() + "." + tempElem.getMethodName() + ": (" + tempElem.getFileName() + ": " + tempElem.getLineNumber() + ")\n");
        }
        return sb.toString();
    }

    protected static void setRequestHeaderHttp(HttpURLConnection httpConn, HttpMethod method, HashMap<String, String> headerParams) throws PaasException {
        String token = sysInfo.getToken();
        if (token == null) {
            token = "";
        }
        httpConn.setRequestProperty("TOKEN", token);
        String appId = sysInfo.getAppId();
        if (appId == null) {
            appId = "";
        }
        httpConn.setRequestProperty("APPID", appId);
        String appInstanceId = sysInfo.getAppInstanceId();
        if (appInstanceId == null) {
            appInstanceId = "";
        }
        httpConn.setRequestProperty("APPINSTANCEID", appInstanceId);
        String appGroupId = sysInfo.getAppGroupId();
        if (appGroupId == null) {
            appGroupId = "";
        }
        httpConn.setRequestProperty("APPGROUPID", appGroupId);
        if (headerParams != null) {
            for (String key : headerParams.keySet()) {
                String value = headerParams.get(key);
                if (value == null) {
                    value = "";
                }
                httpConn.setRequestProperty(key, value);
            }
        }
        try {
            httpConn.setRequestMethod(method.toString());
        }
        catch (ProtocolException e) {
            throw new PaasException(e);
        }
    }
}

