/*
 * Decompiled with CFR 0.152.
 */
package com.ucloud.paas.agent;

import com.ucloud.paas.agent.PaasSysInfo;
import java.io.InputStream;
import java.util.Properties;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaasAgentLoadListener
implements ServletContextListener {
    private static final Logger log = LoggerFactory.getLogger(PaasAgentLoadListener.class);
    private static String configFilePathName = "paas-agent-config.properties";
    private static Properties prop;
    private static PaasSysInfo sysInfo;

    private static void loadAgentPropertiesWithClassPath() {
        try {
            InputStream is = PaasAgentLoadListener.class.getClassLoader().getResourceAsStream(configFilePathName);
            prop = new Properties();
            prop.load(is);
        }
        catch (Throwable e) {
            throw new RuntimeException("config-file cannot be load: " + configFilePathName);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void contextInitialized(ServletContextEvent sce) {
        if (prop == null) {
            PaasAgentLoadListener.loadAgentPropertiesWithClassPath();
        }
        if (prop != null) {
            String cmMaster = prop.getProperty("cm_master");
            String appId = prop.getProperty("app_id");
            String systemCode = prop.getProperty("system_code");
            if (cmMaster == null) throw new RuntimeException("CM Server is not config in paas-agent-config.properties!");
            String[] cm = cmMaster.split(":");
            if (cm.length != 2) throw new RuntimeException("CM Server is configed invalid in paas-agent-config.properties!");
            if (sysInfo.getIpAddress() == null) {
                sysInfo.setIpAddress("http://" + cmMaster + "/");
            }
            if (systemCode == null) throw new RuntimeException("CM Server is not config in paas-agent-config.properties!");
            sysInfo.setSystemCode(systemCode);
            return;
        } else {
            log.info("========PaasAgent startup failed,please check paas-agent-config.properties!===========");
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }

    static {
        sysInfo = PaasSysInfo.getInstance();
    }
}

