/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.bind.util.ISO8601Utils;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.influxdb.client.domain.Check;
import com.influxdb.client.domain.CheckDiscriminator;
import com.influxdb.client.domain.CustomCheck;
import com.influxdb.client.domain.DeadmanCheck;
import com.influxdb.client.domain.GreaterThreshold;
import com.influxdb.client.domain.HTTPNotificationEndpoint;
import com.influxdb.client.domain.HTTPNotificationRule;
import com.influxdb.client.domain.LesserThreshold;
import com.influxdb.client.domain.NotificationEndpoint;
import com.influxdb.client.domain.NotificationEndpointDiscriminator;
import com.influxdb.client.domain.NotificationRule;
import com.influxdb.client.domain.NotificationRuleDiscriminator;
import com.influxdb.client.domain.PagerDutyNotificationEndpoint;
import com.influxdb.client.domain.PagerDutyNotificationRule;
import com.influxdb.client.domain.RangeThreshold;
import com.influxdb.client.domain.SMTPNotificationRule;
import com.influxdb.client.domain.SlackNotificationEndpoint;
import com.influxdb.client.domain.SlackNotificationRule;
import com.influxdb.client.domain.TelegramNotificationEndpoint;
import com.influxdb.client.domain.TelegramNotificationRule;
import com.influxdb.client.domain.Threshold;
import com.influxdb.client.domain.ThresholdCheck;
import com.influxdb.utils.Arguments;
import java.io.IOException;
import java.sql.Date;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;

public class JSON {
    private Gson gson;

    public static GsonBuilder createGson() {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapterFactory(new DiscriminatorAdapter<Check>(Check.class, new LinkedHashMap<String, Class<? extends Check>>(){
            {
                this.put("deadman", DeadmanCheck.class);
                this.put("threshold", ThresholdCheck.class);
                this.put("custom", CustomCheck.class);
            }
        }));
        builder.registerTypeAdapterFactory(new DiscriminatorAdapter<CheckDiscriminator>(CheckDiscriminator.class, new LinkedHashMap<String, Class<? extends CheckDiscriminator>>(){
            {
                this.put("deadman", DeadmanCheck.class);
                this.put("threshold", ThresholdCheck.class);
                this.put("custom", CustomCheck.class);
            }
        }));
        builder.registerTypeAdapterFactory(new DiscriminatorAdapter<NotificationEndpoint>(NotificationEndpoint.class, new LinkedHashMap<String, Class<? extends NotificationEndpoint>>(){
            {
                this.put("slack", SlackNotificationEndpoint.class);
                this.put("pagerduty", PagerDutyNotificationEndpoint.class);
                this.put("http", HTTPNotificationEndpoint.class);
                this.put("telegram", TelegramNotificationEndpoint.class);
            }
        }));
        builder.registerTypeAdapterFactory(new DiscriminatorAdapter<NotificationEndpointDiscriminator>(NotificationEndpointDiscriminator.class, new LinkedHashMap<String, Class<? extends NotificationEndpointDiscriminator>>(){
            {
                this.put("slack", SlackNotificationEndpoint.class);
                this.put("pagerduty", PagerDutyNotificationEndpoint.class);
                this.put("http", HTTPNotificationEndpoint.class);
                this.put("telegram", TelegramNotificationEndpoint.class);
            }
        }));
        builder.registerTypeAdapterFactory(new DiscriminatorAdapter<NotificationRule>(NotificationRule.class, new LinkedHashMap<String, Class<? extends NotificationRule>>(){
            {
                this.put("slack", SlackNotificationRule.class);
                this.put("smtp", SMTPNotificationRule.class);
                this.put("pagerduty", PagerDutyNotificationRule.class);
                this.put("http", HTTPNotificationRule.class);
                this.put("telegram", TelegramNotificationRule.class);
            }
        }));
        builder.registerTypeAdapterFactory(new DiscriminatorAdapter<NotificationRuleDiscriminator>(NotificationRuleDiscriminator.class, new LinkedHashMap<String, Class<? extends NotificationRuleDiscriminator>>(){
            {
                this.put("slack", SlackNotificationRule.class);
                this.put("smtp", SMTPNotificationRule.class);
                this.put("pagerduty", PagerDutyNotificationRule.class);
                this.put("http", HTTPNotificationRule.class);
                this.put("telegram", TelegramNotificationRule.class);
            }
        }));
        builder.registerTypeAdapterFactory(new DiscriminatorAdapter<Threshold>(Threshold.class, new LinkedHashMap<String, Class<? extends Threshold>>(){
            {
                this.put("greater", GreaterThreshold.class);
                this.put("lesser", LesserThreshold.class);
                this.put("range", RangeThreshold.class);
            }
        }));
        return builder;
    }

    public JSON() {
        DateTypeAdapter dateTypeAdapter = new DateTypeAdapter();
        SqlDateTypeAdapter sqlDateTypeAdapter = new SqlDateTypeAdapter();
        OffsetDateTimeTypeAdapter offsetDateTimeTypeAdapter = new OffsetDateTimeTypeAdapter();
        LocalDateTypeAdapter localDateTypeAdapter = new LocalDateTypeAdapter();
        this.gson = JSON.createGson().registerTypeAdapter(java.util.Date.class, (Object)dateTypeAdapter).registerTypeAdapter(Date.class, (Object)sqlDateTypeAdapter).registerTypeAdapter(OffsetDateTime.class, (Object)offsetDateTimeTypeAdapter).registerTypeAdapter(LocalDate.class, (Object)localDateTypeAdapter).create();
    }

    public Gson getGson() {
        return this.gson;
    }

    public JSON setGson(Gson gson) {
        this.gson = gson;
        return this;
    }

    static final class DiscriminatorAdapter<T>
    implements TypeAdapterFactory {
        private final Class<?> type;
        private final Map<String, Class<? extends T>> subTypes;
        private TypeAdapter<?> cachedAdapter;

        DiscriminatorAdapter(@Nonnull Class<T> type, @Nonnull Map<String, Class<? extends T>> subTypes) {
            Arguments.checkNotNull(type, (String)"type");
            Arguments.checkNotNull(subTypes, (String)"subTypes");
            this.type = type;
            this.subTypes = subTypes;
        }

        public <R> TypeAdapter<R> create(Gson gson, TypeToken<R> type) {
            if (type == null) {
                return null;
            }
            if (!this.type.isAssignableFrom(type.getRawType())) {
                return null;
            }
            if (this.cachedAdapter == null) {
                this.cachedAdapter = new InnerDiscriminatorAdapter(gson).nullSafe();
            }
            return this.cachedAdapter;
        }

        private class InnerDiscriminatorAdapter<R>
        extends TypeAdapter<R> {
            private final Gson gson;
            private final TypeAdapter<JsonElement> jsonAdapter;
            private final Map<String, TypeAdapter<?>> cachedSubtypesReadAdapters;
            private final Map<Class<?>, TypeAdapter<?>> cachedSubtypesWriteAdapters;

            InnerDiscriminatorAdapter(Gson gson) {
                Arguments.checkNotNull((Object)gson, (String)"gson");
                this.gson = gson;
                this.jsonAdapter = gson.getAdapter(JsonElement.class);
                this.cachedSubtypesReadAdapters = new LinkedHashMap();
                this.cachedSubtypesWriteAdapters = new LinkedHashMap();
                for (Map.Entry entry : DiscriminatorAdapter.this.subTypes.entrySet()) {
                    TypeAdapter adapter = gson.getDelegateAdapter((TypeAdapterFactory)DiscriminatorAdapter.this, TypeToken.get((Class)((Class)entry.getValue())));
                    this.cachedSubtypesReadAdapters.put((String)entry.getKey(), (TypeAdapter<?>)adapter);
                    this.cachedSubtypesWriteAdapters.put((Class<?>)entry.getValue(), (TypeAdapter<?>)adapter);
                }
            }

            public R read(JsonReader in) throws IOException {
                JsonObject json = ((JsonElement)this.jsonAdapter.read(in)).getAsJsonObject();
                JsonElement discriminatorJson = json.get("type");
                if (discriminatorJson == null) {
                    String msg = String.format("Cannot find JSON field 'type' for %s adapter. JSON value: '%s'", DiscriminatorAdapter.this.type, json);
                    throw new JsonParseException(msg);
                }
                String discriminator = discriminatorJson.getAsString();
                TypeAdapter<?> adapter = this.cachedSubtypesReadAdapters.get(discriminator);
                if (adapter == null) {
                    String msg = String.format("Cannot find model: '%s' for discriminator: '%s'. The discriminator wasn't registered.", discriminator, DiscriminatorAdapter.this.type);
                    throw new JsonParseException(msg);
                }
                return (R)adapter.fromJsonTree((JsonElement)json);
            }

            public void write(JsonWriter out, R value) throws IOException {
                Class<?> outputType = value.getClass();
                TypeAdapter adapter = this.cachedSubtypesWriteAdapters.get(outputType);
                if (adapter == null) {
                    adapter = this.gson.getDelegateAdapter((TypeAdapterFactory)DiscriminatorAdapter.this, TypeToken.get(outputType));
                    this.cachedSubtypesWriteAdapters.put(DiscriminatorAdapter.this.type, adapter);
                }
                this.jsonAdapter.write(out, (Object)adapter.toJsonTree(value).getAsJsonObject());
            }
        }
    }

    public static class DateTypeAdapter
    extends TypeAdapter<java.util.Date> {
        private DateFormat dateFormat;

        public void setFormat(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        public void write(JsonWriter out, java.util.Date date) throws IOException {
            if (date == null) {
                out.nullValue();
            } else {
                String value = this.dateFormat != null ? this.dateFormat.format(date) : ISO8601Utils.format((java.util.Date)date, (boolean)true);
                out.value(value);
            }
        }

        public java.util.Date read(JsonReader in) throws IOException {
            try {
                switch (in.peek()) {
                    case NULL: {
                        in.nextNull();
                        return null;
                    }
                }
                String date = in.nextString();
                try {
                    if (this.dateFormat != null) {
                        return this.dateFormat.parse(date);
                    }
                    return ISO8601Utils.parse((String)date, (ParsePosition)new ParsePosition(0));
                }
                catch (ParseException e) {
                    throw new JsonParseException((Throwable)e);
                }
            }
            catch (IllegalArgumentException e) {
                throw new JsonParseException((Throwable)e);
            }
        }
    }

    public static class SqlDateTypeAdapter
    extends TypeAdapter<Date> {
        private DateFormat dateFormat;

        public void setFormat(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        public void write(JsonWriter out, Date date) throws IOException {
            if (date == null) {
                out.nullValue();
            } else {
                String value = this.dateFormat != null ? this.dateFormat.format(date) : date.toString();
                out.value(value);
            }
        }

        public Date read(JsonReader in) throws IOException {
            switch (in.peek()) {
                case NULL: {
                    in.nextNull();
                    return null;
                }
            }
            String date = in.nextString();
            try {
                if (this.dateFormat != null) {
                    return new Date(this.dateFormat.parse(date).getTime());
                }
                return new Date(ISO8601Utils.parse((String)date, (ParsePosition)new ParsePosition(0)).getTime());
            }
            catch (ParseException e) {
                throw new JsonParseException((Throwable)e);
            }
        }
    }

    public class LocalDateTypeAdapter
    extends TypeAdapter<LocalDate> {
        private DateTimeFormatter formatter;

        public LocalDateTypeAdapter() {
            this(DateTimeFormatter.ISO_LOCAL_DATE);
        }

        public LocalDateTypeAdapter(DateTimeFormatter formatter) {
            this.formatter = formatter;
        }

        public void setFormat(DateTimeFormatter dateFormat) {
            this.formatter = dateFormat;
        }

        public void write(JsonWriter out, LocalDate date) throws IOException {
            if (date == null) {
                out.nullValue();
            } else {
                out.value(this.formatter.format(date));
            }
        }

        public LocalDate read(JsonReader in) throws IOException {
            switch (in.peek()) {
                case NULL: {
                    in.nextNull();
                    return null;
                }
            }
            String date = in.nextString();
            return LocalDate.parse(date, this.formatter);
        }
    }

    public static class OffsetDateTimeTypeAdapter
    extends TypeAdapter<OffsetDateTime> {
        private static final OffsetDateTime ZERO = LocalDateTime.of(0, 1, 1, 0, 0).atOffset(ZoneOffset.UTC);
        private DateTimeFormatter formatter;

        public OffsetDateTimeTypeAdapter() {
            this(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        }

        public OffsetDateTimeTypeAdapter(DateTimeFormatter formatter) {
            this.formatter = formatter;
        }

        public void setFormat(DateTimeFormatter dateFormat) {
            this.formatter = dateFormat;
        }

        public void write(JsonWriter out, OffsetDateTime date) throws IOException {
            if (date == null) {
                out.nullValue();
            } else {
                if (date.getYear() > 9999 || date.isBefore(ZERO)) {
                    throw new JsonIOException("OffsetDateTime is out of range. All dates and times are assumed to be in the \"current era\", somewhere between 0000AD and 9999AD.");
                }
                out.value(this.formatter.format(date));
            }
        }

        public OffsetDateTime read(JsonReader in) throws IOException {
            switch (in.peek()) {
                case NULL: {
                    in.nextNull();
                    return null;
                }
            }
            String date = in.nextString();
            if (date.endsWith("+0000")) {
                date = date.substring(0, date.length() - 5) + "Z";
            }
            return OffsetDateTime.parse(date, this.formatter);
        }
    }
}

