/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import com.ibm.icu.impl.CurrencyData;
import com.ibm.icu.impl.ICUResourceBundle;
import com.ibm.icu.impl.ICUResourceTableAccess;
import com.ibm.icu.impl.locale.AsciiUtil;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.lang.UScript;
import com.ibm.icu.text.BreakIterator;
import com.ibm.icu.text.DisplayContext;
import com.ibm.icu.text.LocaleDisplayNames;
import com.ibm.icu.text.MessageFormat;
import com.ibm.icu.util.ULocale;
import com.ibm.icu.util.UResourceBundle;
import com.ibm.icu.util.UResourceBundleIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocaleDisplayNamesImpl
extends LocaleDisplayNames {
    private final ULocale locale;
    private final LocaleDisplayNames.DialectHandling dialectHandling;
    private final DisplayContext capitalization;
    private final DisplayContext nameLength;
    private final DataTable langData;
    private final DataTable regionData;
    private final MessageFormat separatorFormat;
    private final MessageFormat format;
    private final MessageFormat keyTypeFormat;
    private final char formatOpenParen;
    private final char formatReplaceOpenParen;
    private final char formatCloseParen;
    private final char formatReplaceCloseParen;
    private final CurrencyData.CurrencyDisplayInfo currencyDisplayInfo;
    private static final Cache cache = new Cache();
    private boolean[] capitalizationUsage = null;
    private static final Map<String, CapitalizationContextUsage> contextUsageTypeMap = new HashMap<String, CapitalizationContextUsage>();
    private transient BreakIterator capitalizationBrkIter = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LocaleDisplayNames getInstance(ULocale locale, LocaleDisplayNames.DialectHandling dialectHandling) {
        Cache cache = LocaleDisplayNamesImpl.cache;
        synchronized (cache) {
            return LocaleDisplayNamesImpl.cache.get(locale, dialectHandling);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LocaleDisplayNames getInstance(ULocale locale, DisplayContext ... contexts) {
        Cache cache = LocaleDisplayNamesImpl.cache;
        synchronized (cache) {
            return LocaleDisplayNamesImpl.cache.get(locale, contexts);
        }
    }

    public LocaleDisplayNamesImpl(ULocale locale, LocaleDisplayNames.DialectHandling dialectHandling) {
        this(locale, dialectHandling == LocaleDisplayNames.DialectHandling.STANDARD_NAMES ? DisplayContext.STANDARD_NAMES : DisplayContext.DIALECT_NAMES, DisplayContext.CAPITALIZATION_NONE);
    }

    public LocaleDisplayNamesImpl(ULocale locale, DisplayContext ... contexts) {
        LocaleDisplayNames.DialectHandling dialectHandling = LocaleDisplayNames.DialectHandling.STANDARD_NAMES;
        DisplayContext capitalization = DisplayContext.CAPITALIZATION_NONE;
        DisplayContext nameLength = DisplayContext.LENGTH_FULL;
        block7: for (DisplayContext contextItem : contexts) {
            switch (contextItem.type()) {
                case DIALECT_HANDLING: {
                    dialectHandling = contextItem.value() == DisplayContext.STANDARD_NAMES.value() ? LocaleDisplayNames.DialectHandling.STANDARD_NAMES : LocaleDisplayNames.DialectHandling.DIALECT_NAMES;
                    continue block7;
                }
                case CAPITALIZATION: {
                    capitalization = contextItem;
                    continue block7;
                }
                case DISPLAY_LENGTH: {
                    nameLength = contextItem;
                    continue block7;
                }
            }
        }
        this.dialectHandling = dialectHandling;
        this.capitalization = capitalization;
        this.nameLength = nameLength;
        this.langData = LangDataTables.impl.get(locale);
        this.regionData = RegionDataTables.impl.get(locale);
        this.locale = ULocale.ROOT.equals(this.langData.getLocale()) ? this.regionData.getLocale() : this.langData.getLocale();
        String sep = this.langData.get("localeDisplayPattern", "separator");
        if ("separator".equals(sep)) {
            sep = "{0}, {1}";
        }
        this.separatorFormat = new MessageFormat(sep);
        String pattern = this.langData.get("localeDisplayPattern", "pattern");
        if ("pattern".equals(pattern)) {
            pattern = "{0} ({1})";
        }
        this.format = new MessageFormat(pattern);
        if (pattern.contains("\uff08")) {
            this.formatOpenParen = (char)65288;
            this.formatCloseParen = (char)65289;
            this.formatReplaceOpenParen = (char)65339;
            this.formatReplaceCloseParen = (char)65341;
        } else {
            this.formatOpenParen = (char)40;
            this.formatCloseParen = (char)41;
            this.formatReplaceOpenParen = (char)91;
            this.formatReplaceCloseParen = (char)93;
        }
        String keyTypePattern = this.langData.get("localeDisplayPattern", "keyTypePattern");
        if ("keyTypePattern".equals(keyTypePattern)) {
            keyTypePattern = "{0}={1}";
        }
        this.keyTypeFormat = new MessageFormat(keyTypePattern);
        boolean needBrkIter = false;
        if (capitalization == DisplayContext.CAPITALIZATION_FOR_UI_LIST_OR_MENU || capitalization == DisplayContext.CAPITALIZATION_FOR_STANDALONE) {
            this.capitalizationUsage = new boolean[CapitalizationContextUsage.values().length];
            ICUResourceBundle rb = (ICUResourceBundle)UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt55b", locale);
            ICUResourceBundle contextTransformsBundle = null;
            try {
                contextTransformsBundle = rb.getWithFallback("contextTransforms");
            }
            catch (MissingResourceException e) {
                contextTransformsBundle = null;
            }
            if (contextTransformsBundle != null) {
                UResourceBundleIterator ctIterator = contextTransformsBundle.getIterator();
                while (ctIterator.hasNext()) {
                    int titlecaseInt;
                    String usageKey;
                    CapitalizationContextUsage usage;
                    UResourceBundle contextTransformUsage = ctIterator.next();
                    int[] intVector = contextTransformUsage.getIntVector();
                    if (intVector.length < 2 || (usage = contextUsageTypeMap.get(usageKey = contextTransformUsage.getKey())) == null || (titlecaseInt = capitalization == DisplayContext.CAPITALIZATION_FOR_UI_LIST_OR_MENU ? intVector[0] : intVector[1]) == 0) continue;
                    this.capitalizationUsage[usage.ordinal()] = true;
                    needBrkIter = true;
                }
            }
        }
        if (needBrkIter || capitalization == DisplayContext.CAPITALIZATION_FOR_BEGINNING_OF_SENTENCE) {
            this.capitalizationBrkIter = BreakIterator.getSentenceInstance(locale);
        }
        this.currencyDisplayInfo = CurrencyData.provider.getInstance(locale, false);
    }

    @Override
    public ULocale getLocale() {
        return this.locale;
    }

    @Override
    public LocaleDisplayNames.DialectHandling getDialectHandling() {
        return this.dialectHandling;
    }

    @Override
    public DisplayContext getContext(DisplayContext.Type type) {
        DisplayContext result;
        switch (type) {
            case DIALECT_HANDLING: {
                result = this.dialectHandling == LocaleDisplayNames.DialectHandling.STANDARD_NAMES ? DisplayContext.STANDARD_NAMES : DisplayContext.DIALECT_NAMES;
                break;
            }
            case CAPITALIZATION: {
                result = this.capitalization;
                break;
            }
            case DISPLAY_LENGTH: {
                result = this.nameLength;
                break;
            }
            default: {
                result = DisplayContext.STANDARD_NAMES;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String adjustForUsageAndContext(CapitalizationContextUsage usage, String name) {
        if (name != null && name.length() > 0 && UCharacter.isLowerCase(name.codePointAt(0)) && (this.capitalization == DisplayContext.CAPITALIZATION_FOR_BEGINNING_OF_SENTENCE || this.capitalizationUsage != null && this.capitalizationUsage[usage.ordinal()])) {
            LocaleDisplayNamesImpl localeDisplayNamesImpl = this;
            synchronized (localeDisplayNamesImpl) {
                if (this.capitalizationBrkIter == null) {
                    this.capitalizationBrkIter = BreakIterator.getSentenceInstance(this.locale);
                }
                return UCharacter.toTitleCase(this.locale, name, this.capitalizationBrkIter, 768);
            }
        }
        return name;
    }

    @Override
    public String localeDisplayName(ULocale locale) {
        return this.localeDisplayNameInternal(locale);
    }

    @Override
    public String localeDisplayName(Locale locale) {
        return this.localeDisplayNameInternal(ULocale.forLocale(locale));
    }

    @Override
    public String localeDisplayName(String localeId) {
        return this.localeDisplayNameInternal(new ULocale(localeId));
    }

    private String localeDisplayNameInternal(ULocale locale) {
        Iterator<String> keys;
        boolean hasVariant;
        String resultName = null;
        String lang = locale.getLanguage();
        if (locale.getBaseName().length() == 0) {
            lang = "root";
        }
        String script = locale.getScript();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        boolean hasScript = script.length() > 0;
        boolean hasCountry = country.length() > 0;
        boolean bl = hasVariant = variant.length() > 0;
        if (this.dialectHandling == LocaleDisplayNames.DialectHandling.DIALECT_NAMES) {
            String langCountry;
            String langScript;
            String langScriptCountry;
            String result;
            if (hasScript && hasCountry && !(result = this.localeIdName(langScriptCountry = lang + '_' + script + '_' + country)).equals(langScriptCountry)) {
                resultName = result;
                hasScript = false;
                hasCountry = false;
            } else if (hasScript && !(result = this.localeIdName(langScript = lang + '_' + script)).equals(langScript)) {
                resultName = result;
                hasScript = false;
            } else if (hasCountry && !(result = this.localeIdName(langCountry = lang + '_' + country)).equals(langCountry)) {
                resultName = result;
                hasCountry = false;
            }
        }
        if (resultName == null) {
            resultName = this.localeIdName(lang).replace(this.formatOpenParen, this.formatReplaceOpenParen).replace(this.formatCloseParen, this.formatReplaceCloseParen);
        }
        StringBuilder buf = new StringBuilder();
        if (hasScript) {
            buf.append(this.scriptDisplayNameInContext(script).replace(this.formatOpenParen, this.formatReplaceOpenParen).replace(this.formatCloseParen, this.formatReplaceCloseParen));
        }
        if (hasCountry) {
            this.appendWithSep(this.regionDisplayName(country).replace(this.formatOpenParen, this.formatReplaceOpenParen).replace(this.formatCloseParen, this.formatReplaceCloseParen), buf);
        }
        if (hasVariant) {
            this.appendWithSep(this.variantDisplayName(variant).replace(this.formatOpenParen, this.formatReplaceOpenParen).replace(this.formatCloseParen, this.formatReplaceCloseParen), buf);
        }
        if ((keys = locale.getKeywords()) != null) {
            while (keys.hasNext()) {
                String key = keys.next();
                String value = locale.getKeywordValue(key);
                String keyDisplayName = this.keyDisplayName(key).replace(this.formatOpenParen, this.formatReplaceOpenParen).replace(this.formatCloseParen, this.formatReplaceCloseParen);
                String valueDisplayName = this.keyValueDisplayName(key, value).replace(this.formatOpenParen, this.formatReplaceOpenParen).replace(this.formatCloseParen, this.formatReplaceCloseParen);
                if (!valueDisplayName.equals(value)) {
                    this.appendWithSep(valueDisplayName, buf);
                    continue;
                }
                if (!key.equals(keyDisplayName)) {
                    String keyValue = this.keyTypeFormat.format(new String[]{keyDisplayName, valueDisplayName});
                    this.appendWithSep(keyValue, buf);
                    continue;
                }
                this.appendWithSep(keyDisplayName, buf).append("=").append(valueDisplayName);
            }
        }
        String resultRemainder = null;
        if (buf.length() > 0) {
            resultRemainder = buf.toString();
        }
        if (resultRemainder != null) {
            resultName = this.format.format(new Object[]{resultName, resultRemainder});
        }
        return this.adjustForUsageAndContext(CapitalizationContextUsage.LANGUAGE, resultName);
    }

    private String localeIdName(String localeId) {
        String locIdName;
        if (this.nameLength == DisplayContext.LENGTH_SHORT && !(locIdName = this.langData.get("Languages%short", localeId)).equals(localeId)) {
            return locIdName;
        }
        return this.langData.get("Languages", localeId);
    }

    @Override
    public String languageDisplayName(String lang) {
        String langName;
        if (lang.equals("root") || lang.indexOf(95) != -1) {
            return lang;
        }
        if (this.nameLength == DisplayContext.LENGTH_SHORT && !(langName = this.langData.get("Languages%short", lang)).equals(lang)) {
            return this.adjustForUsageAndContext(CapitalizationContextUsage.LANGUAGE, langName);
        }
        return this.adjustForUsageAndContext(CapitalizationContextUsage.LANGUAGE, this.langData.get("Languages", lang));
    }

    @Override
    public String scriptDisplayName(String script) {
        String str = this.langData.get("Scripts%stand-alone", script);
        if (str.equals(script)) {
            if (this.nameLength == DisplayContext.LENGTH_SHORT && !(str = this.langData.get("Scripts%short", script)).equals(script)) {
                return this.adjustForUsageAndContext(CapitalizationContextUsage.SCRIPT, str);
            }
            str = this.langData.get("Scripts", script);
        }
        return this.adjustForUsageAndContext(CapitalizationContextUsage.SCRIPT, str);
    }

    @Override
    public String scriptDisplayNameInContext(String script) {
        String scriptName;
        if (this.nameLength == DisplayContext.LENGTH_SHORT && !(scriptName = this.langData.get("Scripts%short", script)).equals(script)) {
            return this.adjustForUsageAndContext(CapitalizationContextUsage.SCRIPT, scriptName);
        }
        return this.adjustForUsageAndContext(CapitalizationContextUsage.SCRIPT, this.langData.get("Scripts", script));
    }

    @Override
    public String scriptDisplayName(int scriptCode) {
        return this.scriptDisplayName(UScript.getShortName(scriptCode));
    }

    @Override
    public String regionDisplayName(String region) {
        String regionName;
        if (this.nameLength == DisplayContext.LENGTH_SHORT && !(regionName = this.regionData.get("Countries%short", region)).equals(region)) {
            return this.adjustForUsageAndContext(CapitalizationContextUsage.TERRITORY, regionName);
        }
        return this.adjustForUsageAndContext(CapitalizationContextUsage.TERRITORY, this.regionData.get("Countries", region));
    }

    @Override
    public String variantDisplayName(String variant) {
        return this.adjustForUsageAndContext(CapitalizationContextUsage.VARIANT, this.langData.get("Variants", variant));
    }

    @Override
    public String keyDisplayName(String key) {
        return this.adjustForUsageAndContext(CapitalizationContextUsage.KEY, this.langData.get("Keys", key));
    }

    @Override
    public String keyValueDisplayName(String key, String value) {
        String keyValueName = null;
        if (key.equals("currency")) {
            keyValueName = this.currencyDisplayInfo.getName(AsciiUtil.toUpperString(value));
            if (keyValueName == null) {
                keyValueName = value;
            }
        } else {
            String tmp;
            if (this.nameLength == DisplayContext.LENGTH_SHORT && !(tmp = this.langData.get("Types%short", key, value)).equals(value)) {
                keyValueName = tmp;
            }
            if (keyValueName == null) {
                keyValueName = this.langData.get("Types", key, value);
            }
        }
        return this.adjustForUsageAndContext(CapitalizationContextUsage.KEYVALUE, keyValueName);
    }

    @Override
    public List<LocaleDisplayNames.UiListItem> getUiListCompareWholeItems(Set<ULocale> localeSet, Comparator<LocaleDisplayNames.UiListItem> comparator) {
        DisplayContext capContext = this.getContext(DisplayContext.Type.CAPITALIZATION);
        ArrayList<LocaleDisplayNames.UiListItem> result = new ArrayList<LocaleDisplayNames.UiListItem>();
        HashMap<ULocale, HashSet<ULocale>> baseToLocales = new HashMap<ULocale, HashSet<ULocale>>();
        ULocale.Builder builder = new ULocale.Builder();
        for (ULocale uLocale : localeSet) {
            builder.setLocale(uLocale);
            ULocale loc = ULocale.addLikelySubtags(uLocale);
            ULocale base = new ULocale(loc.getLanguage());
            HashSet<ULocale> locales = (HashSet<ULocale>)baseToLocales.get(base);
            if (locales == null) {
                locales = new HashSet<ULocale>();
                baseToLocales.put(base, locales);
            }
            locales.add(loc);
        }
        for (Map.Entry entry : baseToLocales.entrySet()) {
            ULocale base = (ULocale)entry.getKey();
            Set values = (Set)entry.getValue();
            if (values.size() == 1) {
                ULocale locale = (ULocale)values.iterator().next();
                result.add(this.newRow(ULocale.minimizeSubtags(locale, ULocale.Minimize.FAVOR_SCRIPT), capContext));
                continue;
            }
            HashSet<String> scripts = new HashSet<String>();
            HashSet<String> regions = new HashSet<String>();
            ULocale maxBase = ULocale.addLikelySubtags(base);
            scripts.add(maxBase.getScript());
            regions.add(maxBase.getCountry());
            for (ULocale locale : values) {
                scripts.add(locale.getScript());
                regions.add(locale.getCountry());
            }
            boolean hasScripts = scripts.size() > 1;
            boolean hasRegions = regions.size() > 1;
            for (ULocale locale : values) {
                ULocale.Builder modified = builder.setLocale(locale);
                if (!hasScripts) {
                    modified.setScript("");
                }
                if (!hasRegions) {
                    modified.setRegion("");
                }
                result.add(this.newRow(modified.build(), capContext));
            }
        }
        Collections.sort(result, comparator);
        return result;
    }

    private LocaleDisplayNames.UiListItem newRow(ULocale modified, DisplayContext capContext) {
        ULocale minimized = ULocale.minimizeSubtags(modified, ULocale.Minimize.FAVOR_SCRIPT);
        String tempName = modified.getDisplayName(this.locale);
        boolean titlecase = capContext == DisplayContext.CAPITALIZATION_FOR_UI_LIST_OR_MENU;
        String nameInDisplayLocale = titlecase ? UCharacter.toTitleFirst(this.locale, tempName) : tempName;
        tempName = modified.getDisplayName(modified);
        String nameInSelf = capContext == DisplayContext.CAPITALIZATION_FOR_UI_LIST_OR_MENU ? UCharacter.toTitleFirst(modified, tempName) : tempName;
        return new LocaleDisplayNames.UiListItem(minimized, modified, nameInDisplayLocale, nameInSelf);
    }

    public static boolean haveData(DataTableType type) {
        switch (type) {
            case LANG: {
                return LangDataTables.impl instanceof ICUDataTables;
            }
            case REGION: {
                return RegionDataTables.impl instanceof ICUDataTables;
            }
        }
        throw new IllegalArgumentException("unknown type: " + (Object)((Object)type));
    }

    private StringBuilder appendWithSep(String s, StringBuilder b) {
        if (b.length() == 0) {
            b.append(s);
        } else {
            String combined = this.separatorFormat.format(new String[]{b.toString(), s});
            b.replace(0, b.length(), combined);
        }
        return b;
    }

    static {
        contextUsageTypeMap.put("languages", CapitalizationContextUsage.LANGUAGE);
        contextUsageTypeMap.put("script", CapitalizationContextUsage.SCRIPT);
        contextUsageTypeMap.put("territory", CapitalizationContextUsage.TERRITORY);
        contextUsageTypeMap.put("variant", CapitalizationContextUsage.VARIANT);
        contextUsageTypeMap.put("key", CapitalizationContextUsage.KEY);
        contextUsageTypeMap.put("keyValue", CapitalizationContextUsage.KEYVALUE);
    }

    private static class Cache {
        private ULocale locale;
        private LocaleDisplayNames.DialectHandling dialectHandling;
        private DisplayContext capitalization;
        private DisplayContext nameLength;
        private LocaleDisplayNames cache;

        private Cache() {
        }

        public LocaleDisplayNames get(ULocale locale, LocaleDisplayNames.DialectHandling dialectHandling) {
            if (dialectHandling != this.dialectHandling || DisplayContext.CAPITALIZATION_NONE != this.capitalization || DisplayContext.LENGTH_FULL != this.nameLength || !locale.equals(this.locale)) {
                this.locale = locale;
                this.dialectHandling = dialectHandling;
                this.capitalization = DisplayContext.CAPITALIZATION_NONE;
                this.nameLength = DisplayContext.LENGTH_FULL;
                this.cache = new LocaleDisplayNamesImpl(locale, dialectHandling);
            }
            return this.cache;
        }

        public LocaleDisplayNames get(ULocale locale, DisplayContext ... contexts) {
            LocaleDisplayNames.DialectHandling dialectHandlingIn = LocaleDisplayNames.DialectHandling.STANDARD_NAMES;
            DisplayContext capitalizationIn = DisplayContext.CAPITALIZATION_NONE;
            DisplayContext nameLengthIn = DisplayContext.LENGTH_FULL;
            block5: for (DisplayContext contextItem : contexts) {
                switch (contextItem.type()) {
                    case DIALECT_HANDLING: {
                        dialectHandlingIn = contextItem.value() == DisplayContext.STANDARD_NAMES.value() ? LocaleDisplayNames.DialectHandling.STANDARD_NAMES : LocaleDisplayNames.DialectHandling.DIALECT_NAMES;
                        continue block5;
                    }
                    case CAPITALIZATION: {
                        capitalizationIn = contextItem;
                        continue block5;
                    }
                    case DISPLAY_LENGTH: {
                        nameLengthIn = contextItem;
                        continue block5;
                    }
                }
            }
            if (dialectHandlingIn != this.dialectHandling || capitalizationIn != this.capitalization || nameLengthIn != this.nameLength || !locale.equals(this.locale)) {
                this.locale = locale;
                this.dialectHandling = dialectHandlingIn;
                this.capitalization = capitalizationIn;
                this.nameLength = nameLengthIn;
                this.cache = new LocaleDisplayNamesImpl(locale, contexts);
            }
            return this.cache;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DataTableType {
        LANG,
        REGION;

    }

    static class RegionDataTables {
        static final DataTables impl = DataTables.load("com.ibm.icu.impl.ICURegionDataTables");

        RegionDataTables() {
        }
    }

    static class LangDataTables {
        static final DataTables impl = DataTables.load("com.ibm.icu.impl.ICULangDataTables");

        LangDataTables() {
        }
    }

    static abstract class ICUDataTables
    extends DataTables {
        private final String path;

        protected ICUDataTables(String path) {
            this.path = path;
        }

        public DataTable get(ULocale locale) {
            return new ICUDataTable(this.path, locale);
        }
    }

    static abstract class DataTables {
        DataTables() {
        }

        public abstract DataTable get(ULocale var1);

        public static DataTables load(String className) {
            try {
                return (DataTables)Class.forName(className).newInstance();
            }
            catch (Throwable t) {
                final DataTable NO_OP = new DataTable();
                return new DataTables(){

                    public DataTable get(ULocale locale) {
                        return NO_OP;
                    }
                };
            }
        }
    }

    static class ICUDataTable
    extends DataTable {
        private final ICUResourceBundle bundle;

        public ICUDataTable(String path, ULocale locale) {
            this.bundle = (ICUResourceBundle)UResourceBundle.getBundleInstance(path, locale.getBaseName());
        }

        public ULocale getLocale() {
            return this.bundle.getULocale();
        }

        public String get(String tableName, String subTableName, String code) {
            return ICUResourceTableAccess.getTableString(this.bundle, tableName, subTableName, code);
        }
    }

    public static class DataTable {
        ULocale getLocale() {
            return ULocale.ROOT;
        }

        String get(String tableName, String code) {
            return this.get(tableName, null, code);
        }

        String get(String tableName, String subTableName, String code) {
            return code;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CapitalizationContextUsage {
        LANGUAGE,
        SCRIPT,
        TERRITORY,
        VARIANT,
        KEY,
        KEYVALUE;

    }
}

