/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal.wrappers.db2;

import com.ibm.db2.cmx.runtime.exception.ExceptionFactory;
import com.ibm.db2.cmx.runtime.internal.StaticProfileConstants;
import com.ibm.db2.cmx.runtime.internal.db.SqlStatementKey;
import com.ibm.db2.cmx.runtime.internal.db.StaticProfileCaptureHelper;
import com.ibm.db2.cmx.runtime.internal.db.db2.DB2JdbcData;
import com.ibm.db2.cmx.runtime.internal.db.db2.PDQConnectionCallbackImpl;
import com.ibm.db2.cmx.runtime.internal.db.db2.StaticProfileSection;
import com.ibm.db2.cmx.runtime.internal.proxy.db2.ProxiedDB2StatementInvocationHandler;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.runtime.internal.trace.DataLogger;
import com.ibm.db2.cmx.runtime.internal.wrappers.ConnectionExecutionHandler;
import com.ibm.db2.cmx.runtime.internal.wrappers.ExecutionHandler;
import com.ibm.db2.cmx.runtime.internal.wrappers.JDBCDynamicExecutionHandler;
import com.ibm.db2.cmx.runtime.internal.wrappers.StatementExecutionHandler;
import com.ibm.db2.cmx.runtime.internal.wrappers.db2.DB2ConnectionExecutionHandler;
import com.ibm.db2.cmx.runtime.internal.wrappers.db2.DB2PreparedStatementExecutionHandler;
import com.ibm.db2.cmx.runtime.statement.SqlStatementType;
import com.ibm.db2.jcc.DB2PreparedStatement;
import com.ibm.db2.jcc.DB2Statement;
import com.ibm.db2.jcc.DBPreparedStatementInfoInterface;
import com.ibm.db2.jcc.SQLJPreparedStatement;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.regex.Matcher;

public class DB2StatementExecutionHandler
extends StatementExecutionHandler {
    public DB2ConnectionExecutionHandler db2ConnectionExecutionHandler_ = null;
    private PreparedStatement firstBatchingPrepStmt_;
    private boolean isDbBatch_;
    private boolean jccMutationEnabled_ = false;
    private boolean isClientProgramId_ = false;
    private boolean logOCCWarning_ = true;
    private ArrayList<DB2PreparedStatementExecutionHandler> insertProxiesForHetroBatch_ = null;

    public DB2StatementExecutionHandler(DB2ConnectionExecutionHandler dB2ConnectionExecutionHandler, Statement statement, int n2, int n3, int n4, String[] stringArray, int[] nArray, int n5, String string, Method method, Object ... objectArray) throws SQLException {
        super(dB2ConnectionExecutionHandler, statement, n2, n3, n4, stringArray, nArray, n5, string, method, objectArray);
        this.db2ConnectionExecutionHandler_ = dB2ConnectionExecutionHandler;
        if (this.currentStates_.getProfilerHelperInstance() == null && this.logger_.isLoggable(Level.CONFIG)) {
            DataLogger.logConfigHighVis(this.logger_, this, "", DataLogger.getShortName(this) + " profilerHelperInstance is null", false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(String string, Method method, Object[] objectArray) throws Throwable {
        Object object = null;
        if (this.db2ConnectionExecutionHandler_.driverTraceOn_) {
            this.db2ConnectionExecutionHandler_.driverLogWriter_.println(this.db2ConnectionExecutionHandler_.buildDriverTraceHeader(this, "invoke") + "[" + string + "] enter...");
        }
        if (this.db2ConnectionExecutionHandler_.isClosed_) {
            return method.invoke((Object)this.physicalStatement_, objectArray);
        }
        if (this.logger_.isLoggable(Level.FINER)) {
            if (string.equals("equals") || string.equals("hashCode") || string.equals("toString")) {
                try {
                    return method.invoke((Object)this.physicalStatement_, objectArray);
                }
                catch (InvocationTargetException invocationTargetException) {
                    Throwable throwable = invocationTargetException.getTargetException();
                    DataLogger.logThrowable(this.logger_, throwable);
                    if (!(this instanceof DB2PreparedStatementExecutionHandler)) {
                        this.dumpLogs(throwable);
                    }
                    throw throwable;
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(null, Messages.getText("ERR_PROFILER_ILLEGAL_ACCESS_EXCEPTION", string, illegalAccessException.getMessage()), illegalAccessException, 10751);
                }
            }
            DataLogger.logAtLevelFiner(this.logger_, this, "invoke: " + string, "ENTRY " + Arrays.deepToString(objectArray));
        }
        Connection connection = this.db2ConnectionExecutionHandler_.physicalConnection_;
        synchronized (connection) {
            try {
                int n2;
                if (this.currentStates_.getStaticExecutionWithNoProfiler() || this.currentStates_.getDynamicExecutionWithNoProfiler()) {
                    return method.invoke((Object)this.physicalStatement_, objectArray);
                }
                if (string.startsWith("set") || string.startsWith("closeOn")) {
                    n2 = this.modifiedStatementAttributes_.saveModifiedAttributeIfNeeded(string, method, objectArray);
                    if (string.equals("closeOnCompletion")) {
                        return method.invoke((Object)this.physicalStatement_, objectArray);
                    }
                    if (n2 != 0 && !string.equals("setCursorName")) {
                        return object;
                    }
                }
                if (string.equals("executeQuery") && objectArray != null && objectArray.length == 1 && objectArray[0] != null) {
                    object = this.executeQuery((String)objectArray[0]);
                } else if (string.equals("execute") && objectArray != null && objectArray.length == 1 && objectArray[0] != null) {
                    object = this.execute((String)objectArray[0]);
                } else if (string.equals("executeUpdate") && objectArray != null && objectArray.length == 1 && objectArray[0] != null) {
                    object = this.executeUpdate((String)objectArray[0]);
                } else if (string.equals("getUpdateCount")) {
                    object = this.getUpdateCount();
                } else if (string.equals("addBatch") && objectArray != null && objectArray.length == 1 && objectArray[0] != null) {
                    this.isDbBatch_ = false;
                    this.addBatch((String)objectArray[0]);
                } else if (string.equals("executeBatch")) {
                    object = this.executeBatch();
                } else if (string.equals("clearBatch")) {
                    this.clearBatch();
                } else if (string.equals("close")) {
                    this.close();
                } else if (string.equals("getGeneratedKeys")) {
                    object = this.getGeneratedKeysAsResultSet();
                } else if (string.equals("execute") && objectArray != null && objectArray.length == 2 && objectArray[0] != null) {
                    n2 = this.db2ConnectionExecutionHandler_.getTypeOfParameterForAGK(method);
                    object = this.executeForAGKs((String)objectArray[0], objectArray[1], n2);
                } else if (string.equals("executeUpdate") && objectArray != null && objectArray.length == 2 && objectArray[0] != null) {
                    n2 = this.db2ConnectionExecutionHandler_.getTypeOfParameterForAGK(method);
                    object = this.executeUpdateForAGKs((String)objectArray[0], objectArray[1], n2);
                } else if (string.equals("getMaxRows")) {
                    object = this.modifiedStatementAttributes_.getMaxRows();
                } else if (string.equals("getFetchSize")) {
                    object = this.modifiedStatementAttributes_.getFetchSize();
                } else if (string.equals("getFetchDirection")) {
                    object = this.modifiedStatementAttributes_.getFetchDirection();
                } else if (string.equals("getMaxFieldSize")) {
                    object = this.modifiedStatementAttributes_.getMaxFieldSize();
                } else if (string.equals("getQueryTimeout")) {
                    object = this.modifiedStatementAttributes_.getQueryTimeout();
                } else if (string.equals("isPoolable")) {
                    ConnectionExecutionHandler.AttributeState attributeState = this.modifiedStatementAttributes_.getPoolable();
                    object = attributeState == ConnectionExecutionHandler.AttributeState.NOT_SET || attributeState == ConnectionExecutionHandler.AttributeState.SET_FALSE ? Boolean.valueOf(false) : Boolean.valueOf(true);
                } else if (string.equalsIgnoreCase("addDBBatch")) {
                    this.isDbBatch_ = true;
                    this.addDBBatch(objectArray[0]);
                } else if (string.equals("enableJccDateTimeMutation")) {
                    this.enableJccDateTimeMutation((Boolean)objectArray[0]);
                } else if (string.equals("setDB2ClientProgramId")) {
                    this.setDB2ClientProgramId((String)objectArray[0]);
                } else if (string.equals("getDB2ClientProgramId")) {
                    object = this.getDB2ClientProgramId();
                } else if (string.equals("executeDB2OptimisticLockingQuery")) {
                    this.db2ConnectionExecutionHandler_.logWarningFINEForOptimisticLocking(string, objectArray, this.logOCCWarning_);
                    object = method.invoke((Object)this.physicalStatement_, objectArray);
                    this.logOCCWarning_ = false;
                } else if (string.equals("getMoreResults")) {
                    object = objectArray == null ? Boolean.valueOf(this.getMoreResults()) : Boolean.valueOf(this.getMoreResults((Integer)objectArray[0]));
                } else if (string.equals("getResultSet")) {
                    object = this.getResultSet();
                } else if (string.equals("equals") || string.equals("hashCode") || string.equals("toString")) {
                    object = method.invoke((Object)this.physicalStatement_, objectArray);
                } else if (this.prepStmtHandle_ != null) {
                    object = this.prepStmtHandle_.invoke(string, method, objectArray);
                } else if (this.prepStmtHandle_ == null && string.equals("setCursorName")) {
                    this.cursorName_ = (String)objectArray[0];
                } else {
                    object = method.invoke((Object)this.physicalStatement_, objectArray);
                }
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                DataLogger.logThrowable(this.logger_, throwable);
                if (!(this instanceof DB2PreparedStatementExecutionHandler)) {
                    this.dumpLogs(throwable);
                }
                throw throwable;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(null, Messages.getText("ERR_PROFILER_ILLEGAL_ACCESS_EXCEPTION", string, illegalAccessException.getMessage()), illegalAccessException, 11760);
            }
            catch (SQLException sQLException) {
                if (!(this instanceof DB2PreparedStatementExecutionHandler)) {
                    DataLogger.logThrowable(this.logger_, sQLException);
                    this.dumpLogs(sQLException);
                }
                throw sQLException;
            }
        }
        if (this.db2ConnectionExecutionHandler_.driverTraceOn_) {
            this.db2ConnectionExecutionHandler_.driverLogWriter_.println(this.db2ConnectionExecutionHandler_.buildDriverTraceHeader(this, "invoke") + "[" + string + "] exit...");
        }
        if (this.logger_.isLoggable(Level.FINER)) {
            DataLogger.exit(this.logger_, this, "invoke: " + string, object);
        }
        return object;
    }

    private void setDB2ClientProgramId(String string) throws SQLException {
        ((DB2Statement)this.physicalStatement_).setDB2ClientProgramId(string);
        this.isClientProgramId_ = true;
    }

    private void enableJccDateTimeMutation(boolean bl2) {
        this.jccMutationEnabled_ = bl2;
    }

    private String getDB2ClientProgramId() throws SQLException {
        return ((DB2Statement)this.physicalStatement_).getDB2ClientProgramId();
    }

    @Override
    protected void transferStatementProperties(String string) throws SQLException {
        DB2PreparedStatement dB2PreparedStatement = (DB2PreparedStatement)this.prepStmtHandle_.getUnderlyingObject();
        this.prepStmtHandle_.setAndTransferModifiedStatementAttributes(this.modifiedStatementAttributes_);
        if (this.jccMutationEnabled_) {
            dB2PreparedStatement.enableJccDateTimeMutation(this.jccMutationEnabled_);
        }
        if (this.isClientProgramId_) {
            dB2PreparedStatement.setDB2ClientProgramId(((DB2Statement)this.physicalStatement_).getDB2ClientProgramId());
        }
        if (this.cursorName_ != null && !((DB2PreparedStatementExecutionHandler)this.prepStmtHandle_).isStaticStmt()) {
            dB2PreparedStatement.setCursorName(this.cursorName_);
        }
        this.initializeMetadataCorrelator(string);
    }

    @Override
    protected void setConnectionAndRSAttributes(ConnectionExecutionHandler connectionExecutionHandler, int n2, int n3, int n4) {
        this.db2ConnectionExecutionHandler_ = (DB2ConnectionExecutionHandler)connectionExecutionHandler;
        super.setConnectionAndRSAttributes(connectionExecutionHandler, n2, n3, n4);
    }

    public void finalize() throws Throwable {
        this.batchStatements_.clear();
        this.clearInsertProxyList();
        super.finalize();
    }

    private void addDBBatch(Object object) throws SQLException {
        ArrayList arrayList = (ArrayList)object;
        int n2 = arrayList.size();
        Object var4_4 = null;
        this.currentStates_ = this.db2ConnectionExecutionHandler_.getCurrentStates();
        for (int i10 = 0; i10 < n2; ++i10) {
            var4_4 = arrayList.get(i10);
            if (!(var4_4 instanceof Proxy)) continue;
            ExecutionHandler executionHandler = ((ProxiedDB2StatementInvocationHandler)Proxy.getInvocationHandler(var4_4)).getExecutionHandler();
            if (executionHandler instanceof DB2PreparedStatementExecutionHandler) {
                DB2PreparedStatementExecutionHandler dB2PreparedStatementExecutionHandler = (DB2PreparedStatementExecutionHandler)executionHandler;
                dB2PreparedStatementExecutionHandler.isDBBatch_ = true;
                if (dB2PreparedStatementExecutionHandler.isStaticStmt()) {
                    this.heteroBatchStaticStmtProcessing(dB2PreparedStatementExecutionHandler);
                }
                arrayList.set(i10, dB2PreparedStatementExecutionHandler.getUnderlyingPreparedStatement());
                if (this.currentStates_.getCaptureMode() != 5) continue;
                if (this.db2ConnectionExecutionHandler_.getDeferPreparesProperty() && !dB2PreparedStatementExecutionHandler.isAddBatchDone_) {
                    dB2PreparedStatementExecutionHandler.getUnderlyingPreparedStatement().getParameterMetaData();
                }
                this.heteroBatchCaptureProcessing(dB2PreparedStatementExecutionHandler);
                continue;
            }
            if (!(executionHandler instanceof JDBCDynamicExecutionHandler)) continue;
            arrayList.set(i10, executionHandler.getUnderlyingObject());
        }
        ((DB2Statement)this.physicalStatement_).addDBBatch(arrayList);
    }

    private void heteroBatchCaptureProcessing(DB2PreparedStatementExecutionHandler dB2PreparedStatementExecutionHandler) throws SQLException {
        StaticProfileCaptureHelper.checkAndGenerateSpecialRegisterSets(this.currentStates_, this.db2ConnectionExecutionHandler_, null, dB2PreparedStatementExecutionHandler.getSqlString());
        dB2PreparedStatementExecutionHandler.checkAndCaptureNonQueryStmt(false, false, 0L, 0L, 0);
        DBPreparedStatementInfoInterface dBPreparedStatementInfoInterface = ((DB2PreparedStatement)dB2PreparedStatementExecutionHandler.getUnderlyingPreparedStatement()).getDBPreparedStatementInfo();
        SqlStatementKey sqlStatementKey = SqlStatementKey.generateStmtKey(dBPreparedStatementInfoInterface.getSQLString()[0], dB2PreparedStatementExecutionHandler.resultSetType_, dB2PreparedStatementExecutionHandler.resultSetConcurrency_, dB2PreparedStatementExecutionHandler.resultSetHoldability_, dB2PreparedStatementExecutionHandler.autoGenKeyColNames_, dB2PreparedStatementExecutionHandler.autoGenKeyColIndexes_, dB2PreparedStatementExecutionHandler.autoGenKeyIndicator_, false);
        HashMap hashMap = (HashMap)this.currentStates_.getProfilerHelperInstance().getStmtDescriptorMap();
        if (!dB2PreparedStatementExecutionHandler.isStaticStmt() && (this.currentStates_.getExecutionMode() == 8 || hashMap != null && !hashMap.containsKey(sqlStatementKey))) {
            this.batchStatements_.add(sqlStatementKey);
        }
    }

    @Override
    protected void clearBatch() throws SQLException {
        SQLException sQLException = null;
        try {
            this.physicalStatement_.clearBatch();
            this.batchStatements_.clear();
            this.clearInsertProxyList();
        }
        catch (SQLException sQLException2) {
            sQLException = sQLException2;
        }
        if (this.currentStates_.getExecutionMode() == 7) {
            try {
                this.closeBatchingPreparedStmts();
            }
            catch (SQLException sQLException3) {
                if (sQLException != null) {
                    sQLException.setNextException(sQLException3);
                }
                sQLException = sQLException3;
            }
            if (this.batchingPrepStmtList_ != null) {
                this.batchingPrepStmtList_.clear();
            }
            this.firstBatchingPrepStmt_ = null;
        }
        if (sQLException != null) {
            throw sQLException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected int[] executeBatch() throws SQLException {
        Object object;
        int[] nArray = null;
        this.currentStates_ = this.db2ConnectionExecutionHandler_.getCurrentStates();
        boolean bl2 = false;
        if (PDQConnectionCallbackImpl.threadLocalContext_ != null && (object = PDQConnectionCallbackImpl.threadLocalContext_.get()) != null && !((DB2JdbcData)object).isStaticExecution_) {
            bl2 = true;
            DB2PreparedStatement dB2PreparedStatement = null;
            int n2 = 0;
            ArrayList<DB2PreparedStatement> arrayList = ((DB2JdbcData)object).getListOfHeteroBatchStmts();
            if (arrayList != null) {
                n2 = arrayList.size();
                this.isDbBatch_ = true;
            }
            for (int i10 = 0; i10 < n2; ++i10) {
                DBPreparedStatementInfoInterface dBPreparedStatementInfoInterface;
                dB2PreparedStatement = arrayList.get(i10);
                DB2PreparedStatementExecutionHandler dB2PreparedStatementExecutionHandler = new DB2PreparedStatementExecutionHandler(this.db2ConnectionExecutionHandler_, (PreparedStatement)dB2PreparedStatement, (dBPreparedStatementInfoInterface = dB2PreparedStatement.getDBPreparedStatementInfo()).getSQLString()[0], dB2PreparedStatement.getResultSetType(), dB2PreparedStatement.getResultSetConcurrency(), dB2PreparedStatement.getResultSetHoldability(), null, null, 0, null, this.methodName_, this.method_, this.args_);
                if (dB2PreparedStatementExecutionHandler.isStaticStmt()) {
                    this.heteroBatchStaticStmtProcessing(dB2PreparedStatementExecutionHandler);
                }
                if (this.currentStates_.getCaptureMode() != 5) continue;
                if (this.db2ConnectionExecutionHandler_.getDeferPreparesProperty()) {
                    dB2PreparedStatement.getParameterMetaData();
                }
                this.heteroBatchCaptureProcessing(dB2PreparedStatementExecutionHandler);
            }
        }
        if (this.currentStates_.getExecutionMode() == 8 || this.currentStates_.getExecutionMode() == 20 || this.isDbBatch_) {
            try {
                nArray = this.physicalStatement_.executeBatch();
                if (this.currentStates_.getCaptureMode() != 5) return nArray;
                if (bl2) return nArray;
                if (this.currentStates_.getStackTraceDepth() == 0) return nArray;
                if (this.currentStates_.getMaxStackTracesCaptured() == 0) return nArray;
                this.currentStates_.getProfilerHelperInstance().captureBatchingExecutionTrace(this.batchStatements_, this.currentStates_.getStackTraceDepth(), this.currentStates_.getMaxStackTracesCaptured(), this.currentStates_.getPackagePrefixArray());
                this.currentStates_.getProfilerHelperInstance().sqlStatementCaptureOrUpdate(false);
                return nArray;
            }
            finally {
                this.batchStatements_.clear();
                this.clearInsertProxyList();
            }
        }
        if (this.firstBatchingPrepStmt_ == null) return this.physicalStatement_.executeBatch();
        object = null;
        try {
            nArray = ((SQLJPreparedStatement)this.firstBatchingPrepStmt_).executeBatch(true);
        }
        catch (SQLException sQLException) {
            object = sQLException;
        }
        try {
            this.closeBatchingPreparedStmts();
            this.firstBatchingPrepStmt_ = null;
            this.prepStmtHandle_ = null;
        }
        catch (SQLException sQLException) {
            if (object == null) {
                object = sQLException;
            }
            ((SQLException)object).setNextException(sQLException);
        }
        if (this.batchingPrepStmtList_ != null) {
            this.batchingPrepStmtList_.clear();
        }
        if (object == null) return nArray;
        throw object;
    }

    private void heteroBatchStaticStmtProcessing(DB2PreparedStatementExecutionHandler dB2PreparedStatementExecutionHandler) throws SQLException {
        StaticProfileSection staticProfileSection = dB2PreparedStatementExecutionHandler.getStaticSectionForThisStmt();
        if (StaticProfileConstants.attemptStaticMRIForStatement(this.db2ConnectionExecutionHandler_, this.db2ConnectionExecutionHandler_.getDBInfo(), dB2PreparedStatementExecutionHandler.isStaticStmt(), dB2PreparedStatementExecutionHandler.getStaticSectionForThisStmt(), this.autoGenKeysRequested_) && ((DB2PreparedStatement)dB2PreparedStatementExecutionHandler.getUnderlyingPreparedStatement()).isEligibleForMultiRowInsert()) {
            staticProfileSection.setSectionNumber(staticProfileSection.getNonAtomicMRISection());
            ((DB2PreparedStatement)dB2PreparedStatementExecutionHandler.getUnderlyingPreparedStatement()).setSupportsMultiRowInsert(true);
            if (this.insertProxiesForHetroBatch_ == null) {
                this.insertProxiesForHetroBatch_ = new ArrayList();
            }
            this.insertProxiesForHetroBatch_.add(dB2PreparedStatementExecutionHandler);
        }
    }

    private void clearInsertProxyList() {
        DB2PreparedStatementExecutionHandler dB2PreparedStatementExecutionHandler2 = null;
        if (this.insertProxiesForHetroBatch_ != null && this.insertProxiesForHetroBatch_.size() > 0) {
            for (DB2PreparedStatementExecutionHandler dB2PreparedStatementExecutionHandler2 : this.insertProxiesForHetroBatch_) {
                StaticProfileSection staticProfileSection = dB2PreparedStatementExecutionHandler2.getStaticSectionForThisStmt();
                staticProfileSection.setSectionNumber(staticProfileSection.getOriginalStmtSectionNumber());
            }
            this.insertProxiesForHetroBatch_.clear();
        }
    }

    @Override
    public void close() throws SQLException {
        try {
            super.close();
        }
        finally {
            this.clearInsertProxyList();
        }
    }

    @Override
    protected void addBatch(String string) throws SQLException {
        this.db2ConnectionExecutionHandler_.checkAndSetReqInfo(this.currentStates_);
        StaticProfileCaptureHelper.checkAndGenerateSpecialRegisterSets(this.currentStates_, this.db2ConnectionExecutionHandler_, null, string);
        super.addBatch(string);
        if (this.currentStates_.getExecutionMode() == 7) {
            this.addBatchStatic(string);
        }
    }

    private void addBatchStatic(String string) throws SQLException {
        this.prepStmtHandle_ = (DB2PreparedStatementExecutionHandler)this.db2ConnectionExecutionHandler_.getPrepStmtForThisStmt(string, this.resultSetType_, this.resultSetConcurrency_, this.resultSetHoldability_, this.cursorName_, true, this.currentStates_, this.methodName_, this.method_, new Object[0]);
        this.transferStatementProperties(string);
        DB2PreparedStatementExecutionHandler dB2PreparedStatementExecutionHandler = (DB2PreparedStatementExecutionHandler)this.prepStmtHandle_;
        if (this.firstBatchingPrepStmt_ == null) {
            this.firstBatchingPrepStmt_ = dB2PreparedStatementExecutionHandler.getUnderlyingPreparedStatement();
        }
        if (dB2PreparedStatementExecutionHandler != null && dB2PreparedStatementExecutionHandler.getStaticSectionForThisStmt() == null) {
            throw ExceptionFactory.createDataSQLExceptionForOptimizer(this, Messages.getText("ERR_PROFILER_DYNAMIC_STMT_BATCHING_IN_STATIC_MODE", dB2PreparedStatementExecutionHandler.getSqlString()), null, null, 10501);
        }
        ((SQLJPreparedStatement)this.firstBatchingPrepStmt_).addBatch((SQLJPreparedStatement)dB2PreparedStatementExecutionHandler.getUnderlyingPreparedStatement());
        if (this.batchingPrepStmtList_ == null) {
            this.batchingPrepStmtList_ = new ArrayList();
        }
        this.batchingPrepStmtList_.add(this.prepStmtHandle_);
    }

    @Override
    public Statement getUnderlyingObject() {
        if (this.prepStmtHandle_ != null) {
            return this.prepStmtHandle_.getUnderlyingPreparedStatement();
        }
        return this.physicalStatement_;
    }

    @Override
    protected ResultSet getGeneratedKeysAsResultSet() throws SQLException {
        if (this.prepStmtHandle_ == null) {
            return this.physicalStatement_.getGeneratedKeys();
        }
        return (ResultSet)((DB2PreparedStatementExecutionHandler)this.prepStmtHandle_).getGeneratedKeys();
    }

    @Override
    protected StaticProfileCaptureHelper.SqlStatementInfo recordNonQueryStmt_(SqlStatementKey sqlStatementKey, String[][] stringArray, long l10, long l11, int n2) throws SQLException {
        throw new UnsupportedOperationException("method not implemented.");
    }

    @Override
    protected StaticProfileCaptureHelper.SqlStatementInfo recordQueryStmt_(SqlStatementKey sqlStatementKey, String[][] stringArray, PreparedStatement preparedStatement, ResultSet resultSet, long l10, long l11, int n2, int n3) throws SQLException {
        throw new UnsupportedOperationException("method not implemented.");
    }

    @Override
    protected StaticProfileCaptureHelper.SqlStatementInfo recordBatchedQueryStmt_(SqlStatementKey sqlStatementKey, String[][] stringArray, PreparedStatement preparedStatement) throws SQLException {
        throw new UnsupportedOperationException("method not implemented.");
    }

    @Override
    protected void recordNonQueryBatchingStmt(String string, SqlStatementType sqlStatementType) throws SQLException {
        if (this.currentStates_.getCaptureMode() == 5) {
            Object object;
            if (SqlStatementType.SET == sqlStatementType) {
                return;
            }
            String string2 = null;
            String string3 = null;
            String string4 = null;
            Matcher matcher = null;
            if (SqlStatementType.UPDATE == sqlStatementType || SqlStatementType.DELETE == sqlStatementType) {
                matcher = StaticProfileConstants.WCOPat_.matcher(string);
            }
            if (matcher != null && matcher.find()) {
                string2 = matcher.group(2);
                string4 = this.db2ConnectionExecutionHandler_.getCursorNameToSelectStmtMap().get(string2);
                object = ConnectionExecutionHandler.replacePosUpdateCursorName(string, string4);
                if (object != null) {
                    string3 = object[0];
                }
            }
            object = SqlStatementKey.generateStmtKey(string3 == null ? string : string3, this.resultSetType_, this.resultSetConcurrency_, this.resultSetHoldability_, this.autoGenKeyColNames_, this.autoGenKeyColIndexes_, this.autoGenKeyIndicator_, false);
            this.recordNonQueryBatchingStmtX(string, (SqlStatementKey)object);
        }
    }

    protected Object[] getArgs() {
        return this.args_;
    }

    protected String getMethodName() {
        return this.methodName_;
    }

    protected Method getMethod() {
        return this.method_;
    }
}

