/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal;

import com.ibm.db2.cmx.runtime.exception.ExceptionFactory;
import com.ibm.db2.cmx.runtime.internal.CentralStoreKey;
import com.ibm.db2.cmx.runtime.internal.DataProperties;
import com.ibm.db2.cmx.runtime.internal.RepositoryConnection;
import com.ibm.db2.cmx.runtime.internal.StaticProfileConstants;
import com.ibm.db2.cmx.runtime.internal.db.XmlFileHelper;
import com.ibm.db2.cmx.runtime.internal.repository.MetadataException;
import com.ibm.db2.cmx.runtime.internal.repository.api.IncrementalDataManager;
import com.ibm.db2.cmx.runtime.internal.repository.api.IncrementalSavedDataInfo;
import com.ibm.db2.cmx.runtime.internal.repository.api.MDOutputStream;
import com.ibm.db2.cmx.runtime.internal.repository.api.ManagerFactory;
import com.ibm.db2.cmx.runtime.internal.repository.api.RepositoryVersion;
import com.ibm.db2.cmx.runtime.internal.repository.api.RuntimeGroupManager;
import com.ibm.db2.cmx.runtime.internal.repository.api.SavedData;
import com.ibm.db2.cmx.runtime.internal.repository.api.SavedDataInfo;
import com.ibm.db2.cmx.runtime.internal.repository.manager.ConnectionManager;
import com.ibm.db2.cmx.runtime.internal.repository.manager.RepositorySetupManagerImpl;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.loader.dataAccess.LogEntry;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.loader.dataAccess.LogWriter;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.runtime.internal.trace.DataLogger;
import com.ibm.db2.cmx.runtime.internal.trace.Log;
import com.ibm.db2.cmx.runtime.internal.wrappers.ConnectionExecutionHandler;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class CentralStore {
    private static Map<Integer, ConnectionManager.ConnectionInfo> stateMap = new HashMap<Integer, ConnectionManager.ConnectionInfo>();
    private static Logger logger__ = Log.getClientOptimizerLogger();
    private static final Level loggingFiner_ = Level.CONFIG;
    private static final Level loggingFinest_ = Level.FINEST;
    private static Set<RuntimeGroupManager.MemberType> rPdqXml = new HashSet<RuntimeGroupManager.MemberType>(2);
    private static Set<RuntimeGroupManager.MemberType> rPdqProps = new HashSet<RuntimeGroupManager.MemberType>(2);
    private static Set<RuntimeGroupManager.MemberType> rPdqPropsXml = new HashSet<RuntimeGroupManager.MemberType>(4);
    private static String hostIp__ = null;
    public static ThreadLocal<String> repositoryPackageName_;

    private CentralStore() {
    }

    public static void processingRepositorySetTrue(String string, String string2) {
        if (logger__.isLoggable(loggingFiner_)) {
            logger__.logp(loggingFiner_, string, string2, "processingRepository_ set true\t\t<");
        }
    }

    public static void processingRepositorySetNull(String string, String string2) {
        if (logger__.isLoggable(loggingFiner_)) {
            logger__.logp(loggingFiner_, string, string2, "processingRepository_ set null\t\t>");
        }
    }

    public static void processingRepositorySet(String string, String string2, Boolean bl2) {
        if (logger__.isLoggable(loggingFiner_)) {
            logger__.logp(loggingFiner_, string, string2, "processingRepository_ set " + (bl2 == null ? "null\t\t>" : "true\t\t<"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected static void checkRecordStatus(CentralStoreKey centralStoreKey, boolean bl2) throws SQLException {
        switch (centralStoreKey.getKeyType()) {
            case FILE_SYSTEM: {
                CentralStore.chkFileExistance(centralStoreKey);
                break;
            }
            case DATASOURCE: 
            case URL: {
                Connection connection = null;
                RuntimeGroupManager runtimeGroupManager = null;
                IncrementalDataManager incrementalDataManager = null;
                connection = CentralStore.getConnection(centralStoreKey);
                if (bl2) {
                    runtimeGroupManager = ManagerFactory.getRuntimeGroupManager(connection, centralStoreKey.getRepositorySchema());
                    CentralStore.chkRepositoryRecordExistance(centralStoreKey, runtimeGroupManager);
                } else {
                    incrementalDataManager = ManagerFactory.getIncrementalDataManager(connection, centralStoreKey.getRepositorySchema());
                    CentralStore.chkRepositoryXMLRecordExistance(centralStoreKey, incrementalDataManager);
                }
                if (centralStoreKey.getConnection() == null) break;
                try {
                    centralStoreKey.closeCon();
                }
                catch (Exception exception) {}
                break;
                catch (SQLException sQLException) {
                    try {
                        centralStoreKey.addToExceptionChain(sQLException);
                        if (centralStoreKey.getConnection() == null) break;
                    }
                    catch (Throwable throwable) {
                        if (centralStoreKey.getConnection() != null) {
                            try {
                                centralStoreKey.closeCon();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                    try {
                        centralStoreKey.closeCon();
                    }
                    catch (Exception exception) {}
                    break;
                }
            }
        }
    }

    private static void chkRepositoryXMLRecordExistance(CentralStoreKey centralStoreKey, IncrementalDataManager incrementalDataManager) {
        centralStoreKey.setOutputXmlExistsForWrite(false);
        try {
            MetadataException metadataException = incrementalDataManager.canWrite(centralStoreKey.getPropertiesGroupId());
            if (metadataException != null) {
                throw metadataException;
            }
            centralStoreKey.setOutputXmlExistsForWrite(true);
            centralStoreKey.setOutputXmlLastModifiedTime(0L);
        }
        catch (Exception exception) {
            centralStoreKey.setExceptionChain(ExceptionFactory.createDataSQLExceptionForOptimizer(null, Messages.getText("ERR_CS_WRITING_XML", new Object[0]) + CentralStore.getMessageDescribingPropertyLocations(centralStoreKey), null, exception, 10914));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static InputStream fetchFromCentralStore(CentralStoreFlags var0, CentralStoreKey var1_1, Properties var2_2) throws SQLException {
        var3_3 = null;
        if (var1_1 == null) {
            throw ExceptionFactory.createDataSQLExceptionForOptimizer(null, Messages.getText("ERR_CS_PROG_LOGIC_ERR", new Object[0]) + CentralStore.getMessageDescribingPropertyLocations(var1_1), null, null, 10915);
        }
        if (var0 != CentralStoreFlags.FETCH_PROPERTIES && var0 != CentralStoreFlags.FETCH_PROPERTIES_XML_FILE && var0 != CentralStoreFlags.FETCH_XML_FILE) {
            throw ExceptionFactory.createDataSQLExceptionForOptimizer(null, Messages.getText("ERR_CS_PROG_LOGIC_ERR", new Object[0]) + CentralStore.getMessageDescribingPropertyLocations(var1_1), null, null, 10916);
        }
        var4_4 = false;
        switch (13.$SwitchMap$com$ibm$db2$cmx$runtime$internal$CentralStore$CentralStoreFlags[var0.ordinal()]) {
            case 1: {
                if (var2_2 != null) break;
                var4_4 = true;
                break;
            }
            case 2: {
                if (var2_2 != null) break;
                var4_4 = true;
            }
        }
        if (var4_4) {
            throw ExceptionFactory.createDataSQLExceptionForOptimizer(null, Messages.getText("ERR_CS_PROG_LOGIC_ERR", new Object[0]) + CentralStore.getMessageDescribingPropertyLocations(var1_1), null, null, 10917);
        }
        if (var1_1.isVariableKey() && var1_1.getKeyPart2() == "") {
            throw ExceptionFactory.createDataSQLExceptionForOptimizer(null, Messages.getText("ERR_CS_PROG_LOGIC_ERR", new Object[0]) + CentralStore.getMessageDescribingPropertyLocations(var1_1), null, null, 10918);
        }
        try {
            switch (13.$SwitchMap$com$ibm$db2$cmx$runtime$internal$CentralStoreKey$CentralStoreKeyType[var1_1.getKeyType().ordinal()]) {
                case 1: {
                    var3_3 = CentralStore.fetchFromFileSystem(var0, var1_1, var2_2);
                    ** break;
lbl24:
                    // 1 sources

                    break;
                }
                case 2: 
                case 3: {
                    var5_5 = null;
                    var6_11 = CentralStore.getConnection(var1_1);
                    var5_5 = ManagerFactory.getRuntimeGroupManager(var6_11, var1_1.getRepositorySchema());
                    var3_3 = CentralStore.fetchFromRepository(var0, var1_1, var2_2, var5_5);
                    break;
                }
                ** default:
lbl32:
                // 1 sources

                break;
            }
        }
        catch (SQLException var5_7) {
            var1_1.addToExceptionChain(var5_7);
        }
        catch (Exception var5_9) {
            var6_12 = ExceptionFactory.createDataSQLExceptionForRuntimeOnly(Messages.getText("ERR_CS_PROG_LOGIC_ERR", new Object[0]) + CentralStore.getMessageDescribingPropertyLocations(var1_1), var5_9, 10919);
            var1_1.addToExceptionChain(var6_12);
        }
        finally {
            if (var3_3 == null && var1_1.getConnection() != null) {
                try {
                    var1_1.closeCon();
                }
                catch (Exception var5_8) {}
            }
        }
        var1_1.setTempInputStreamHold(var3_3);
        CentralStore.logCentralStoreFetchResults(var1_1, var2_2);
        return var3_3;
    }

    public static BufferedWriter writeToCentralStore(CentralStoreFlags centralStoreFlags, CentralStoreKey centralStoreKey, Properties properties) throws SQLException {
        BufferedWriter bufferedWriter = null;
        if (centralStoreKey == null) {
            throw ExceptionFactory.createDataSQLExceptionForOptimizer(null, Messages.getText("ERR_CS_PROG_LOGIC_ERR", new Object[0]) + CentralStore.getMessageDescribingPropertyLocations(centralStoreKey), null, null, 10920);
        }
        CentralStoreKey.CentralStoreKeyType centralStoreKeyType = centralStoreKey.getKeyType();
        if (centralStoreKeyType == CentralStoreKey.CentralStoreKeyType.FILE_SYSTEM && centralStoreFlags != CentralStoreFlags.WRITE_PROPERTIES && centralStoreFlags != CentralStoreFlags.WRITE_PROPERTIES_XML_FILE && centralStoreFlags != CentralStoreFlags.WRITE_XML_FILE && centralStoreFlags != CentralStoreFlags.CREATE_TEMP_XML_FILE_AND_WRITE_XML && centralStoreFlags != CentralStoreFlags.DELETE_TEMP_XML_FILE && centralStoreFlags != CentralStoreFlags.DELETE_RECORD) {
            throw ExceptionFactory.createDataSQLExceptionForOptimizer(null, Messages.getText("ERR_CS_PROG_LOGIC_ERR", new Object[0]) + CentralStore.getMessageDescribingPropertyLocations(centralStoreKey), null, null, 10921);
        }
        if ((centralStoreKeyType == CentralStoreKey.CentralStoreKeyType.DATASOURCE || centralStoreKeyType == CentralStoreKey.CentralStoreKeyType.URL) && centralStoreFlags != CentralStoreFlags.WRITE_XML_FILE) {
            throw ExceptionFactory.createDataSQLExceptionForOptimizer(null, Messages.getText("ERR_CS_PROG_LOGIC_ERR", new Object[0]) + CentralStore.getMessageDescribingPropertyLocations(centralStoreKey), null, null, 10922);
        }
        boolean bl2 = false;
        switch (centralStoreFlags) {
            case WRITE_PROPERTIES: {
                if (properties != null) break;
                bl2 = true;
                break;
            }
            case WRITE_PROPERTIES_XML_FILE: {
                if (properties != null) break;
                bl2 = true;
            }
        }
        if (bl2) {
            throw ExceptionFactory.createDataSQLExceptionForOptimizer(null, Messages.getText("ERR_CS_PROG_LOGIC_ERR", new Object[0]) + CentralStore.getMessageDescribingPropertyLocations(centralStoreKey), null, null, 10923);
        }
        try {
            switch (centralStoreKeyType) {
                case FILE_SYSTEM: {
                    bufferedWriter = CentralStore.writeToFileSystem(centralStoreFlags, centralStoreKey, properties);
                    break;
                }
                case DATASOURCE: 
                case URL: {
                    IncrementalDataManager incrementalDataManager = null;
                    Connection connection = CentralStore.getConnection(centralStoreKey);
                    incrementalDataManager = ManagerFactory.getIncrementalDataManager(connection, centralStoreKey.getRepositorySchema());
                    bufferedWriter = CentralStore.writeToRepository(centralStoreFlags, centralStoreKey, properties, incrementalDataManager);
                }
            }
        }
        catch (SQLException sQLException) {
            centralStoreKey.addToExceptionChain(sQLException);
        }
        return bufferedWriter;
    }

    private static InputStream fetchFromFileSystem(CentralStoreFlags centralStoreFlags, CentralStoreKey centralStoreKey, Properties properties) throws SQLException {
        InputStream[] inputStreamArray = new InputStream[1];
        boolean bl2 = false;
        boolean bl3 = false;
        centralStoreKey.setPropertiesLastModifiedTime(0L);
        centralStoreKey.setInputXmlLastModifiedTime(0L);
        switch (centralStoreFlags) {
            case FETCH_PROPERTIES: {
                bl2 = CentralStore.fetchPropertiesFromFile(centralStoreKey, properties);
                break;
            }
            case FETCH_PROPERTIES_XML_FILE: {
                bl3 = true;
                bl2 = CentralStore.fetchPropertiesFromFile(centralStoreKey, properties);
            }
            case FETCH_XML_FILE: {
                bl3 = CentralStore.fetchXmlFromFile(centralStoreKey, inputStreamArray);
            }
        }
        if (bl2 && bl3) {
            centralStoreKey.setCentralStoreFlags(CentralStoreFlags.FETCH_PROPERTIES_XML_FILE);
        } else if (bl2) {
            centralStoreKey.setCentralStoreFlags(CentralStoreFlags.FETCH_PROPERTIES);
        } else if (bl3) {
            centralStoreKey.setCentralStoreFlags(CentralStoreFlags.FETCH_XML_FILE);
        } else {
            centralStoreKey.setCentralStoreFlags(CentralStoreFlags.FETCH_NOTHING);
        }
        return inputStreamArray[0];
    }

    private static InputStream fetchFromRepository(CentralStoreFlags centralStoreFlags, CentralStoreKey centralStoreKey, Properties properties, RuntimeGroupManager runtimeGroupManager) throws SQLException {
        InputStream inputStream = null;
        centralStoreKey.setPropertiesLastModifiedTime(0L);
        centralStoreKey.setInputXmlLastModifiedTime(0L);
        switch (centralStoreFlags) {
            case FETCH_PROPERTIES: {
                CentralStore.fetchPropertiesFromRepository(centralStoreKey, properties, runtimeGroupManager);
                break;
            }
            case FETCH_PROPERTIES_XML_FILE: {
                inputStream = CentralStore.fetchPropertiesXMLFromRepository(centralStoreKey, properties, runtimeGroupManager);
                break;
            }
            case FETCH_XML_FILE: {
                inputStream = CentralStore.fetchXmlFromRepository(centralStoreKey, runtimeGroupManager);
            }
        }
        return inputStream;
    }

    private static boolean fetchXmlFromFile(CentralStoreKey centralStoreKey, InputStream[] inputStreamArray) throws SQLException {
        SQLException sQLException;
        SQLException sQLException2;
        boolean bl2 = true;
        String string = CentralStore.generateFileNameFromKey(centralStoreKey, false, true, false, false);
        String string2 = ".xml";
        File file = new File(string);
        InputStream inputStream = null;
        try {
            inputStream = CentralStore.getFileInputStream(file);
            centralStoreKey.setInputXmlExistsForRead(true);
            centralStoreKey.setInputXmlLastModifiedTime(CentralStore.getFileLastModified(file));
        }
        catch (Exception exception) {
            bl2 = false;
            sQLException2 = ExceptionFactory.createDataSQLExceptionForOptimizer(null, Messages.getText("ERR_CS_LOAD_XML", new Object[0]) + CentralStore.getMessageDescribingPropertyLocations(centralStoreKey), null, exception, 10924);
            sQLException = centralStoreKey.getExceptionChain();
            if (sQLException == null) {
                centralStoreKey.setExceptionChain(sQLException2);
            }
            sQLException.setNextException(sQLException2);
        }
        if (!bl2 && !centralStoreKey.hasExtension()) {
            bl2 = true;
            string = CentralStore.generateFileNameFromKey(centralStoreKey, false, false, true, false);
            string2 = ".pdqxml";
            file = new File(string);
            try {
                inputStream = CentralStore.getFileInputStream(file);
                centralStoreKey.setInputXmlLastModifiedTime(CentralStore.getFileLastModified(file));
            }
            catch (Exception exception) {
                bl2 = false;
                sQLException2 = ExceptionFactory.createDataSQLExceptionForOptimizer(null, Messages.getText("ERR_CS_LOAD_XML", new Object[0]) + CentralStore.getMessageDescribingPropertyLocations(centralStoreKey), null, exception, 10925);
                sQLException = centralStoreKey.getExceptionChain();
                if (sQLException == null) {
                    centralStoreKey.setExceptionChain(sQLException2);
                }
                sQLException.setNextException(sQLException2);
            }
        }
        if (bl2) {
            if (!centralStoreKey.hasExtension() && centralStoreKey.getXmlExtensionFound() == null) {
                centralStoreKey.setXmlExtensionFound(string2);
            }
            inputStreamArray[0] = inputStream;
        }
        return bl2;
    }

    private static InputStream fetchXmlFromRepository(CentralStoreKey centralStoreKey, RuntimeGroupManager runtimeGroupManager) throws SQLException {
        InputStream inputStream = null;
        Map<RuntimeGroupManager.MemberType, SavedData> map = null;
        try {
            map = runtimeGroupManager.getData(centralStoreKey.getPropertiesGroupId(), rPdqXml);
            inputStream = map.get((Object)RuntimeGroupManager.MemberType.PDQXML).getContentStream();
            if (inputStream != null) {
                centralStoreKey.setCentralStoreFlags(CentralStoreFlags.FETCH_XML_FILE);
                SavedDataInfo savedDataInfo = map.get((Object)RuntimeGroupManager.MemberType.PDQXML).getSavedDataInfo();
                if (savedDataInfo != null) {
                    centralStoreKey.setInputXmlExistsForRead(true);
                    centralStoreKey.setInputXmlLength(savedDataInfo.getLength());
                    centralStoreKey.setInputXmlLastModifiedTime(savedDataInfo.getImportTime());
                    centralStoreKey.setGroupVersion(savedDataInfo.getGroupVersion());
                }
            }
        }
        catch (Exception exception) {
            centralStoreKey.setCentralStoreFlags(CentralStoreFlags.FETCH_NOTHING);
            SQLException sQLException = ExceptionFactory.createDataSQLExceptionForOptimizer(null, Messages.getText("ERR_CS_LOAD_XML", new Object[0]) + CentralStore.getMessageDescribingPropertyLocations(centralStoreKey), null, exception, 10926);
            SQLException sQLException2 = centralStoreKey.getExceptionChain();
            if (sQLException2 == null) {
                centralStoreKey.setExceptionChain(sQLException);
            }
            sQLException2.setNextException(sQLException);
        }
        return inputStream;
    }

    private static InputStream fetchPropertiesXMLFromRepository(CentralStoreKey centralStoreKey, Properties properties, RuntimeGroupManager runtimeGroupManager) {
        boolean bl2 = false;
        boolean bl3 = false;
        Properties properties2 = new Properties();
        InputStream inputStream = null;
        InputStream inputStream2 = null;
        Map<RuntimeGroupManager.MemberType, SavedData> map = null;
        try {
            map = runtimeGroupManager.getData(centralStoreKey.getPropertiesGroupId(), rPdqPropsXml);
            inputStream2 = map.get((Object)RuntimeGroupManager.MemberType.PDQXML).getContentStream();
            inputStream = map.get((Object)RuntimeGroupManager.MemberType.PdqProps).getContentStream();
            SavedDataInfo savedDataInfo = map.get((Object)RuntimeGroupManager.MemberType.PDQXML).getSavedDataInfo();
            SavedDataInfo savedDataInfo2 = map.get((Object)RuntimeGroupManager.MemberType.PdqProps).getSavedDataInfo();
            if (inputStream != null) {
                bl2 = true;
                if (savedDataInfo2 != null) {
                    centralStoreKey.setPropertiesExistsForRead(true);
                    centralStoreKey.setPropertiesLastModifiedTime(savedDataInfo2.getImportTime());
                    centralStoreKey.setGroupVersion(savedDataInfo2.getGroupVersion());
                }
            }
            if (inputStream2 != null) {
                bl3 = true;
                if (savedDataInfo != null) {
                    centralStoreKey.setInputXmlExistsForRead(true);
                    centralStoreKey.setInputXmlLength(savedDataInfo.getLength());
                    centralStoreKey.setInputXmlLastModifiedTime(savedDataInfo.getImportTime());
                }
            } else if (logger__.isLoggable(loggingFiner_)) {
                CentralStore.logRepositoryConnection(centralStoreKey, "xmlStream null, xmlFileInfo: " + (savedDataInfo == null ? "null" : savedDataInfo.getImportTime() + " " + savedDataInfo.getLength()), "fetchPropertiesXMLFromRepository", 5);
            }
            if (bl2) {
                Logger logger;
                properties2.load(inputStream);
                centralStoreKey.setActualLoadedProps(properties2);
                DataProperties.mergeProperties(properties, properties2);
                if (CentralStore.isOKToRefreshGlobalPropsFrom(centralStoreKey)) {
                    Log.updateLoggersIfNeeded(properties2);
                }
                if ((logger = Log.getDatabaseLogger()).isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, "CentralStore", "fetchPropertiesXMLFromRepository", "New Properties: " + properties2);
                }
            }
            if (bl2 && bl3) {
                centralStoreKey.setCentralStoreFlags(CentralStoreFlags.FETCH_PROPERTIES_XML_FILE);
            } else if (bl2) {
                centralStoreKey.setCentralStoreFlags(CentralStoreFlags.FETCH_PROPERTIES);
            } else if (bl3) {
                centralStoreKey.setCentralStoreFlags(CentralStoreFlags.FETCH_XML_FILE);
            } else {
                centralStoreKey.setCentralStoreFlags(CentralStoreFlags.FETCH_NOTHING);
            }
            return inputStream2;
        }
        catch (Exception exception) {
            bl2 = false;
            bl3 = false;
            centralStoreKey.setExceptionChain(ExceptionFactory.createDataSQLExceptionForOptimizer(null, Messages.getText("ERR_CS_LOAD_XML_PROPS", new Object[0]) + CentralStore.getMessageDescribingPropertyLocations(centralStoreKey), null, exception, 10927));
            return inputStream2;
        }
    }

    private static boolean isOKToRefreshGlobalPropsFrom(CentralStoreKey centralStoreKey) {
        String string = DataProperties.getProperty("pdq.finalRepositoryProperties");
        if (string == null) {
            return false;
        }
        if (string.equals(centralStoreKey.getDsName()) || string.equals(centralStoreKey.getUrl())) {
            String string2 = DataProperties.getProperty("pdq.propertiesGroupId");
            String string3 = centralStoreKey.getPropertiesGroupId();
            if (string2 != null && string2.equals(string3)) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static Connection getConnection(CentralStoreKey centralStoreKey) throws SQLException {
        String string = null;
        String string2 = null;
        Connection connection = null;
        DataSource dataSource = null;
        RepositoryConnection repositoryConnection = null;
        RepositoryConnection repositoryConnection2 = null;
        switch (centralStoreKey.getKeyType()) {
            case URL: {
                repositoryConnection = ConnectionExecutionHandler.processingRepository_.get();
                try {
                    if (repositoryConnection == null) {
                        repositoryConnection2 = new RepositoryConnection();
                        ConnectionExecutionHandler.processingRepository_.set(repositoryConnection2);
                    } else {
                        repositoryConnection2 = repositoryConnection;
                        ConnectionExecutionHandler connectionExecutionHandler = centralStoreKey.getRepositoryConnectionExecutionHandler();
                        if (connectionExecutionHandler != null && connectionExecutionHandler != repositoryConnection2.thisConnHandler && logger__.isLoggable(Level.FINE)) {
                            logger__.fine("[CentralStore][getConnection] Repository Connection Recursion, capture may be lost");
                        }
                    }
                    string = centralStoreKey.getUrl();
                    try {
                        connection = DriverManager.getConnection(string);
                        if (connection != null) {
                            connection.getAutoCommit();
                        }
                    }
                    catch (Exception exception) {
                        throw ExceptionFactory.createDataSQLExceptionForOptimizer(CentralStore.class, Messages.getText("ERR_CS_URL_FAILED", string) + CentralStore.getMessageDescribingPropertyLocations(centralStoreKey), null, exception, 10928);
                    }
                    if (repositoryConnection != null) return connection;
                    ConnectionExecutionHandler.processingRepository_.set(repositoryConnection);
                }
                catch (Throwable throwable) {
                    if (repositoryConnection != null) throw throwable;
                    ConnectionExecutionHandler.processingRepository_.set(repositoryConnection);
                    CentralStore.prepareConnection(centralStoreKey, string, string2, connection, repositoryConnection2);
                    throw throwable;
                }
                CentralStore.prepareConnection(centralStoreKey, string, string2, connection, repositoryConnection2);
                return connection;
            }
            case DATASOURCE: {
                repositoryConnection = ConnectionExecutionHandler.processingRepository_.get();
                try {
                    Object object;
                    if (repositoryConnection == null) {
                        repositoryConnection2 = new RepositoryConnection();
                        ConnectionExecutionHandler.processingRepository_.set(repositoryConnection2);
                    } else {
                        repositoryConnection2 = repositoryConnection;
                        object = centralStoreKey.getRepositoryConnectionExecutionHandler();
                        if (object != null && object != repositoryConnection2.thisConnHandler && logger__.isLoggable(Level.SEVERE)) {
                            logger__.severe("[CentralStore][getConnection] Repository Connection Recursion, capture may be lost");
                        }
                    }
                    string2 = centralStoreKey.getDsName();
                    if (string2 != null) {
                        object = null;
                        try {
                            object = new InitialContext();
                            dataSource = (DataSource)object.lookup(string2);
                            if (dataSource == null) throw ExceptionFactory.createDataSQLExceptionForOptimizer(CentralStore.class, Messages.getText("ERR_CS_FAILED_TO_LOOKUP_DATASOURCE", string2) + CentralStore.getMessageDescribingPropertyLocations(centralStoreKey), null, null, 10930);
                            try {
                                connection = dataSource.getConnection();
                                if (connection != null) {
                                    connection.getAutoCommit();
                                }
                            }
                            catch (Exception exception) {
                                throw ExceptionFactory.createDataSQLExceptionForOptimizer(CentralStore.class, Messages.getText("ERR_CS_DATASOURCE_FAILED", string2) + CentralStore.getMessageDescribingPropertyLocations(centralStoreKey), null, exception, 10929);
                            }
                        }
                        catch (NamingException namingException) {
                            throw ExceptionFactory.createDataSQLExceptionForOptimizer(CentralStore.class, Messages.getText("ERR_CS_FAILED_TO_LOOKUP_DATASOURCE", string2) + CentralStore.getMessageDescribingPropertyLocations(centralStoreKey), null, namingException, 10931);
                        }
                    }
                    if (repositoryConnection != null) return connection;
                    ConnectionExecutionHandler.processingRepository_.set(repositoryConnection);
                }
                catch (Throwable throwable) {
                    if (repositoryConnection != null) throw throwable;
                    ConnectionExecutionHandler.processingRepository_.set(repositoryConnection);
                    CentralStore.prepareConnection(centralStoreKey, string, string2, connection, repositoryConnection2);
                    throw throwable;
                }
                CentralStore.prepareConnection(centralStoreKey, string, string2, connection, repositoryConnection2);
                return connection;
            }
        }
        return connection;
    }

    private static void prepareConnection(CentralStoreKey centralStoreKey, String string, String string2, Connection connection, RepositoryConnection repositoryConnection) throws SQLException {
        try {
            if (connection != null) {
                centralStoreKey.setConnection(repositoryConnection.thisConnHandler, connection);
                if (logger__.isLoggable(loggingFiner_)) {
                    CentralStore.logRepositoryConnection(centralStoreKey, "Repository Connection - Get", DataLogger.getShortName(connection), 5);
                }
                ConnectionManager.prepareConnection(connection, centralStoreKey);
            }
        }
        catch (MetadataException metadataException) {
            if (string2 != null) {
                throw ExceptionFactory.createDataSQLExceptionForOptimizer(CentralStore.class, Messages.getText("ERR_CS_DATASOURCE_FAILED", string2) + CentralStore.getMessageDescribingPropertyLocations(centralStoreKey), null, metadataException, 10932);
            }
            if (string != null) {
                throw ExceptionFactory.createDataSQLExceptionForOptimizer(CentralStore.class, Messages.getText("ERR_CS_URL_FAILED", string) + CentralStore.getMessageDescribingPropertyLocations(centralStoreKey), null, metadataException, 10933);
            }
            throw ExceptionFactory.createDataSQLExceptionForOptimizer(CentralStore.class, Messages.getText("ERR_CS_PROG_LOGIC_ERR", "") + CentralStore.getMessageDescribingPropertyLocations(centralStoreKey), null, metadataException, 10934);
        }
    }

    private static BufferedWriter writeToFileSystem(CentralStoreFlags centralStoreFlags, CentralStoreKey centralStoreKey, Properties properties) {
        BufferedWriter[] bufferedWriterArray = new BufferedWriter[1];
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        centralStoreKey.setPropertiesLastModifiedTime(0L);
        centralStoreKey.setInputXmlLastModifiedTime(0L);
        centralStoreKey.setOutputXmlLastModifiedTime(0L);
        switch (centralStoreFlags) {
            case WRITE_PROPERTIES: {
                bl2 = CentralStore.writePropertiesToFile(centralStoreKey, properties);
                break;
            }
            case WRITE_PROPERTIES_XML_FILE: {
                bl3 = true;
                bl2 = CentralStore.writePropertiesToFile(centralStoreKey, properties);
            }
            case WRITE_XML_FILE: {
                bl3 = CentralStore.writeXmlToFile(centralStoreKey, bufferedWriterArray);
                break;
            }
            case CREATE_TEMP_XML_FILE_AND_WRITE_XML: {
                bl3 = CentralStore.writeXmlToTempFile(centralStoreKey, bufferedWriterArray);
                break;
            }
            case DELETE_TEMP_XML_FILE: {
                bl5 = CentralStore.deleteXmlTempFile(centralStoreKey);
                break;
            }
            case DELETE_RECORD: {
                bl4 = CentralStore.deleteFile(centralStoreKey);
            }
        }
        if (bl2 && bl3) {
            centralStoreKey.setCentralStoreFlags(CentralStoreFlags.WRITE_PROPERTIES_XML_FILE);
        } else if (bl2) {
            centralStoreKey.setCentralStoreFlags(CentralStoreFlags.WRITE_PROPERTIES);
        } else if (bl3) {
            centralStoreKey.setCentralStoreFlags(CentralStoreFlags.WRITE_XML_FILE);
        } else if (bl5) {
            centralStoreKey.setCentralStoreFlags(CentralStoreFlags.DELETE_TEMP_XML_FILE);
        } else if (bl4) {
            centralStoreKey.setCentralStoreFlags(CentralStoreFlags.DELETE_RECORD);
        } else {
            centralStoreKey.setCentralStoreFlags(CentralStoreFlags.WRITE_NOTHING);
        }
        return bufferedWriterArray[0];
    }

    private static BufferedWriter writeToRepository(CentralStoreFlags centralStoreFlags, CentralStoreKey centralStoreKey, Properties properties, IncrementalDataManager incrementalDataManager) {
        BufferedWriter[] bufferedWriterArray = new BufferedWriter[1];
        boolean bl2 = false;
        switch (centralStoreFlags) {
            case WRITE_XML_FILE: {
                bl2 = CentralStore.writeXmlToRepository(centralStoreKey, bufferedWriterArray, incrementalDataManager);
            }
        }
        if (bl2) {
            centralStoreKey.setCentralStoreFlags(CentralStoreFlags.WRITE_XML_FILE);
        } else {
            centralStoreKey.setCentralStoreFlags(CentralStoreFlags.WRITE_NOTHING);
        }
        return bufferedWriterArray[0];
    }

    private static boolean writeXmlToFile(CentralStoreKey centralStoreKey, BufferedWriter[] bufferedWriterArray) {
        try {
            String string = CentralStore.generateFileNameFromKey(centralStoreKey, false, false, true, true);
            File file = new File(string);
            bufferedWriterArray[0] = CentralStore.getFileAsBufferedWriter(file);
            centralStoreKey.setInputXmlExistsForRead(true);
            centralStoreKey.setInputXmlExistsForWrite(true);
            centralStoreKey.setInputXmlLastModifiedTime(CentralStore.getFileLastModified(file));
            centralStoreKey.setOutputXmlExistsForRead(true);
            centralStoreKey.setOutputXmlExistsForWrite(true);
            centralStoreKey.setOutputXmlLastModifiedTime(centralStoreKey.getInputXmlLastModifiedTime());
        }
        catch (Exception exception) {
            SQLException sQLException = centralStoreKey.getExceptionChain();
            SQLException sQLException2 = ExceptionFactory.createDataSQLExceptionForOptimizer(null, Messages.getText("ERR_CS_WRITING_XML", new Object[0]) + CentralStore.getMessageDescribingPropertyLocations(centralStoreKey), null, exception, 10935);
            if (sQLException == null) {
                centralStoreKey.setExceptionChain(sQLException2);
            } else {
                sQLException.setNextException(sQLException2);
            }
            return false;
        }
        if (!centralStoreKey.hasExtension()) {
            centralStoreKey.setXmlExtensionFound(".pdqxml");
        }
        return true;
    }

    public static void updateKeyOutputXmlInfo(CentralStoreKey centralStoreKey) {
        if (centralStoreKey != null && centralStoreKey.getTempMDOutputStream() != null) {
            MDOutputStream mDOutputStream = centralStoreKey.getTempMDOutputStream();
            IncrementalSavedDataInfo incrementalSavedDataInfo = mDOutputStream.getDataInfo();
            if (incrementalSavedDataInfo != null) {
                centralStoreKey.setOutputXmlLength(incrementalSavedDataInfo.getLength());
                centralStoreKey.setOutputXmlLastModifiedTime(incrementalSavedDataInfo.getUpdateTime());
                centralStoreKey.setRepositoryFileInfoKey(incrementalSavedDataInfo.getKey());
            } else {
                centralStoreKey.setOutputXmlLength(0L);
                centralStoreKey.setOutputXmlLastModifiedTime(System.currentTimeMillis());
            }
            CentralStore.logCentralStoreWriteResults(centralStoreKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean writeXmlToRepository(CentralStoreKey centralStoreKey, BufferedWriter[] bufferedWriterArray, IncrementalDataManager incrementalDataManager) {
        boolean bl2;
        block15: {
            MDOutputStream mDOutputStream = null;
            bufferedWriterArray[0] = null;
            try {
                int n2 = centralStoreKey.getRepositoryFileInfoKey();
                mDOutputStream = n2 == 0 ? incrementalDataManager.add(centralStoreKey.getPropertiesGroupId(), "") : incrementalDataManager.replace(centralStoreKey.getPropertiesGroupId(), "", n2);
                if (mDOutputStream != null) {
                    centralStoreKey.setTempMDOutputStream(mDOutputStream);
                    bufferedWriterArray[0] = new BufferedWriter(new OutputStreamWriter((OutputStream)mDOutputStream, "UTF-8"));
                }
                bl2 = true;
                if (mDOutputStream == null) break block15;
                centralStoreKey.setTempMDOutputStream(mDOutputStream);
            }
            catch (Exception exception) {
                boolean bl3;
                block16: {
                    try {
                        CentralStore.addExceptionToChain(centralStoreKey, exception);
                        bl3 = false;
                        if (mDOutputStream == null) break block16;
                        centralStoreKey.setTempMDOutputStream(mDOutputStream);
                    }
                    catch (Throwable throwable) {
                        if (mDOutputStream != null) {
                            centralStoreKey.setTempMDOutputStream(mDOutputStream);
                            if (bufferedWriterArray[0] == null) {
                                try {
                                    bufferedWriterArray[0] = new BufferedWriter(new OutputStreamWriter((OutputStream)mDOutputStream, "UTF-8"));
                                }
                                catch (UnsupportedEncodingException unsupportedEncodingException) {
                                    CentralStore.addExceptionToChain(centralStoreKey, unsupportedEncodingException);
                                    return false;
                                }
                            }
                        }
                        throw throwable;
                    }
                    if (bufferedWriterArray[0] == null) {
                        try {
                            bufferedWriterArray[0] = new BufferedWriter(new OutputStreamWriter((OutputStream)mDOutputStream, "UTF-8"));
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            CentralStore.addExceptionToChain(centralStoreKey, unsupportedEncodingException);
                            return false;
                        }
                    }
                }
                return bl3;
            }
            if (bufferedWriterArray[0] == null) {
                try {
                    bufferedWriterArray[0] = new BufferedWriter(new OutputStreamWriter((OutputStream)mDOutputStream, "UTF-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    CentralStore.addExceptionToChain(centralStoreKey, unsupportedEncodingException);
                    return false;
                }
            }
        }
        return bl2;
    }

    private static void addExceptionToChain(CentralStoreKey centralStoreKey, Exception exception) {
        SQLException sQLException = centralStoreKey.getExceptionChain();
        SQLException sQLException2 = ExceptionFactory.createDataSQLExceptionForOptimizer(null, Messages.getText("ERR_CS_WRITING_XML", new Object[0]) + CentralStore.getMessageDescribingPropertyLocations(centralStoreKey), null, exception, 10936);
        if (sQLException == null) {
            centralStoreKey.setExceptionChain(sQLException2);
        } else {
            sQLException.setNextException(sQLException2);
        }
    }

    private static boolean writeXmlToTempFile(CentralStoreKey centralStoreKey, BufferedWriter[] bufferedWriterArray) {
        String string = CentralStore.combineFileNamePart1AndPart2(centralStoreKey) + "_tmp";
        File file = new File(string);
        String string2 = file.getParent();
        if (string2 != null) {
            string = file.getName();
            file = new File(string2);
        } else {
            file = null;
        }
        String string3 = "." + (centralStoreKey.hasExtension() ? centralStoreKey.getKeyExtension() : "pdqxml");
        try {
            File file2 = CentralStore.createTempFile(string, string3, file);
            file2.deleteOnExit();
            bufferedWriterArray[0] = CentralStore.getFileAsBufferedWriter(file2);
            centralStoreKey.setTempFile(file2);
            CentralStoreKey centralStoreKey2 = new CentralStoreKey(file2.getAbsolutePath(), null, false, null);
            centralStoreKey.setFileName(centralStoreKey2.getFileName());
            centralStoreKey.setKeyExtension(centralStoreKey2.getKeyExtension());
            centralStoreKey.setPropertiesGroupId(centralStoreKey2.getPropertiesGroupId());
            centralStoreKey.setRepositorySchema(centralStoreKey2.getRepositorySchema());
            centralStoreKey.setRecordKeyPart2(centralStoreKey2.getRecordKeyPart2());
            centralStoreKey.setInputXmlExistsForRead(true);
            centralStoreKey.setInputXmlExistsForWrite(true);
            centralStoreKey.setInputXmlLastModifiedTime(CentralStore.getFileLastModified(file2));
            centralStoreKey.setOutputXmlExistsForRead(true);
            centralStoreKey.setOutputXmlExistsForWrite(true);
            centralStoreKey.setOutputXmlLastModifiedTime(centralStoreKey.getInputXmlLastModifiedTime());
        }
        catch (Exception exception) {
            SQLException sQLException = ExceptionFactory.createDataSQLExceptionForOptimizer(null, Messages.getText("ERR_CS_WRITING_XML", new Object[0]) + CentralStore.getMessageDescribingPropertyLocations(centralStoreKey), null, exception, 10937);
            centralStoreKey.setExceptionChain(sQLException);
            return false;
        }
        return true;
    }

    private static boolean deleteXmlTempFile(CentralStoreKey centralStoreKey) {
        File file = centralStoreKey.getTempFile();
        if (file == null) {
            SQLException sQLException = ExceptionFactory.createDataSQLExceptionForOptimizer(null, Messages.getText("ERR_CS_PROG_LOGIC_ERR", new Object[0]) + CentralStore.getMessageDescribingPropertyLocations(centralStoreKey), null, null, 10938);
            centralStoreKey.setExceptionChain(sQLException);
            return false;
        }
        try {
            if (!CentralStore.deleteTempFile(file)) {
                centralStoreKey.setExceptionChain(ExceptionFactory.createDataSQLExceptionForOptimizer(null, Messages.getText("ERR_CS_DELETE_TEMP", centralStoreKey.toString()), null, null, 10939));
                return false;
            }
            centralStoreKey.setTempFile(null);
            centralStoreKey.setInputXmlExistsForRead(false);
            centralStoreKey.setInputXmlExistsForWrite(false);
            centralStoreKey.setInputXmlLastModifiedTime(0L);
            centralStoreKey.setOutputXmlExistsForRead(false);
            centralStoreKey.setOutputXmlExistsForWrite(false);
            centralStoreKey.setOutputXmlLastModifiedTime(0L);
        }
        catch (Exception exception) {
            SQLException sQLException = ExceptionFactory.createDataSQLExceptionForOptimizer(null, Messages.getText("ERR_CS_DELETE_TEMP", centralStoreKey.toString()), null, exception, 10940);
            centralStoreKey.setExceptionChain(sQLException);
            return false;
        }
        return true;
    }

    private static boolean deleteFile(CentralStoreKey centralStoreKey) {
        try {
            File file = new File(CentralStore.generateFileNameFromKey(centralStoreKey, false, false, false, false));
            if (!CentralStore.deleteTempFile(file)) {
                centralStoreKey.setExceptionChain(ExceptionFactory.createDataSQLExceptionForOptimizer(null, Messages.getText("ERR_CS_DELETE_RECORD", centralStoreKey.toString()) + CentralStore.getMessageDescribingPropertyLocations(centralStoreKey), null, null, 10941));
                return false;
            }
        }
        catch (Exception exception) {
            SQLException sQLException = ExceptionFactory.createDataSQLExceptionForOptimizer(null, Messages.getText("ERR_CS_DELETE_RECORD", centralStoreKey.toString()) + CentralStore.getMessageDescribingPropertyLocations(centralStoreKey), null, exception, 10942);
            centralStoreKey.setExceptionChain(sQLException);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean writePropertiesToFile(CentralStoreKey centralStoreKey, Properties properties) {
        OutputStream outputStream = null;
        try {
            String string = CentralStore.generateFileNameFromKey(centralStoreKey, true, false, false, false);
            File file = new File(string);
            outputStream = CentralStore.getFileOutputStream(file);
            properties.store(outputStream, "");
            centralStoreKey.setPropertiesExistsForRead(true);
            centralStoreKey.setPropertiesExistsForWrite(true);
            centralStoreKey.setPropertiesLastModifiedTime(CentralStore.getFileLastModified(file));
            boolean bl2 = true;
            return bl2;
        }
        catch (Exception exception) {
            centralStoreKey.setExceptionChain(ExceptionFactory.createDataSQLExceptionForOptimizer(null, Messages.getText("ERR_CS_PROG_LOGIC_ERR", new Object[0]) + CentralStore.getMessageDescribingPropertyLocations(centralStoreKey), null, exception, 10943));
            boolean bl3 = false;
            return bl3;
        }
        finally {
            if (null != outputStream) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static String generateFileNameFromKey(CentralStoreKey centralStoreKey, boolean bl2, boolean bl3, boolean bl4, boolean bl5) throws SQLException {
        String string = null;
        string = centralStoreKey.hasExtension() ? CentralStore.combineFileNamePart1AndPart2(centralStoreKey) + "." + centralStoreKey.getKeyExtension() : ((bl3 || bl4) && centralStoreKey.getXmlExtensionFound() != null ? CentralStore.combineFileNamePart1AndPart2(centralStoreKey) + centralStoreKey.getXmlExtensionFound() : (bl2 ? CentralStore.combineFileNamePart1AndPart2(centralStoreKey) + ".properties" : (bl3 ? CentralStore.combineFileNamePart1AndPart2(centralStoreKey) + ".xml" : (bl4 ? CentralStore.combineFileNamePart1AndPart2(centralStoreKey) + ".pdqxml" : CentralStore.combineFileNamePart1AndPart2(centralStoreKey)))));
        return string;
    }

    private static String combineFileNamePart1AndPart2(CentralStoreKey centralStoreKey) {
        String string = centralStoreKey.getKeyPart2();
        if (string == null || string.length() == 0) {
            return centralStoreKey.getKeyPart1();
        }
        return centralStoreKey.getKeyPart1() + centralStoreKey.getKeyPart2();
    }

    private static PrivilegedExceptionAction<InputStream> getFileAsInputStreamPriv(final File file) {
        return new PrivilegedExceptionAction<InputStream>(){

            @Override
            public InputStream run() throws IOException {
                return CentralStore.getFileInputStreamLocked(file);
            }
        };
    }

    private static InputStream getFileInputStream(File file) throws PrivilegedActionException, IOException {
        InputStream inputStream = null;
        inputStream = DataProperties.runningUnderSecurityManager_ ? AccessController.doPrivileged(CentralStore.getFileAsInputStreamPriv(file)) : CentralStore.getFileInputStreamLocked(file);
        return inputStream;
    }

    private static final InputStream getFileInputStreamLocked(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        fileInputStream.getChannel().lock(0L, Long.MAX_VALUE, true);
        return new BufferedInputStream(fileInputStream);
    }

    private static PrivilegedExceptionAction<Long> getFileLastModifiedPriv(final File file) {
        return new PrivilegedExceptionAction<Long>(){

            @Override
            public Long run() throws FileNotFoundException {
                return file.lastModified();
            }
        };
    }

    private static long getFileLastModified(File file) {
        long l10 = 0L;
        try {
            l10 = DataProperties.runningUnderSecurityManager_ ? AccessController.doPrivileged(CentralStore.getFileLastModifiedPriv(file)).longValue() : file.lastModified();
        }
        catch (Exception exception) {
            return 0L;
        }
        return l10;
    }

    private static PrivilegedExceptionAction<Long> getFileLengthPriv(final File file) {
        return new PrivilegedExceptionAction<Long>(){

            @Override
            public Long run() throws FileNotFoundException {
                return file.length();
            }
        };
    }

    private static long getFileLength(File file) {
        long l10 = 0L;
        if (DataProperties.runningUnderSecurityManager_) {
            try {
                l10 = AccessController.doPrivileged(CentralStore.getFileLengthPriv(file));
            }
            catch (PrivilegedActionException privilegedActionException) {}
        } else {
            l10 = file.length();
        }
        return l10;
    }

    private static OutputStream getFileOutputStream(File file) throws PrivilegedActionException, IOException {
        OutputStream outputStream = null;
        outputStream = DataProperties.runningUnderSecurityManager_ ? (OutputStream)AccessController.doPrivileged(CentralStore.getFileAsBufferedOutputStreamPriv(file)) : new BufferedOutputStream(new FileOutputStream(file));
        return outputStream;
    }

    private static PrivilegedExceptionAction<BufferedOutputStream> getFileAsBufferedOutputStreamPriv(final File file) {
        return new PrivilegedExceptionAction<BufferedOutputStream>(){

            @Override
            public BufferedOutputStream run() throws FileNotFoundException {
                return new BufferedOutputStream(new FileOutputStream(file));
            }
        };
    }

    private static File createTempFile(String string, String string2, File file) throws PrivilegedActionException, IOException {
        File file2 = null;
        file2 = DataProperties.runningUnderSecurityManager_ ? AccessController.doPrivileged(CentralStore.createTempFilePriv(string, string2, file)) : File.createTempFile(string, string2, file);
        return file2;
    }

    private static PrivilegedExceptionAction<File> createTempFilePriv(final String string, final String string2, final File file) {
        return new PrivilegedExceptionAction<File>(){

            @Override
            public File run() throws IOException {
                return File.createTempFile(string, string2, file);
            }
        };
    }

    private static BufferedWriter getFileAsBufferedWriter(File file) throws PrivilegedActionException, IOException {
        if (DataProperties.runningUnderSecurityManager_) {
            return AccessController.doPrivileged(CentralStore.getFileAsBufferedWriterPriv(file));
        }
        return CentralStore.getFileAsBufferedWriterLocked(file);
    }

    private static final BufferedWriter getFileAsBufferedWriterLocked(File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file, false);
        fileOutputStream.getChannel().lock();
        return new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8"));
    }

    private static final PrivilegedExceptionAction<BufferedWriter> getFileAsBufferedWriterPriv(final File file) {
        return new PrivilegedExceptionAction<BufferedWriter>(){

            @Override
            public BufferedWriter run() throws IOException {
                return CentralStore.getFileAsBufferedWriterLocked(file);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean fetchPropertiesFromFile(CentralStoreKey centralStoreKey, Properties properties) {
        boolean bl2 = true;
        InputStream inputStream = null;
        Properties properties2 = new Properties();
        try {
            Object object;
            try {
                object = new File(CentralStore.generateFileNameFromKey(centralStoreKey, true, false, false, false));
                inputStream = CentralStore.getFileInputStream((File)object);
                properties2.load(inputStream);
                centralStoreKey.setPropertiesExistsForRead(true);
                centralStoreKey.setPropertiesLastModifiedTime(CentralStore.getFileLastModified((File)object));
            }
            catch (Exception exception) {
                bl2 = false;
                centralStoreKey.setExceptionChain(ExceptionFactory.createDataSQLExceptionForOptimizer(null, Messages.getText("ERR_CS_LOAD_PROPS", new Object[0]) + CentralStore.getMessageDescribingPropertyLocations(centralStoreKey), null, exception, 10945));
            }
            if (bl2) {
                Logger logger;
                DataProperties.mergeProperties(properties, properties2);
                centralStoreKey.setActualLoadedProps(properties2);
                object = DataProperties.getGlobalCentralStoreKey();
                if (object != null && ((CentralStoreKey)object).equals(centralStoreKey)) {
                    Log.updateLoggersIfNeeded(properties2);
                }
                if ((logger = Log.getDatabaseLogger()).isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, "CentralStore", "fetchPropertiesFromFile", "New Properties: " + properties2);
                }
            }
            boolean bl3 = bl2;
            return bl3;
        }
        finally {
            if (null != inputStream) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void fetchPropertiesFromRepository(CentralStoreKey centralStoreKey, Properties properties, RuntimeGroupManager runtimeGroupManager) {
        Properties properties2 = new Properties();
        InputStream inputStream = null;
        Map<RuntimeGroupManager.MemberType, SavedData> map = null;
        try {
            Logger logger;
            Object object;
            try {
                map = runtimeGroupManager.getData(centralStoreKey.getPropertiesGroupId(), rPdqProps);
                inputStream = map.get((Object)RuntimeGroupManager.MemberType.PdqProps).getContentStream();
                object = map.get((Object)RuntimeGroupManager.MemberType.PdqProps).getSavedDataInfo();
                if (inputStream != null) {
                    centralStoreKey.setCentralStoreFlags(CentralStoreFlags.FETCH_PROPERTIES);
                    properties2.load(inputStream);
                    if (object != null) {
                        centralStoreKey.setPropertiesExistsForRead(true);
                        centralStoreKey.setPropertiesLastModifiedTime(object.getImportTime());
                        centralStoreKey.setGroupVersion(object.getGroupVersion());
                    }
                }
            }
            catch (Exception exception) {
                centralStoreKey.setCentralStoreFlags(CentralStoreFlags.FETCH_NOTHING);
                centralStoreKey.setExceptionChain(ExceptionFactory.createDataSQLExceptionForOptimizer(null, Messages.getText("ERR_CS_LOAD_PROPS", new Object[0]) + CentralStore.getMessageDescribingPropertyLocations(centralStoreKey), null, exception, 10946));
                if (null != inputStream) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return;
            }
            DataProperties.mergeProperties(properties, properties2);
            centralStoreKey.setActualLoadedProps(properties2);
            object = DataProperties.getGlobalCentralStoreKey();
            if (object != null && ((CentralStoreKey)object).equals(centralStoreKey)) {
                Log.updateLoggersIfNeeded(properties2);
            }
            if ((logger = Log.getDatabaseLogger()).isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, "CentralStore", "fetchPropertiesFromRepository", "New Properties: " + properties2);
            }
            return;
        }
        finally {
            if (null != inputStream) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static boolean deleteTempFile(File file) {
        if (DataProperties.runningUnderSecurityManager_) {
            return AccessController.doPrivileged(CentralStore.deleteTempFileSM(file));
        }
        return CentralStore.deleteTempFileNoSM(file);
    }

    private static boolean deleteTempFileNoSM(File file) {
        return file.delete();
    }

    private static final PrivilegedAction<Boolean> deleteTempFileSM(final File file) {
        return new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return CentralStore.deleteTempFileNoSM(file);
            }
        };
    }

    private static void chkFileExistance(CentralStoreKey centralStoreKey) throws SQLException {
        File file = null;
        boolean bl2 = true;
        boolean bl3 = true;
        if (centralStoreKey.hasExtension()) {
            if (centralStoreKey.getKeyExtension().equalsIgnoreCase("properties")) {
                bl3 = false;
            } else {
                bl2 = false;
            }
            file = new File(CentralStore.generateFileNameFromKey(centralStoreKey, false, false, false, false));
            CentralStore.doFileChecks(centralStoreKey, file, bl2, bl3);
            return;
        }
        file = new File(CentralStore.generateFileNameFromKey(centralStoreKey, true, false, false, false));
        CentralStore.doFileChecks(centralStoreKey, file, true, bl3);
        file = new File(CentralStore.generateFileNameFromKey(centralStoreKey, false, true, false, false));
        String string = ".xml";
        CentralStore.doFileChecks(centralStoreKey, file, false, bl3);
        if (!centralStoreKey.isInputXmlExists()) {
            file = new File(CentralStore.generateFileNameFromKey(centralStoreKey, false, false, true, false));
            CentralStore.doFileChecks(centralStoreKey, file, false, bl3);
            string = ".pdqxml";
        }
        if (!centralStoreKey.hasExtension() && centralStoreKey.isInputXmlExists()) {
            centralStoreKey.setXmlExtensionFound(string);
        }
    }

    private static void chkRepositoryRecordExistance(CentralStoreKey centralStoreKey, RuntimeGroupManager runtimeGroupManager) throws SQLException {
        Map<RuntimeGroupManager.MemberType, SavedDataInfo> map = null;
        centralStoreKey.setPropertiesExistsForRead(false);
        centralStoreKey.setInputXmlExistsForRead(false);
        try {
            map = runtimeGroupManager.getSavedDataInfo(centralStoreKey.getPropertiesGroupId(), rPdqPropsXml);
            SavedDataInfo savedDataInfo = map.get((Object)RuntimeGroupManager.MemberType.PdqProps);
            if (savedDataInfo != null) {
                centralStoreKey.setPropertiesExistsForRead(true);
                centralStoreKey.setPropertiesLastModifiedTime(savedDataInfo.getImportTime());
                centralStoreKey.setGroupVersion(savedDataInfo.getGroupVersion());
            }
            if ((savedDataInfo = map.get((Object)RuntimeGroupManager.MemberType.PDQXML)) != null) {
                centralStoreKey.setInputXmlExistsForRead(true);
                centralStoreKey.setInputXmlLastModifiedTime(savedDataInfo.getImportTime());
            }
        }
        catch (Exception exception) {
            centralStoreKey.setExceptionChain(ExceptionFactory.createDataSQLExceptionForOptimizer(null, Messages.getText("ERR_CS_LOAD_PROPS", new Object[0]) + CentralStore.getMessageDescribingPropertyLocations(centralStoreKey), null, exception, 10947));
        }
    }

    private static void doFileChecks(CentralStoreKey centralStoreKey, File file, boolean bl2, boolean bl3) {
        boolean bl4 = false;
        boolean bl5 = false;
        long l10 = 0L;
        if (CentralStore.fileExists(file)) {
            if (!CentralStore.isDirectory(file)) {
                bl4 = CentralStore.canRead(file);
                bl5 = CentralStore.canWrite(file);
            }
            l10 = CentralStore.getFileLastModified(file);
        }
        if (bl2) {
            centralStoreKey.setPropertiesExistsForRead(bl4);
            centralStoreKey.setPropertiesExistsForWrite(bl5);
            centralStoreKey.setPropertiesLastModifiedTime(l10);
        } else if (bl3) {
            centralStoreKey.setInputXmlLength(CentralStore.getFileLength(file));
            centralStoreKey.setInputXmlExistsForRead(bl4);
            centralStoreKey.setInputXmlExistsForWrite(bl5);
            centralStoreKey.setInputXmlLastModifiedTime(l10);
            centralStoreKey.setOutputXmlLength(CentralStore.getFileLength(file));
            centralStoreKey.setOutputXmlExistsForRead(bl4);
            centralStoreKey.setOutputXmlExistsForWrite(bl5);
            centralStoreKey.setOutputXmlLastModifiedTime(l10);
        }
    }

    private static boolean fileExists(File file) {
        try {
            if (DataProperties.runningUnderSecurityManager_) {
                return AccessController.doPrivileged(CentralStore.doesFileExistPriv(file));
            }
            return file.exists();
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static boolean isDirectory(File file) {
        try {
            if (DataProperties.runningUnderSecurityManager_) {
                return AccessController.doPrivileged(CentralStore.isFileDirectoryPriv(file));
            }
            return file.isDirectory();
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static boolean canRead(File file) {
        try {
            if (DataProperties.runningUnderSecurityManager_) {
                return AccessController.doPrivileged(CentralStore.canReadFilePriv(file));
            }
            return file.canRead();
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static boolean canWrite(File file) {
        try {
            if (DataProperties.runningUnderSecurityManager_) {
                return AccessController.doPrivileged(CentralStore.canWriteFilePriv(file));
            }
            return file.canWrite();
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static StackTraceElement[] getStackTrace(Thread thread) {
        if (DataProperties.runningUnderSecurityManager_) {
            return AccessController.doPrivileged(CentralStore.getStackTracePriv(thread));
        }
        return thread.getStackTrace();
    }

    static final PrivilegedAction<StackTraceElement[]> getStackTracePriv(final Thread thread) {
        return new PrivilegedAction<StackTraceElement[]>(){

            @Override
            public StackTraceElement[] run() {
                return thread.getStackTrace();
            }
        };
    }

    static final PrivilegedAction<Boolean> doesFileExistPriv(final File file) {
        return new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return file.exists();
            }
        };
    }

    static final PrivilegedAction<Boolean> isFileDirectoryPriv(final File file) {
        return new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return file.isDirectory();
            }
        };
    }

    static final PrivilegedAction<Boolean> canReadFilePriv(final File file) {
        return new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return file.canRead();
            }
        };
    }

    static final PrivilegedAction<Boolean> canWriteFilePriv(final File file) {
        return new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return file.canWrite();
            }
        };
    }

    public static void logCentralStoreFetchResults(CentralStoreKey centralStoreKey, Properties properties) {
        if (logger__ == null) {
            return;
        }
        if (centralStoreKey.getExceptionChain() != null && logger__.isLoggable(loggingFinest_)) {
            logger__.logp(loggingFinest_, DataLogger.getShortName(CentralStore.class), "logCentralStoreFetchResults", "CENTRAL STORE WARNING: Central store fetch failed for central store key: " + centralStoreKey + ". Central store processing trapped the following: " + centralStoreKey.getExceptionChain() + ". Message: " + centralStoreKey.getExceptionChain().getMessage() + ", cause: " + centralStoreKey.getExceptionChain().getCause(), centralStoreKey.getExceptionChain());
            return;
        }
        if (logger__.isLoggable(Level.CONFIG)) {
            GregorianCalendar gregorianCalendar;
            String string = "[Thread:" + Thread.currentThread().getName() + "][fetchFromCentralStore] ";
            CentralStoreFlags centralStoreFlags = centralStoreKey.getCentralStoreFlags();
            GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
            gregorianCalendar2.setTime(new Date(centralStoreKey.getLastCheckedTime()));
            if (centralStoreFlags == CentralStoreFlags.FETCH_PROPERTIES || centralStoreFlags == CentralStoreFlags.FETCH_PROPERTIES_XML_FILE) {
                gregorianCalendar = new GregorianCalendar();
                gregorianCalendar.setTime(new Date(centralStoreKey.getPropertiesLastModifiedTime()));
                logger__.logp(Level.CONFIG, DataLogger.getShortName(CentralStore.class), "logCentralStoreFetchResults", string + "Properties fetched from central store key: " + centralStoreKey + ". Properties are: " + StaticProfileConstants.maskJdbcURLPasswords(properties) + ".\n  Properties last modified: " + XmlFileHelper.getXMLTimeStampString(gregorianCalendar) + ". " + (centralStoreKey.getGroupVersion() == null ? "" : "Properties groupVersion: " + centralStoreKey.getGroupVersion()));
            }
            if (centralStoreFlags == CentralStoreFlags.FETCH_XML_FILE || centralStoreFlags == CentralStoreFlags.FETCH_PROPERTIES_XML_FILE) {
                gregorianCalendar = new GregorianCalendar();
                gregorianCalendar.setTime(new Date(centralStoreKey.getInputXmlLastModifiedTime()));
                logger__.logp(Level.CONFIG, DataLogger.getShortName(CentralStore.class), "logCentralStoreFetchResults", string + "XML fetched from central store key: " + centralStoreKey + ".  XML last modified: " + XmlFileHelper.getXMLTimeStampString(gregorianCalendar) + ". " + (centralStoreKey.getInputXmlLength() <= 0L ? "" : "Xml length: " + centralStoreKey.getInputXmlLength() + "."));
            }
        }
    }

    public static void logCentralStoreWriteResults(CentralStoreKey centralStoreKey) {
        if (logger__ == null) {
            return;
        }
        if (centralStoreKey.getExceptionChain() != null && logger__.isLoggable(loggingFinest_)) {
            logger__.logp(loggingFinest_, DataLogger.getShortName(CentralStore.class), "logCentralStoreFetchResults", "CENTRAL STORE WARNING: Central store write failed for central store key: " + centralStoreKey + ". Central store processing trapped the following: " + centralStoreKey.getExceptionChain() + ". Message: " + centralStoreKey.getExceptionChain().getMessage() + ", cause: " + centralStoreKey.getExceptionChain().getCause(), centralStoreKey.getExceptionChain());
            return;
        }
        if (logger__.isLoggable(Level.CONFIG)) {
            GregorianCalendar gregorianCalendar;
            String string = "[Thread:" + Thread.currentThread().getName() + "][writeToCentralStore] ";
            CentralStoreFlags centralStoreFlags = centralStoreKey.getCentralStoreFlags();
            GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
            gregorianCalendar2.setTime(new Date(centralStoreKey.getLastCheckedTime()));
            if (centralStoreFlags == CentralStoreFlags.WRITE_XML_FILE || centralStoreFlags == CentralStoreFlags.WRITE_PROPERTIES_XML_FILE) {
                gregorianCalendar = new GregorianCalendar();
                gregorianCalendar.setTime(new Date(centralStoreKey.getOutputXmlLastModifiedTime()));
                logger__.logp(Level.CONFIG, DataLogger.getShortName(CentralStore.class), "logCentralStoreWriteResults", string + "XML written to central store key: " + centralStoreKey + ". InfoKey: " + centralStoreKey.getRepositoryFileInfoKey() + ".  XML last modified: " + XmlFileHelper.getXMLTimeStampString(gregorianCalendar) + ". " + (centralStoreKey.getOutputXmlLength() <= 0L ? "" : "Xml length: " + centralStoreKey.getOutputXmlLength() + "."));
            }
            if (centralStoreFlags == CentralStoreFlags.DELETE_TEMP_XML_FILE) {
                gregorianCalendar = new GregorianCalendar();
                gregorianCalendar.setTime(new Date(centralStoreKey.getOutputXmlLastModifiedTime()));
                logger__.logp(Level.CONFIG, DataLogger.getShortName(CentralStore.class), "logCentralStoreWriteResults", string + "Temporary XML file deleted for central store key: " + centralStoreKey + ".");
            }
        }
    }

    public static void logRepositoryConnectionClose(Connection connection, CentralStoreKey centralStoreKey, int n2) {
        if (logger__.isLoggable(loggingFiner_)) {
            CentralStore.logRepositoryConnection(centralStoreKey, "Repository Connection - Close", DataLogger.getShortName(connection), n2);
        }
    }

    public static String formatStackTrace(int n2) {
        Thread thread = Thread.currentThread();
        String string = DataProperties.getProperty("pdq.stackTraceDepth");
        int n3 = 0;
        try {
            n3 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            n3 = Integer.parseInt("10");
        }
        if (n3 < 0) {
            n3 = Integer.parseInt("10");
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" Stack Trace: ");
        if (n3 > 0) {
            n3 += n2;
            StackTraceElement[] stackTraceElementArray = CentralStore.getStackTrace(thread);
            int n4 = stackTraceElementArray.length;
            if (n2 >= n4) {
                n3 -= n2;
                n2 = 0;
            }
            if (n3 > n4) {
                n3 = n4;
            }
            String string2 = null;
            for (int i10 = n2; i10 < n3; ++i10) {
                string2 = stackTraceElementArray[i10].toString();
                if (string2.startsWith("com.ibm.db2.cmx.")) {
                    int n5 = string2.indexOf(40);
                    if (n5 == -1) {
                        stringBuilder.append(string2);
                    } else {
                        int n6 = string2.lastIndexOf(46, n5);
                        if (n6 == -1) {
                            stringBuilder.append(string2);
                        } else {
                            stringBuilder.append(string2.substring(n6 + 1, string2.length()));
                        }
                    }
                } else {
                    stringBuilder.append(string2);
                }
                stringBuilder.append(", ");
            }
        }
        return stringBuilder.toString();
    }

    public static boolean willLogRepositoryConnection() {
        return logger__.isLoggable(loggingFiner_);
    }

    public static void logRepositoryConnection(Object object, String string, String string2, int n2) {
        try {
            if (logger__.isLoggable(loggingFiner_)) {
                if (loggingFiner_ != Level.FINER) {
                    logger__.logp(loggingFiner_, "", "", "[Thread:" + Thread.currentThread().getName() + "] " + DataLogger.getShortName(object) + " " + string + " " + string2 + " " + CentralStore.formatStackTrace(n2));
                } else {
                    logger__.logp(loggingFiner_, "[Thread:" + Thread.currentThread().getName() + "] " + DataLogger.getShortName(object), string, string2 + CentralStore.formatStackTrace(n2));
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static boolean willLogRepositoryConnectionAtLevel(Level level) {
        return logger__.isLoggable(level);
    }

    public static void logRepositoryConnectionAtLevel(Level level, Object object, String string, String string2, int n2) {
        try {
            if (logger__.isLoggable(level)) {
                if (level != Level.FINER) {
                    logger__.logp(level, "", "", "[Thread:" + Thread.currentThread().getName() + "] " + DataLogger.getShortName(object) + " " + string + " " + string2 + " " + CentralStore.formatStackTrace(n2));
                } else {
                    logger__.logp(level, "[Thread:" + Thread.currentThread().getName() + "] " + DataLogger.getShortName(object), string, string2 + CentralStore.formatStackTrace(n2));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String getMessageDescribingPropertyLocations(CentralStoreKey centralStoreKey) {
        return DataProperties.getMessageDescribingPropertyLocations(centralStoreKey, null, false, "  ");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void logToRepository(CentralStoreKey centralStoreKey, List<LogRecord> list) throws Exception {
        switch (centralStoreKey.getKeyType()) {
            case FILE_SYSTEM: {
                return;
            }
            case DATASOURCE: 
            case URL: {
                Connection connection = null;
                try {
                    connection = CentralStore.getConnection(centralStoreKey);
                    LogWriter logWriter = LogWriter.getInstance();
                    String string = CentralStore.getHostIp();
                    int n2 = list.size();
                    if (n2 > 1) {
                        ArrayList<LogEntry> arrayList = new ArrayList<LogEntry>();
                        for (LogRecord logRecord : list) {
                            LogEntry logEntry = new LogEntry(logRecord, centralStoreKey.getPropertiesGroupId(), centralStoreKey.getGroupVersion(), string);
                            arrayList.add(logEntry);
                        }
                        logWriter.insertAll(connection, arrayList);
                    } else {
                        LogRecord logRecord = list.get(0);
                        String string2 = null;
                        Throwable throwable = logRecord.getThrown();
                        if (throwable != null) {
                            string2 = CentralStore.getStackTrace(throwable);
                        }
                        logWriter.createLog(connection, centralStoreKey.getPropertiesGroupId(), centralStoreKey.getGroupVersion(), string, new Timestamp(logRecord.getMillis()), logRecord.getMessage(), logRecord.getLevel().getName(), Log.getRandomJVMID(string), string2);
                    }
                    connection.commit();
                    if (connection == null) return;
                }
                catch (Exception exception) {
                    try {
                        try {
                            connection.rollback();
                        }
                        catch (Exception exception2) {
                            // empty catch block
                        }
                        Log.getGlobalLogger().logp(Level.CONFIG, "LogInserter", "consumeLogQueue", "An error prevented inserting logs to the repository: " + exception.getMessage(), exception);
                        throw exception;
                    }
                    catch (Throwable throwable) {
                        if (connection == null) throw throwable;
                        try {
                            centralStoreKey.closeCon();
                            throw throwable;
                        }
                        catch (Exception exception3) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
                try {
                    centralStoreKey.closeCon();
                    return;
                }
                catch (Exception exception) {
                    return;
                }
            }
        }
    }

    private static String getHostIp() {
        if (hostIp__ == null) {
            InetAddress inetAddress = null;
            try {
                inetAddress = InetAddress.getLocalHost();
                hostIp__ = inetAddress.toString();
            }
            catch (UnknownHostException unknownHostException) {
                hostIp__ = "unknown";
            }
        }
        return hostIp__;
    }

    public static RepositoryVersion getRepositoryVersion(CentralStoreKey centralStoreKey) throws Exception {
        RepositoryVersion repositoryVersion = centralStoreKey.getRepositoryVersion();
        if (repositoryVersion != null) {
            return repositoryVersion;
        }
        switch (centralStoreKey.getKeyType()) {
            case FILE_SYSTEM: {
                break;
            }
            case DATASOURCE: 
            case URL: {
                Connection connection = null;
                try {
                    RepositoryVersion repositoryVersion2;
                    connection = CentralStore.getConnection(centralStoreKey);
                    RepositorySetupManagerImpl repositorySetupManagerImpl = new RepositorySetupManagerImpl(connection);
                    RepositoryVersion repositoryVersion3 = repositoryVersion2 = repositorySetupManagerImpl.getRepositoryVersion(centralStoreKey.getRepositorySchema());
                    return repositoryVersion3;
                }
                catch (Exception exception) {
                    Log.getGlobalLogger().logp(Level.CONFIG, "CentralStore", "getRepositoryVersion", "An error prevented getting repository version: " + exception.getMessage(), exception);
                    throw exception;
                }
                finally {
                    if (connection != null) {
                        try {
                            centralStoreKey.closeCon();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        }
        return repositoryVersion;
    }

    private static String getStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        do {
            throwable.printStackTrace(printWriter);
        } while ((throwable = throwable.getCause()) != null);
        return stringWriter.toString();
    }

    static {
        rPdqProps.add(RuntimeGroupManager.MemberType.PdqProps);
        rPdqXml.add(RuntimeGroupManager.MemberType.PDQXML);
        rPdqPropsXml.add(RuntimeGroupManager.MemberType.PdqProps);
        rPdqPropsXml.add(RuntimeGroupManager.MemberType.PDQXML);
        repositoryPackageName_ = new ThreadLocal();
    }

    public static enum CentralStoreFlags {
        FETCH_NOTHING,
        FETCH_PROPERTIES,
        FETCH_XML_FILE,
        FETCH_PROPERTIES_XML_FILE,
        WRITE_NOTHING,
        WRITE_PROPERTIES,
        WRITE_XML_FILE,
        WRITE_PROPERTIES_XML_FILE,
        CREATE_TEMP_XML_FILE_AND_WRITE_XML,
        DELETE_TEMP_XML_FILE,
        DELETE_RECORD;

    }
}

