/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.FWHelper;
import com.ibm.mq.MQException;
import com.ibm.mq.MQInternalCommunications;
import com.ibm.mq.PeerName;
import com.ibm.mq.SSLCRLHelper;
import com.ibm.mqservices.MQInternalException;
import com.ibm.mqservices.Trace;
import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.Principal;
import java.util.Collection;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.security.cert.X509Certificate;

public class SSLHelper
implements HandshakeCompletedListener {
    public static final String CLSNAME = "SSLHelper";
    private static final String sccsid = "@(#) javabase/com/ibm/mq/SSLHelper.java, java, j5306, j5306-11-050701 1.16.2.3 05/05/09 11:59:40";
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5648-C60 (c) Copyright IBM Corp. 2002   All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    X509Certificate serverCert = null;
    boolean certSet = false;
    static X509Certificate[] certs;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Socket createSSLSocket(String string, int n, String string2, String string3, Collection collection, Object object, MQInternalCommunications mQInternalCommunications) throws MQException {
        SSLSocket sSLSocket;
        try {
            try {
                if (Trace.isOn()) {
                    Trace.entry(CLSNAME, "createSSLSocket");
                    Trace.trace(CLSNAME, "peername = '" + string3 + "'");
                    Trace.trace(CLSNAME, "certStores = " + collection);
                    Trace.trace(CLSNAME, "sslSocketFactory = " + object);
                }
                SSLSocketFactory sSLSocketFactory = SSLHelper.chooseSocketFactory(object);
                if (Trace.isOn()) {
                    Trace.trace(CLSNAME, "creating SSL socket");
                }
                SSLSocket sSLSocket2 = SSLHelper.createSSLSocketInstance(string, n, sSLSocketFactory, false, null, 0);
                mQInternalCommunications.channelDefinition.sslPeerName = SSLHelper.configureSSLSocket(sSLSocket2, string2, string3, collection);
                sSLSocket = sSLSocket2;
                Object var11_11 = null;
            }
            catch (BindException bindException) {
                throw new MQException(2, 2059, "static method in SSL code", 54, string);
            }
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            if (!Trace.isOn()) throw throwable;
            Trace.exit(CLSNAME, "createSSLSocket");
            throw throwable;
        }
        if (!Trace.isOn()) return sSLSocket;
        Trace.exit(CLSNAME, "createSSLSocket");
        return sSLSocket;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SSLSocket createSSLSocket(String string, int n, String string2, String string3, Collection collection, Object object, Socket socket, boolean bl, boolean bl2) throws MQException {
        SSLSocket sSLSocket;
        try {
            SSLSocket sSLSocket2;
            if (Trace.isOn()) {
                Trace.entry(CLSNAME, "createSSLSocket");
                Trace.trace(CLSNAME, "peername = '" + string3 + "'");
                Trace.trace(CLSNAME, "certStores = " + collection);
                Trace.trace(CLSNAME, "sslSocketFactory = " + object);
                Trace.trace(CLSNAME, "clientAuth = " + bl);
                Trace.trace(CLSNAME, "asServer = " + bl2);
            }
            SSLSocketFactory sSLSocketFactory = SSLHelper.chooseSocketFactory(object);
            if (Trace.isOn()) {
                Trace.trace(CLSNAME, "creating SSL socket from non-SSL one");
            }
            try {
                sSLSocket2 = (SSLSocket)sSLSocketFactory.createSocket(socket, string, n, false);
            }
            catch (IOException iOException) {
                MQException mQException = new MQException(2, 2397, (Object)"static method in SSL code", 71);
                mQException.initCause(iOException);
                throw mQException;
            }
            sSLSocket2.setNeedClientAuth(bl);
            sSLSocket2.setUseClientMode(!bl2);
            SSLHelper.configureSSLSocket(sSLSocket2, string2, string3, collection);
            sSLSocket = sSLSocket2;
            Object var14_14 = null;
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            if (!Trace.isOn()) throw throwable;
            Trace.exit(CLSNAME, "createSSLSocket");
            throw throwable;
        }
        if (!Trace.isOn()) return sSLSocket;
        Trace.exit(CLSNAME, "createSSLSocket");
        return sSLSocket;
    }

    static Socket createExplicitSSLSocket(String string, int n, String string2, String string3, Collection collection, Object object, MQInternalCommunications mQInternalCommunications, InetAddress inetAddress, int n2, int n3, int n4) throws MQException {
        if (Trace.isOn()) {
            Trace.entry(CLSNAME, "createExplicitSSLSocket");
        }
        int n5 = 0;
        SSLSocketFactory sSLSocketFactory = SSLHelper.chooseSocketFactory(object);
        while (n5 <= n3 - n2) {
            try {
                if (Trace.isOn()) {
                    Trace.trace(2, CLSNAME, "Try to create SSL socket bound locally to " + inetAddress + ", port " + n4);
                }
                FWHelper.debug("Try to create SSL socket bound locally to " + inetAddress + ", port " + n4);
                SSLSocket sSLSocket = SSLHelper.createSSLSocketInstance(string, n, sSLSocketFactory, true, inetAddress, n4);
                if (sSLSocket != null) {
                    String string4 = "SSLSocket created OK: " + inetAddress + ", local port " + sSLSocket.getLocalPort();
                    if (Trace.isOn()) {
                        Trace.trace(2, CLSNAME, string4);
                    }
                    FWHelper.debug(string4);
                    mQInternalCommunications.channelDefinition.sslPeerName = SSLHelper.configureSSLSocket(sSLSocket, string2, string3, collection);
                } else {
                    String string5 = "SSLSocket create failed - null returned.";
                    if (Trace.isOn()) {
                        Trace.trace(2, CLSNAME, string5);
                    }
                }
                if (Trace.isOn()) {
                    Trace.exit(CLSNAME, "createExplicitSSLSocket (success)");
                }
                return sSLSocket;
            }
            catch (BindException bindException) {
                if (Trace.isOn()) {
                    Trace.trace(2, CLSNAME, "Socket created failed due to bind exception (see below): " + inetAddress + ", port " + n4);
                }
                if (Trace.isOn()) {
                    Trace.trace(2, CLSNAME, "BindException: " + bindException.getMessage());
                }
                FWHelper.debug("BindException: " + inetAddress + ", port " + n4);
                ++n5;
                if (++n4 <= n3) continue;
                n4 = n2;
            }
        }
        FWHelper.debug("Failed to create socket matching firewall properties.");
        MQInternalException mQInternalException = new MQInternalException(2, 2059, 125);
        if (Trace.isOn()) {
            Trace.exit(CLSNAME, "createExplicitSSLSocket (failed)");
        }
        throw mQInternalException;
    }

    private static SSLSocketFactory chooseSocketFactory(Object object) throws MQException {
        SSLSocketFactory sSLSocketFactory;
        if (object == null) {
            if (Trace.isOn()) {
                Trace.trace(CLSNAME, "using default SSLSocketFactory");
            }
            sSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        } else if (object instanceof SSLSocketFactory) {
            if (Trace.isOn()) {
                Trace.trace(CLSNAME, "using supplied SSLSocketFactory");
            }
            sSLSocketFactory = (SSLSocketFactory)object;
        } else {
            throw new MQException(2, 2046, Thread.currentThread(), 120, "sslSocketFactory");
        }
        return sSLSocketFactory;
    }

    private static SSLSocket createSSLSocketInstance(String string, int n, SSLSocketFactory sSLSocketFactory, boolean bl, InetAddress inetAddress, int n2) throws MQException, BindException {
        SSLSocket sSLSocket = null;
        try {
            sSLSocket = !bl ? (SSLSocket)sSLSocketFactory.createSocket(string, n) : (SSLSocket)sSLSocketFactory.createSocket(string, n, inetAddress, n2);
        }
        catch (SSLProtocolException sSLProtocolException) {
            MQException mQException = new MQException(2, 2397, (Object)"static method in SSL code", 52);
            mQException.initCause(sSLProtocolException);
            throw mQException;
        }
        catch (SSLException sSLException) {
            MQException mQException = new MQException(2, 2397, "static method in SSL code.");
            mQException.initCause(sSLException);
            throw mQException;
        }
        catch (UnknownHostException unknownHostException) {
            throw new MQException(2, 2059, "static method in SSL code", 53, string);
        }
        catch (BindException bindException) {
            if (bl) {
                throw bindException;
            }
            throw new MQException(2, 2059, "static method in SSL code", 54, string);
        }
        catch (IOException iOException) {
            throw new MQException(2, 2059, "static method in SSL code", 54, string);
        }
        return sSLSocket;
    }

    private static String configureSSLSocket(SSLSocket sSLSocket, String string, String string2, Collection collection) throws MQException {
        if (Trace.isOn()) {
            Trace.trace(CLSNAME, "setting enabled cipher suites to '" + string + "'");
        }
        String[] stringArray = new String[]{string};
        try {
            sSLSocket.setEnabledCipherSuites(stringArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new MQException(2, 2400, (Object)"static method in SSL code", 52);
        }
        SSLHelper sSLHelper = new SSLHelper();
        sSLSocket.addHandshakeCompletedListener(sSLHelper);
        if (Trace.isOn()) {
            Trace.trace(CLSNAME, "calling startHandshake");
        }
        try {
            sSLSocket.startHandshake();
        }
        catch (SSLException sSLException) {
            MQException mQException = new MQException(2, 2397, (Object)"static method in SSL code", 98);
            mQException.initCause(sSLException);
            throw mQException;
        }
        catch (IOException iOException) {
            MQException mQException = new MQException(2, 2397, (Object)"static method in SSL code", 71);
            mQException.initCause(iOException);
            throw mQException;
        }
        X509Certificate x509Certificate = sSLHelper.getServerCert();
        Principal principal = x509Certificate.getSubjectDN();
        String string3 = principal.getName();
        if (string2 != null && !string2.equals("")) {
            PeerName peerName;
            PeerName peerName2;
            if (Trace.isOn()) {
                Trace.trace(CLSNAME, "checking peername");
            }
            if ((peerName2 = new PeerName(string2, true)).isMatchingPeerName(peerName = new PeerName(string3, false))) {
                if (Trace.isOn()) {
                    Trace.trace(CLSNAME, "peerName matches");
                }
            } else {
                if (Trace.isOn()) {
                    Trace.trace(CLSNAME, "peerName " + peerName2.getDN() + " doesn't match " + peerName.getDN());
                }
                try {
                    sSLSocket.close();
                }
                catch (IOException iOException) {
                    throw new MQException(2, 2059, (Object)"static method in SSL code", 54);
                }
                throw new MQException(2, 2398, "static method in SSL code", 121, peerName2.getDN(), peerName.getDN());
            }
        }
        if (collection != null) {
            SSLCRLHelper.check(certs[0], collection);
        }
        return string3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handshakeCompleted(HandshakeCompletedEvent handshakeCompletedEvent) {
        try {
            block9: {
                try {
                    if (Trace.isOn()) {
                        Trace.entry(this, "handshakeCompleted");
                        Trace.trace(this, "event: " + handshakeCompletedEvent);
                    }
                    if ((certs = handshakeCompletedEvent.getPeerCertificateChain()) != null && certs.length > 0) {
                        this.setServerCert(certs[0]);
                        String string = certs[0].getIssuerDN().getName();
                        if (Trace.isOn()) {
                            Trace.trace(CLSNAME, "Remote peer name = " + certs[0].getSubjectDN());
                            Trace.trace(CLSNAME, "Remote issuer    = " + certs[0].getIssuerDN());
                        }
                        break block9;
                    }
                    if (Trace.isOn()) {
                        Trace.trace(this, "no peer certificates");
                    }
                    this.setServerCert(null);
                }
                catch (Exception exception) {
                    if (Trace.isOn()) {
                        Trace.trace(this, "problem: " + exception);
                    }
                    Object var4_5 = null;
                    if (!Trace.isOn()) return;
                    Trace.exit(this, "handshakeCompleted");
                    return;
                }
            }
            Object var4_4 = null;
            if (!Trace.isOn()) return;
            Trace.exit(this, "handshakeCompleted");
            return;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            if (!Trace.isOn()) throw throwable;
            Trace.exit(this, "handshakeCompleted");
            throw throwable;
        }
    }

    private synchronized void setServerCert(X509Certificate x509Certificate) {
        this.serverCert = x509Certificate;
        this.certSet = true;
        this.notifyAll();
    }

    private synchronized X509Certificate getServerCert() {
        while (!this.certSet) {
            try {
                this.wait(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.serverCert;
    }
}

