/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.MQException;
import com.ibm.mqservices.Trace;
import java.util.Vector;

public class PeerName {
    private static final String copyrightNotice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. 2002. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "javabase/com/ibm/mq/PeerName.java, java, j5306, j5306-11-050701 04/03/31 12:16:22 @(#) 1.10.5.2";
    private String originalName = null;
    String CN = null;
    String T = null;
    String O = null;
    String L = null;
    String ST = null;
    String C = null;
    Vector OU = new Vector();
    boolean matcher;
    private static final int DNCLEAR = 1;
    private static final int DNSYMBOL = 2;
    private static final int DNVALUE = 3;
    private static final int DNQVALUE = 4;
    private static final int DNFINISHED = 5;

    public PeerName(String string, boolean bl) throws MQException {
        this.originalName = string;
        this.matcher = bl;
        this.parseDN(string);
    }

    public String getDN() {
        return this.originalName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseDN(String string) throws MQException {
        int n = 1;
        String string2 = "";
        String string3 = "";
        if (Trace.isOn()) {
            Trace.entry(this, "parseDN(" + string + ")");
        }
        if (string != null && string.equals("")) {
            n = 5;
        }
        try {
            try {
                int n2 = 0;
                while (n2 < string.length()) {
                    char c = string.charAt(n2);
                    if (n == 1) {
                        if (c == '\"' || c == ',' || c == ';' || c == '=') {
                            throw new MQException(2, 2399, this);
                        }
                        if (c != ' ' && c != '\t') {
                            string2 = string2 + c;
                            n = 2;
                        }
                    } else if (n == 2) {
                        if (c == ' ' || c == '\"') {
                            throw new MQException(2, 2399, this);
                        }
                        if (c == '=') {
                            string3 = "";
                            if (n2 + 1 >= string.length()) {
                                n = 3;
                            } else if (string.charAt(n2 + 1) == '\"') {
                                ++n2;
                                n = 4;
                            } else {
                                n = 3;
                            }
                        } else {
                            string2 = string2 + c;
                        }
                    } else if (n == 3) {
                        if (!(c != ',' && c != ';' || n2 != 0 && string.charAt(n2 - 1) == '\\')) {
                            n = 1;
                            this.setValue(string2, string3.trim());
                            string2 = "";
                        } else {
                            string3 = string3 + c;
                        }
                    } else if (n == 4) {
                        if (c == '\"' && (n2 == 0 || string.charAt(n2 - 1) != '\\')) {
                            n = 5;
                            this.setValue(string2, string3);
                            string2 = "";
                        } else {
                            string3 = string3 + c;
                        }
                    } else if (n == 5) {
                        if (c == ',' || c == ';') {
                            n = 1;
                        } else if (c != ' ' && c != '\t') {
                            throw new MQException(2, 2399, this);
                        }
                    }
                    ++n2;
                }
                if (n == 3) {
                    this.setValue(string2, string3.trim());
                }
                if (n == 2 || n == 1) {
                    throw new MQException(2, 2399, this);
                }
                Object var9_7 = null;
            }
            catch (MQException mQException) {
                if (!Trace.isOn()) throw mQException;
                Trace.trace(this, "Exception in parser: " + mQException);
                throw mQException;
            }
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            if (!Trace.isOn()) throw throwable;
            Trace.exit(this, "parseDN");
            throw throwable;
        }
        if (!Trace.isOn()) return;
        Trace.exit(this, "parseDN");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setValue(String string, String string2) throws MQException {
        String string3 = string.toUpperCase();
        if (Trace.isOn()) {
            Trace.trace(this, "PeerName setting " + string + " term to " + string2);
        }
        if (string3.equals("CN")) {
            if (this.CN != null) throw new MQException(2, 2399, this);
            this.CN = string2.toUpperCase();
            return;
        } else if (string3.equals("T")) {
            if (this.T != null) throw new MQException(2, 2399, this);
            this.T = string2.toUpperCase();
            return;
        } else if (string3.equals("O")) {
            if (this.O != null) throw new MQException(2, 2399, this);
            this.O = string2.toUpperCase();
            return;
        } else if (string3.equals("L")) {
            if (this.L != null) throw new MQException(2, 2399, this);
            this.L = string2.toUpperCase();
            return;
        } else if (string3.equals("ST") || string3.equals("SP") || string3.equals("S")) {
            if (this.ST != null) throw new MQException(2, 2399, this);
            this.ST = string2.toUpperCase();
            return;
        } else if (string3.equals("C")) {
            if (this.C != null) throw new MQException(2, 2399, this);
            this.C = string2.toUpperCase();
            return;
        } else if (string3.equals("OU")) {
            this.OU.add(string2.toUpperCase());
            return;
        } else {
            if (!this.matcher) return;
            throw new MQException(2, 2399, this);
        }
    }

    public boolean isMatchingPeerName(PeerName peerName) {
        if (Trace.isOn()) {
            Trace.entry(this, "isMatchingPeerName");
            Trace.trace(this, "Comparing \"" + this.getDN() + "\" with \"" + peerName.getDN() + "\"");
        }
        boolean bl = true;
        if (this.CN != null && !this.wequals(this.CN, peerName.CN)) {
            bl = false;
        }
        if (this.T != null && !this.wequals(this.T, peerName.T)) {
            bl = false;
        }
        if (this.O != null && !this.wequals(this.O, peerName.O)) {
            bl = false;
        }
        if (this.L != null && !this.wequals(this.L, peerName.L)) {
            bl = false;
        }
        if (this.ST != null && !this.wequals(this.ST, peerName.ST)) {
            bl = false;
        }
        if (this.C != null && !this.wequals(this.C, peerName.C)) {
            bl = false;
        }
        if (this.OU.size() > peerName.OU.size()) {
            bl = false;
        } else {
            int n = 0;
            while (n < this.OU.size()) {
                if (!this.wequals((String)this.OU.elementAt(n), (String)peerName.OU.elementAt(n))) {
                    bl = false;
                }
                ++n;
            }
        }
        if (Trace.isOn()) {
            Trace.exit(this, "isMatchingPeerName");
        }
        return bl;
    }

    public boolean wequals(String string, String string2) {
        if (Trace.isOn()) {
            Trace.trace(this, "wequals(\"" + string + "\",\"" + string2 + "\"");
        }
        if (string2 == null) {
            return string == null && string.length() != 0;
        }
        String string3 = string2.toUpperCase();
        if (string.equals("*")) {
            return true;
        }
        if (string.charAt(0) == '*') {
            if (string.charAt(string.length() - 1) == '*') {
                return string3.indexOf(string3.substring(1, string.length() - 2)) != -1;
            }
            return string3.endsWith(string.substring(1));
        }
        if (string.charAt(string.length() - 1) == '*' && string.charAt(string.length() - 2) != '\\') {
            return string3.startsWith(string.substring(0, string.length() - 1));
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        while (n < stringBuffer.length()) {
            if (stringBuffer.charAt(n) == '\\') {
                stringBuffer.deleteCharAt(n);
            }
            ++n;
        }
        String string4 = stringBuffer.toString();
        StringBuffer stringBuffer2 = new StringBuffer(string3);
        int n2 = 0;
        while (n2 < stringBuffer2.length()) {
            if (stringBuffer2.charAt(n2) == '\\') {
                stringBuffer2.deleteCharAt(n2);
            }
            ++n2;
        }
        String string5 = stringBuffer2.toString();
        if (Trace.isOn()) {
            Trace.trace(this, "Comparing " + string4);
        }
        if (Trace.isOn()) {
            Trace.trace(this, "     with " + string5);
        }
        return string4.equals(string5);
    }
}

