/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.BatchMatchingCriteria;
import com.ibm.mq.MQException;
import com.ibm.mq.MQGetMessageOptions;
import com.ibm.mq.MQMsg2;
import com.ibm.mqservices.MQInternalException;
import com.ibm.mqservices.Trace;
import java.util.Vector;

class MessageBufferManager {
    private static final String sccsid = "javabase/com/ibm/mq/MessageBufferManager.java, java, j5306, j5306-11-050701 04/01/16 13:18:05 @(#) 1.2.5.3";
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5639-B43 (c) Copyright IBM Corp. 1997, 1999, 2001   All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Vector bufferedMsgs = null;
    private BatchMatchingCriteria bufferCriteria = null;
    private BatchMatchingCriteria testCriteria = null;

    protected MessageBufferManager() {
        Trace.entry(this, "MessageBufferManager (constructor)");
        Trace.trace(2, this, sccsid);
        Trace.exit(this, "MessageBufferManager (constructor)");
    }

    protected void purgeBuffer(int n, int n2) {
        if (this.bufferedMsgs != null && this.bufferCriteria.hcon == n && this.bufferCriteria.hobj == n2 && !this.bufferedMsgs.isEmpty()) {
            this.bufferedMsgs.clear();
        }
    }

    protected void purgeAllBuffers() {
        if (this.bufferedMsgs != null) {
            this.bufferedMsgs.clear();
        }
    }

    protected boolean bufferExists(int n, int n2, MQMsg2 mQMsg2, MQGetMessageOptions mQGetMessageOptions) {
        Trace.entry(this, "bufferExists");
        boolean bl = false;
        if (this.bufferedMsgs != null && !this.bufferedMsgs.isEmpty()) {
            if (this.testCriteria == null) {
                this.testCriteria = new BatchMatchingCriteria();
            }
            this.testCriteria.set(n, n2, mQMsg2, mQGetMessageOptions);
            bl = this.testCriteria.matches(this.bufferCriteria);
        }
        Trace.exit(this, "bufferExists");
        return bl;
    }

    protected void bufferMessage(byte[] byArray, BatchMatchingCriteria batchMatchingCriteria) throws MQException {
        Trace.entry(this, "bufferMessage");
        if (this.testCriteria == null) {
            this.testCriteria = new BatchMatchingCriteria();
        }
        if (this.bufferCriteria == null) {
            this.bufferCriteria = new BatchMatchingCriteria();
        }
        if (this.bufferedMsgs == null) {
            this.bufferedMsgs = new Vector();
        }
        if (this.bufferedMsgs.isEmpty()) {
            this.bufferCriteria.set(batchMatchingCriteria);
        } else {
            this.testCriteria.set(batchMatchingCriteria);
            if (!this.bufferCriteria.matches(this.testCriteria)) {
                Trace.exit(this, "bufferMessage (via exception");
                throw new MQInternalException(2, 2195, 117, "inconsistent buffering");
            }
        }
        this.bufferedMsgs.addElement(byArray);
        Trace.exit(this, "bufferMessage");
    }

    protected byte[] getBufferedMessage(int n, int n2, MQMsg2 mQMsg2, MQGetMessageOptions mQGetMessageOptions) throws MQException {
        Trace.entry(this, "getBufferedMessage");
        if (this.bufferedMsgs == null || this.bufferedMsgs.isEmpty() || !this.bufferExists(n, n2, mQMsg2, mQGetMessageOptions)) {
            Trace.exit(this, "getBufferedMessage via exception");
            throw new MQInternalException(2, 2195, 117, "Batched buffer underflow");
        }
        byte[] byArray = (byte[])this.bufferedMsgs.firstElement();
        this.bufferedMsgs.remove(0);
        Trace.exit(this, "getBufferedMessage");
        return byArray;
    }

    protected boolean canCreateNewBuffer() {
        return this.bufferedMsgs == null || this.bufferedMsgs.isEmpty();
    }
}

