/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.MQConnectionRequestInfo;
import com.ibm.mq.MQManagedConnectionFactory;
import com.ibm.mq.MQManagedConnectionJ11;
import com.ibm.mq.StoredManagedConnection;
import com.ibm.mqservices.Trace;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.resource.spi.ConnectionRequestInfo;

class ManagedConnectionStore {
    private static final String sccsid = "@(#) javabase/com/ibm/mq/ManagedConnectionStore.java, java, j5306, j5306-11-050701  03/12/11 10:39:53";
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5648-C60 (c) Copyright IBM Corp. 1996, 1999    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    Hashtable store = new Hashtable();

    ManagedConnectionStore() {
    }

    void register(StoredManagedConnection storedManagedConnection) {
        Vector<StoredManagedConnection> vector;
        Trace.entry(this, "register");
        Object object = storedManagedConnection.cxReqInf;
        if (storedManagedConnection.cxReqInf instanceof MQConnectionRequestInfo) {
            object = ((MQConnectionRequestInfo)storedManagedConnection.cxReqInf).getKeyObject();
        }
        Tuple tuple = new Tuple(storedManagedConnection.mqMcf, object);
        Hashtable hashtable = this.store;
        synchronized (hashtable) {
            vector = (Vector<StoredManagedConnection>)this.store.get(tuple);
            if (vector == null) {
                vector = new Vector<StoredManagedConnection>();
                this.store.put(tuple, vector);
            }
        }
        vector.insertElementAt(storedManagedConnection, 0);
        Trace.exit(this, "register");
    }

    void deregister(StoredManagedConnection storedManagedConnection) {
        Tuple tuple;
        Vector vector;
        Trace.entry(this, "deregister");
        Object object = storedManagedConnection.cxReqInf;
        if (storedManagedConnection.cxReqInf instanceof MQConnectionRequestInfo) {
            object = ((MQConnectionRequestInfo)storedManagedConnection.cxReqInf).getKeyObject();
        }
        if ((vector = (Vector)this.store.get(tuple = new Tuple(storedManagedConnection.mqMcf, object))) != null) {
            vector.removeElement(storedManagedConnection);
        }
        Trace.exit(this, "deregister");
    }

    StoredManagedConnection chooseOne(MQManagedConnectionFactory mQManagedConnectionFactory, ConnectionRequestInfo connectionRequestInfo) {
        Trace.entry(this, "chooseOne");
        Object object = connectionRequestInfo;
        if (connectionRequestInfo instanceof MQConnectionRequestInfo) {
            object = ((MQConnectionRequestInfo)connectionRequestInfo).getKeyObject();
        }
        Tuple tuple = new Tuple(mQManagedConnectionFactory, object);
        StoredManagedConnection storedManagedConnection = null;
        boolean bl = false;
        Vector vector = (Vector)this.store.get(tuple);
        if (vector != null) {
            vector = (Vector)vector.clone();
            Enumeration enumeration = vector.elements();
            while (!bl && enumeration.hasMoreElements()) {
                storedManagedConnection = (StoredManagedConnection)enumeration.nextElement();
                if (storedManagedConnection.mqManCon == null) {
                    return null;
                }
                MQManagedConnectionJ11 mQManagedConnectionJ11 = storedManagedConnection.mqManCon;
                synchronized (mQManagedConnectionJ11) {
                    if (connectionRequestInfo instanceof MQConnectionRequestInfo) {
                        if (((MQConnectionRequestInfo)connectionRequestInfo).variableIsSuitable(storedManagedConnection.mqManCon)) {
                            bl = storedManagedConnection.use();
                        }
                    } else {
                        bl = storedManagedConnection.use();
                    }
                }
            }
        }
        Trace.exit(this, "chooseOne");
        if (bl && storedManagedConnection != null) {
            return storedManagedConnection;
        }
        return null;
    }

    private class Tuple {
        Object o1;
        Object o2;

        Tuple(Object object, Object object2) {
            this.o1 = object;
            this.o2 = object2;
        }

        public boolean equals(Object object) {
            Tuple tuple = (Tuple)object;
            return this.o1.equals(tuple.o1) && this.o2.equals(tuple.o2);
        }

        public int hashCode() {
            return 13 * this.o1.hashCode() + 17 * this.o2.hashCode();
        }
    }
}

